/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.MediaCodecBase;
import io.agora.rtc.video.MediaCodecVideoEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MediaCodecVideoDecoder
extends MediaCodecBase {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final boolean VERBOSE = false;
    private static final long MAX_DECODE_TIME_MS = 2000L;
    private static final int DEQUEUE_INPUT_TIMEOUT = 100000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance = null;
    private static MediaCodecVideoDecoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private boolean useAsyncMode = false;
    ByteBuffer[] inputBuffers;
    ByteBuffer[] outputBuffers;
    private long nativeHandle;
    private MediaCodecDecoderCallback decoderCallback = null;
    private HandlerThread asyncHandlerThread;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String H265_MIME_TYPE = "video/hevc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.rk.", "OMX.sprd.", "OMX.amlogic.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.hisi.", "OMX.k3.", "OMX.allwinner.", "OMX.MTK.", "OMX.Nvidia.", "OMX.Intel.", "OMX.MS.", "OMX.NVT."};
    private static final String[] supportedH265HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.rk.", "OMX.sprd.", "OMX.amlogic.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.hisi.", "OMX.k3.", "OMX.allwinner.", "OMX.MTK.", "OMX.Nvidia.", "OMX.Intel.", "OMX.MS.", "OMX.google."};
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391876);
    private static final List<Integer> supportedColorListAddOn = Arrays.asList(2135033992);
    private static AtomicInteger currentInstances = new AtomicInteger(0);
    private String codecName;
    private int supportCodecs;
    private int supportInstances = 1;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private int cropWidth;
    private int cropHeight;
    private boolean hasDecodedFirstFrame;
    private boolean isOMXHisi;
    private final Queue<TimeStamps> decodeStartTimeMsQueue = new ConcurrentLinkedQueue<TimeStamps>();
    private boolean useSurface;
    private SurfaceTextureHelper surfaceTextureHelper;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface = null;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ConcurrentLinkedQueue<DecodedOutputBuffer>();
    private static final int MAX_TEXTURE_BUFFER_COUNT = 16;
    private static boolean preferGoogleSoftwareDecoder = false;

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static boolean isAsyncModeSupported() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableH265HwCodec() {
        Logging.w(TAG, "H.265 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H265_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes) != null;
    }

    public static boolean isH265HwSupported() {
        return !hwDecoderDisabledTypes.contains(H265_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H265_MIME_TYPE, supportedH265HwCodecPrefixes) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    private static DecoderProperties findDecoder(String string, String[] stringArray) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.i(TAG, "Trying to find HW decoder for mime " + string);
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            int n;
            int n2;
            int n3;
            int n42;
            boolean bl;
            String string2;
            MediaCodecInfo mediaCodecInfo;
            block13: {
                block12: {
                    mediaCodecInfo = null;
                    try {
                        mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
                    }
                    if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
                    string2 = null;
                    for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                        if (!string3.equals(string)) continue;
                        string2 = mediaCodecInfo.getName();
                        break;
                    }
                    if (string2 == null) continue;
                    Logging.i(TAG, "Found candidate decoder: " + string2);
                    bl = false;
                    if (!preferGoogleSoftwareDecoder) break block12;
                    if (!string2.startsWith("OMX.google.")) break block13;
                    bl = true;
                    break block13;
                }
                for (String string4 : stringArray) {
                    if (!string2.startsWith(string4)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
            for (int n42 : codecCapabilities.colorFormats) {
                Logging.d(TAG, "   Color: 0x" + Integer.toHexString(n42));
            }
            if (string2.startsWith("OMX.rk.")) {
                return new DecoderProperties(string2, 21);
            }
            Object object = supportedColorList.iterator();
            while (object.hasNext()) {
                n3 = (Integer)object.next();
                int[] nArray = codecCapabilities.colorFormats;
                n42 = nArray.length;
                for (n2 = 0; n2 < n42; ++n2) {
                    n = nArray[n2];
                    if (n != n3) continue;
                    Logging.i(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n));
                    return new DecoderProperties(string2, n);
                }
            }
            if (Build.VERSION.SDK_INT < 21) continue;
            object = supportedColorListAddOn.iterator();
            while (object.hasNext()) {
                n3 = (Integer)object.next();
                int[] nArray = codecCapabilities.colorFormats;
                n42 = nArray.length;
                for (n2 = 0; n2 < n42; ++n2) {
                    n = nArray[n2];
                    if (n != n3) continue;
                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n));
                    return new DecoderProperties(string2, n);
                }
            }
        }
        Logging.i(TAG, "No HW decoder found for mime " + string);
        return null;
    }

    private void getDecoderProperties(int n) {
        String[] stringArray = new String[]{VP8_MIME_TYPE, VP9_MIME_TYPE, H264_MIME_TYPE, H265_MIME_TYPE};
        String string = null;
        this.supportCodecs = 0;
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                if (string2.equals(VP8_MIME_TYPE)) {
                    this.supportCodecs |= 1;
                } else if (string2.equals(H264_MIME_TYPE)) {
                    this.supportCodecs |= 2;
                } else if (string2.equals(H265_MIME_TYPE)) {
                    this.supportCodecs |= 4;
                }
                if (string != null || !string2.equals(stringArray[n])) continue;
                this.codecName = string = mediaCodecInfo.getName();
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(stringArray[n]);
                if (Build.VERSION.SDK_INT < 23) continue;
                this.supportInstances = codecCapabilities.getMaxSupportedInstances();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean initDecode(int n, int n2, int n3, SurfaceTextureHelper surfaceTextureHelper, boolean bl, Looper looper, long l, boolean bl2, EglBase.Context context, String string) {
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        if (currentInstances.get() >= this.supportInstances) {
            return false;
        }
        currentInstances.incrementAndGet();
        if (bl2) {
            this.surfaceTextureHelper = surfaceTextureHelper == null ? SurfaceTextureHelper.create("ahwdectex", context, 16) : surfaceTextureHelper;
            if (this.surfaceTextureHelper == null) {
                Logging.e(TAG, "failed to init decoder for surface output");
                return false;
            }
        }
        String string2 = null;
        this.useSurface = bl2;
        String[] stringArray = null;
        VideoCodecType videoCodecType = VideoCodecType.values()[n];
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string2 = VP8_MIME_TYPE;
            stringArray = supportedVp8HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string2 = VP9_MIME_TYPE;
            stringArray = supportedVp9HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string2 = H264_MIME_TYPE;
            stringArray = supportedH264HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H265) {
            string2 = H265_MIME_TYPE;
            stringArray = supportedH265HwCodecPrefixes;
        } else {
            throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(string2, stringArray);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        }
        Logging.i(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n2 + " x " + n3 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + bl2 + ". Use async mode: " + bl + ". nativeHandle: " + l);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n2;
            this.height = n3;
            this.stride = n2;
            this.sliceHeight = n3;
            this.cropWidth = n2;
            this.cropHeight = n3;
            if (null != decoderProperties.codecName && null != Build.HARDWARE && decoderProperties.codecName.startsWith("OMX.hisi.") && Build.HARDWARE.startsWith("bigfish")) {
                this.isOMXHisi = true;
                Logging.d(TAG, " bigfish isOMXHisi: " + this.isOMXHisi);
            } else {
                this.isOMXHisi = false;
            }
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string2, (int)n2, (int)n3);
            if (!bl2) {
                mediaFormat.setInteger("color-format", decoderProperties.colorFormat);
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                this.applyCustomConfig(mediaFormat, new String(Base64.decode((String)string, (int)0)));
            }
            Logging.d(TAG, "Format: " + mediaFormat);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.nativeHandle = l;
            this.useAsyncMode = bl;
            if (bl) {
                this.decoderCallback = new MediaCodecDecoderCallback();
                Looper looper2 = looper;
                if (looper2 == null) {
                    this.asyncHandlerThread = new HandlerThread("decoderAsyncHandler");
                    this.asyncHandlerThread.start();
                    looper2 = this.asyncHandlerThread.getLooper();
                }
                this.mediaCodec.setCallback((MediaCodec.Callback)this.decoderCallback, new Handler(looper2));
            }
            if (bl2) {
                this.textureListener = new TextureListener(this.surfaceTextureHelper, this.decoderCallback);
                this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            }
            this.mediaCodec.configure(mediaFormat, this.surface, null, 0);
            this.mediaCodec.start();
            Logging.d(TAG, "MediaCodec started");
            this.colorFormat = decoderProperties.colorFormat;
            if (!bl) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                this.inputBuffers = this.mediaCodec.getInputBuffers();
                Logging.i(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            }
            this.decodeStartTimeMsQueue.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(int n, int n2) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.i(TAG, "Java reset: " + n + " x " + n2);
        if (this.useAsyncMode) {
            this.mediaCodec.flush();
            LinkedHashSet<Integer> linkedHashSet = this.decoderCallback.availableInputIndexes;
            synchronized (linkedHashSet) {
                this.decoderCallback.availableInputIndexes.clear();
            }
            this.mediaCodec.start();
            Logging.d(TAG, "MediaCodec restarted");
        } else {
            this.mediaCodec.flush();
        }
        this.width = n;
        this.height = n2;
        this.decodeStartTimeMsQueue.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void release() {
        Object object;
        Logging.i(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        if (this.useAsyncMode) {
            if (this.asyncHandlerThread != null) {
                this.asyncHandlerThread.quit();
                this.asyncHandlerThread = null;
            }
            object = this.decoderCallback;
            synchronized (object) {
                this.decoderCallback.isObsolete = true;
            }
            this.decoderCallback = null;
        }
        object = new CountDownLatch(1);
        final MediaCodec mediaCodec = this.mediaCodec;
        Runnable runnable = new Runnable((CountDownLatch)object){
            final /* synthetic */ CountDownLatch val$releaseDone;
            {
                this.val$releaseDone = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    mediaCodec.stop();
                    mediaCodec.release();
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                this.val$releaseDone.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        currentInstances.decrementAndGet();
        if (this.useSurface) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private InputBufferInfo dequeueInputBufferAvailable() {
        InputBufferInfo inputBufferInfo;
        LinkedHashSet<Integer> linkedHashSet = this.decoderCallback.availableInputIndexes;
        synchronized (linkedHashSet) {
            Iterator iterator;
            if (this.decoderCallback.availableInputIndexes.isEmpty()) {
                try {
                    this.decoderCallback.availableInputIndexes.wait(100000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (!(iterator = this.decoderCallback.availableInputIndexes.iterator()).hasNext()) {
                Logging.e(TAG, "no input buffer available");
                inputBufferInfo = new InputBufferInfo(-1, null);
            } else {
                int n = (Integer)iterator.next();
                iterator.remove();
                try {
                    ByteBuffer byteBuffer = this.mediaCodec.getInputBuffer(n);
                    inputBufferInfo = new InputBufferInfo(n, byteBuffer);
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "failed to get input buffer for index " + n + " : " + illegalStateException);
                    inputBufferInfo = new InputBufferInfo(-2, null);
                }
            }
        }
        return inputBufferInfo;
    }

    private int dequeueInputBuffer() {
        try {
            return this.mediaCodec.dequeueInputBuffer(100000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n, int n2, long l, long l2, long l3) {
        try {
            TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), l2, l3);
            this.decodeStartTimeMsQueue.add(timeStamps);
            if (!this.useAsyncMode) {
                this.inputBuffers[n].position(0);
                this.inputBuffers[n].limit(n2);
            }
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        int n2;
        if (this.decodeStartTimeMsQueue.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.i(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    this.handleOutputFormatChanged(mediaFormat);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        return this.handleOutputBufferAvailable(n2, this.outputBuffers[n2], bufferInfo, this.getBufferColorFormat(n2));
    }

    private int getBufferColorFormat(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 21 && this.colorFormat == 2135033992) {
            MediaFormat mediaFormat = this.mediaCodec.getOutputFormat(n);
            n2 = mediaFormat.getInteger("color-format");
            if (this.isOMXHisi && n2 == 47) {
                n2 = 17;
            }
        }
        return n2;
    }

    private DecodedOutputBuffer handleOutputBufferAvailable(int n, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n2) {
        TimeStamps timeStamps = this.decodeStartTimeMsQueue.poll();
        if (timeStamps == null) {
            Logging.e(TAG, "decodeStartTimeMs empty, dropping decoded output");
            return null;
        }
        this.hasDecodedFirstFrame = true;
        long l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l > 2000L) {
            Logging.w(TAG, "Very high decode time: " + l + "ms.");
            l = 2000L;
        }
        return new DecodedOutputBuffer(n, byteBuffer, bufferInfo.offset, bufferInfo.size, n2, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStamp, timeStamps.ntpTimeStamp, l, SystemClock.elapsedRealtime(), this.decodeStartTimeMsQueue.size());
    }

    private void handleOutputFormatChanged(MediaFormat mediaFormat) {
        Logging.i(TAG, "Decoder format changed: " + mediaFormat.toString());
        int n = mediaFormat.getInteger("width");
        int n2 = mediaFormat.getInteger("height");
        if (this.hasDecodedFirstFrame && (n != this.width || n2 != this.height)) {
            Logging.w(TAG, "Decoder format changed. Configured " + this.width + "*" + this.height + ". New " + n + "*" + n2);
        }
        this.width = mediaFormat.getInteger("width");
        this.height = mediaFormat.getInteger("height");
        if (mediaFormat.containsKey("stride")) {
            this.stride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.sliceHeight = mediaFormat.getInteger("slice-height");
        }
        this.cropWidth = mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right") ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : this.width;
        this.cropHeight = mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top") ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : this.height;
        Logging.i(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
        Logging.i(TAG, "Crop width and height: " + this.cropWidth + " x " + this.cropHeight);
        this.stride = Math.max(this.width, this.stride);
        this.sliceHeight = Math.max(this.height, this.sliceHeight);
    }

    private void returnDecodedOutputBuffer(int n) throws IllegalStateException, MediaCodec.CodecException {
        if (this.useSurface) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n, false);
    }

    private DecodedTextureBuffer dequeueTextureBuffer(int n) {
        if (!this.useSurface) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeueOutputBuffer(n);
        if (decodedOutputBuffer != null) {
            this.dequeuedSurfaceOutputBuffers.offer(decodedOutputBuffer);
        }
        this.MaybeRenderDecodedTextureBuffer();
        DecodedTextureBuffer decodedTextureBuffer = this.textureListener.dequeueTextureBuffer();
        if (decodedTextureBuffer != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return decodedTextureBuffer;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length)) {
            ++this.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer2 = this.dequeuedSurfaceOutputBuffers.poll();
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer2.index, false);
            return new DecodedTextureBuffer(null, decodedOutputBuffer2.presentationTimeStampMs, decodedOutputBuffer2.timeStamp, decodedOutputBuffer2.ntpTimeStampMs, decodedOutputBuffer2.decodeTimeMs, SystemClock.elapsedRealtime() - decodedOutputBuffer2.endDecodeTimeMs, null, decodedOutputBuffer2.bufferedFrames);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.poll();
        if (decodedOutputBuffer == null) {
            return;
        }
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.textureListener.updateResolution(this.cropWidth, this.cropHeight);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    private native void deliverOutputYuvReady(DecodedOutputBuffer var1, long var2);

    private native void deliverOutputTextureReady(DecodedTextureBuffer var1, long var2);

    private static class TextureListener
    implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        private final Queue<DecodedOutputBuffer> decodedOutputBuffers = new LinkedList<DecodedOutputBuffer>();
        private final Queue<DecodedTextureBuffer> decodedTextureBuffers = new LinkedList<DecodedTextureBuffer>();
        private int width;
        private int height;
        private final DecodedTextureBufferCallback decodedTextureBufferCallback;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper, DecodedTextureBufferCallback decodedTextureBufferCallback) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
            this.decodedOutputBuffers.clear();
            this.decodedTextureBufferCallback = decodedTextureBufferCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            Object object = this.newFrameLock;
            synchronized (object) {
                this.decodedOutputBuffers.offer(decodedOutputBuffer);
            }
        }

        public boolean isWaitingForTexture() {
            return false;
        }

        public void updateResolution(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTextureFrameAvailable(int n, float[] fArray, long l) {
            Object object = this.newFrameLock;
            synchronized (object) {
                DecodedOutputBuffer decodedOutputBuffer = this.decodedOutputBuffers.poll();
                if (decodedOutputBuffer == null) {
                    Logging.d(MediaCodecVideoDecoder.TAG, "texture_dec:null output buffer.");
                    return;
                }
                VideoFrame.TextureBuffer textureBuffer = this.surfaceTextureHelper.createTextureBuffer(this.width, this.height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
                DecodedTextureBuffer decodedTextureBuffer = null;
                VideoFrame.TextureBuffer textureBuffer2 = this.surfaceTextureHelper.textureCopy(textureBuffer);
                textureBuffer.release();
                decodedTextureBuffer = new DecodedTextureBuffer(fArray, decodedOutputBuffer.presentationTimeStampMs, decodedOutputBuffer.timeStamp, decodedOutputBuffer.ntpTimeStampMs, decodedOutputBuffer.decodeTimeMs, SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs, textureBuffer2, decodedOutputBuffer.bufferedFrames);
                if (this.decodedTextureBufferCallback != null) {
                    this.decodedTextureBufferCallback.onDecodedTextureBufferAvailable(decodedTextureBuffer);
                } else {
                    this.decodedTextureBuffers.offer(decodedTextureBuffer);
                    this.newFrameLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DecodedTextureBuffer dequeueTextureBuffer() {
            int n = 6;
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.decodedTextureBuffers.isEmpty() && !this.decodedOutputBuffers.isEmpty()) {
                    try {
                        this.newFrameLock.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return this.decodedTextureBuffers.poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                this.surfaceTextureHelper.returnTextureFrame();
                this.decodedOutputBuffers.clear();
                for (DecodedTextureBuffer decodedTextureBuffer : this.decodedTextureBuffers) {
                    if (decodedTextureBuffer.textureBuffer == null) continue;
                    decodedTextureBuffer.textureBuffer.release();
                }
                this.decodedTextureBuffers.clear();
            }
        }

        private static interface DecodedTextureBufferCallback {
            public void onDecodedTextureBufferAvailable(DecodedTextureBuffer var1);
        }
    }

    @TargetApi(value=21)
    class MediaCodecDecoderCallback
    extends MediaCodec.Callback
    implements TextureListener.DecodedTextureBufferCallback {
        boolean isObsolete = false;
        final LinkedHashSet<Integer> availableInputIndexes = new LinkedHashSet();

        MediaCodecDecoderCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInputBufferAvailable(MediaCodec mediaCodec, int n) {
            LinkedHashSet<Integer> linkedHashSet = this.availableInputIndexes;
            synchronized (linkedHashSet) {
                this.availableInputIndexes.add(n);
                this.availableInputIndexes.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOutputBufferAvailable(MediaCodec mediaCodec, int n, MediaCodec.BufferInfo bufferInfo) {
            MediaCodecDecoderCallback mediaCodecDecoderCallback = this;
            synchronized (mediaCodecDecoderCallback) {
                if (this.isObsolete) {
                    Logging.w(MediaCodecVideoDecoder.TAG, "discarding output as this callback is obsolete.");
                    return;
                }
                int n2 = MediaCodecVideoDecoder.this.getBufferColorFormat(n);
                if (!MediaCodecVideoDecoder.this.useSurface) {
                    ByteBuffer byteBuffer = null;
                    try {
                        byteBuffer = MediaCodecVideoDecoder.this.mediaCodec.getOutputBuffer(n);
                    }
                    catch (IllegalStateException illegalStateException) {
                        Logging.e(MediaCodecVideoDecoder.TAG, "getOutputBuffer exception, index: " + n, illegalStateException);
                        return;
                    }
                    if (byteBuffer == null) {
                        Logging.e(MediaCodecVideoDecoder.TAG, "failed to get output buffer, index: " + n);
                        return;
                    }
                    DecodedOutputBuffer decodedOutputBuffer = MediaCodecVideoDecoder.this.handleOutputBufferAvailable(n, byteBuffer, bufferInfo, n2);
                    if (decodedOutputBuffer != null) {
                        MediaCodecVideoDecoder.this.deliverOutputYuvReady(decodedOutputBuffer, MediaCodecVideoDecoder.this.nativeHandle);
                    }
                    MediaCodecVideoDecoder.this.mediaCodec.releaseOutputBuffer(n, false);
                } else {
                    DecodedOutputBuffer decodedOutputBuffer = MediaCodecVideoDecoder.this.handleOutputBufferAvailable(n, null, bufferInfo, n2);
                    if (decodedOutputBuffer == null) {
                        MediaCodecVideoDecoder.this.mediaCodec.releaseOutputBuffer(n, false);
                    } else {
                        MediaCodecVideoDecoder.this.dequeuedSurfaceOutputBuffers.offer(decodedOutputBuffer);
                        MediaCodecVideoDecoder.this.MaybeRenderDecodedTextureBuffer();
                    }
                }
            }
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Logging.e(MediaCodecVideoDecoder.TAG, "onError " + codecException);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            Logging.w(MediaCodecVideoDecoder.TAG, "onOutputFormatChanged " + mediaFormat);
            MediaCodecVideoDecoder.this.handleOutputFormatChanged(mediaFormat);
        }

        @Override
        public void onDecodedTextureBufferAvailable(DecodedTextureBuffer decodedTextureBuffer) {
            MediaCodecVideoDecoder.this.MaybeRenderDecodedTextureBuffer();
            MediaCodecVideoDecoder.this.deliverOutputTextureReady(decodedTextureBuffer, MediaCodecVideoDecoder.this.nativeHandle);
        }
    }

    private static class DecodedTextureBuffer {
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStamp;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;
        private final long bufferedFrames;
        VideoFrame.TextureBuffer textureBuffer;

        public DecodedTextureBuffer(float[] fArray, long l, long l2, long l3, long l4, long l5, VideoFrame.TextureBuffer textureBuffer, long l6) {
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l;
            this.timeStamp = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.frameDelayMs = l5;
            this.textureBuffer = textureBuffer;
            this.bufferedFrames = l6;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final int imageFormat;
        public final ByteBuffer buffer;
        private final long presentationTimeStampMs;
        private final long timeStamp;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;
        private final long bufferedFrames;

        public DecodedOutputBuffer(int n, ByteBuffer byteBuffer, int n2, int n3, int n4, long l, long l2, long l3, long l4, long l5, long l6) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.buffer = byteBuffer;
            this.imageFormat = n4;
            this.presentationTimeStampMs = l;
            this.timeStamp = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.endDecodeTimeMs = l5;
            this.bufferedFrames = l6;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStamp;
        private final long ntpTimeStamp;

        public TimeStamps(long l, long l2, long l3) {
            this.decodeStartTimeMs = l;
            this.timeStamp = l2;
            this.ntpTimeStamp = l3;
        }
    }

    static class InputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;

        public InputBufferInfo(int n, ByteBuffer byteBuffer) {
            this.index = n;
            this.buffer = byteBuffer;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n) {
            this.codecName = string;
            this.colorFormat = n;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264,
        VIDEO_CODEC_H265;

    }
}

