/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Process;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.agora.rtc.internal.Logging;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "ViESurfaceRenderer";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private Rect source = new Rect();
    private Rect dest = new Rect();
    private float topScale = 0.0f;
    private float bottomScale = 1.0f;
    private float leftScale = 0.0f;
    private float rightScale = 1.0f;

    public ViESurfaceRenderer(SurfaceView surfaceView) {
        Logging.i(TAG, "surface view " + surfaceView);
        this.surfaceHolder = surfaceView.getHolder();
        if (this.surfaceHolder == null) {
            return;
        }
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.surfaceCreated(this.surfaceHolder);
    }

    private void changeDestRect(int n, int n2) {
        this.dest.right = (int)((float)this.dest.left + Math.abs(this.leftScale - this.rightScale) * (float)n);
        this.dest.bottom = (int)((float)this.dest.top + Math.abs(this.topScale - this.bottomScale) * (float)n2);
        Logging.i(TAG, "ViESurfaceRender::surfaceChanged in_width:" + n + " in_height:" + n2 + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom + " dest scale " + this.rightScale + " bottom scale " + this.bottomScale);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.changeDestRect(n2, n3);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            Rect rect = this.surfaceHolder.getSurfaceFrame();
            if (rect != null) {
                this.changeDestRect(rect.right - rect.left, rect.bottom - rect.top);
                Logging.i(TAG, "ViESurfaceRender::surfaceCreated dst.left:" + rect.left + " dst.top:" + rect.top + " dst.dest:" + rect.right + " dst.bottom:" + rect.bottom + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom);
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, "ViESurfaceRenderer::surfaceDestroyed");
        this.bitmap = null;
        this.byteBuffer = null;
    }

    public Bitmap CreateBitmap(int n, int n2) {
        Logging.d(TAG, "CreateByteBitmap " + n + ":" + n2);
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.source.left = 0;
        this.source.top = 0;
        this.source.bottom = n2;
        this.source.right = n;
        return this.bitmap;
    }

    public ByteBuffer CreateByteBuffer(int n, int n2) {
        Logging.i(TAG, "CreateByteBuffer " + n + " * " + n2);
        this.bitmap = this.CreateBitmap(n, n2);
        this.byteBuffer = ByteBuffer.allocateDirect(n * n2 * 2);
        return this.byteBuffer;
    }

    public void SetCoordinates(float f, float f2, float f3, float f4) {
        Logging.i(TAG, "SetCoordinates " + f + "," + f2 + " : " + f3 + "," + f4);
        this.leftScale = f;
        this.topScale = f2;
        this.rightScale = f3;
        this.bottomScale = f4;
    }

    private void saveBitmapToJPEG(int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.format("/sdcard/render_%d.jpg", System.currentTimeMillis()));
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
            Logging.i(TAG, "saved jpg " + fileOutputStream.toString());
        }
        catch (IOException iOException) {
            Logging.e(TAG, "save jpg failed", iOException);
        }
    }

    public void DrawByteBuffer() {
        if (this.byteBuffer == null) {
            Logging.w(TAG, "DrawByteBuffer null");
            return;
        }
        this.byteBuffer.rewind();
        this.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        this.DrawBitmap();
    }

    public void DrawBitmap() {
        if (this.bitmap == null) {
            return;
        }
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            canvas.drawBitmap(this.bitmap, this.source, this.dest, null);
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

