/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.RectF;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

public abstract class VideoCapture {
    private static final String TAG = VideoCapture.class.getSimpleName();
    private static final int kVideoI420 = 0;
    private static final int kVideoYV12 = 1;
    private static final int kVideoYUY2 = 2;
    private static final int kVideoNV12 = 11;
    private static final int kVideoNV21 = 12;
    private static final int kVideoUnknown = 99;
    protected int mCameraNativeOrientation;
    protected final Context mContext;
    protected final int mId;
    protected long mNativeVideoCaptureDeviceAndroid;
    @CaptureOutputDataType
    protected int mCaptureOutputDataType = 0;
    protected int mExpectedRawBufferSize = 0;
    protected final EglBase.Context mShareContext;
    protected EglBase.Context mEglContext;
    protected SurfaceTextureHelper mSurfaceTextureHelper;
    protected static final int MAX_BUFFER_CNT = 8;
    protected TextureAndRawBufferSynchronizer mTextureAndRawBufferSynchronizer = null;
    protected int mDroppedTextureBufferCount = 0;
    private int mLastRotation = -1;
    protected int mPQFirst = -1;
    public static final int kCaptureFpsUnknown = -1;
    public static final int kCaptureFpsDefault = 0;
    public static final int kCaptureFpsLowPower = 1;
    public static boolean FORCE_TEXTURE_OES = false;

    VideoCapture(Context context, int n, int n2, EglBase.Context context2, long l) {
        this.mNativeVideoCaptureDeviceAndroid = l;
        this.mContext = context;
        this.mId = n;
        this.mPQFirst = n2;
        this.mShareContext = context2;
    }

    public abstract int allocate();

    public abstract int setCaptureFormat(int var1, int var2, boolean var3);

    public abstract int startCapture(int var1, int var2, int var3);

    public abstract int stopCapture();

    public abstract boolean isTorchSupported();

    public abstract boolean isFocusSupported();

    public abstract boolean isZoomSupported();

    public abstract boolean isAutoFaceFocusSupported();

    public abstract int setZoom(float var1);

    public abstract float getMaxZoom();

    public abstract int setTorchMode(boolean var1);

    public abstract int setFocus(float var1, float var2, boolean var3);

    public abstract int setAutoFaceFocus(boolean var1);

    public abstract int setFaceDetection(boolean var1);

    public abstract boolean isExposureSupported();

    public abstract int setExposure(float var1, float var2, boolean var3);

    public abstract int setAntiBandingMode(int var1);

    public abstract int setExposureCompensation(int var1);

    public abstract int setNoiseReductionMode(int var1);

    public abstract int setEdgeEnhanceMode(int var1);

    public abstract int setVideoStabilityMode(int var1);

    public abstract int UnRegisterNativeHandle();

    public abstract void deallocate();

    public native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    public static native int ConvertFrameToI420(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7, byte[] var8);

    private native void ProvideCameraTexture(VideoFrame.TextureBuffer var1, int var2, long var3, long var5);

    private native void ProvideCameraTextureAndRaw(VideoFrame.TextureBuffer var1, int var2, long var3, byte[] var5, int var6, long var7);

    public native boolean isAutoFaceFocusEnabled(long var1);

    public native boolean isFaceDetectionEnabled(long var1);

    public native void NotifyCameraFocusAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyCameraExposureAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyFaceDetection(int var1, int var2, RectF[] var3, long var4, long var6);

    public native void onCameraError(long var1, @VideoCaptureEvent int var3);

    public native void onCameraFrameDropped(long var1, @VideoCaptureDropFrameReason int var3);

    public static String fetchCapability(int n, Context context, String string) {
        String string2 = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string2, 0);
        String string3 = sharedPreferences.getString("CaptureName", null);
        if (string3 == null || !string3.equals(string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.clear();
            editor.commit();
            return null;
        }
        return sharedPreferences.getString("Cam_" + n, null);
    }

    public static void clearCapabilityCache(Context context) {
        String string = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear().commit();
    }

    public static void cacheCapability(int n, Context context, String string, String string2) {
        String string3 = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("Cam_" + n, string);
        editor.putString("CaptureName", string2);
        editor.commit();
    }

    public static int translateToEngineFormat(int n) {
        switch (n) {
            case 17: {
                return 12;
            }
            case 842094169: {
                return 1;
            }
            case 35: {
                return 0;
            }
            case 20: {
                return 2;
            }
        }
        return 99;
    }

    public static int translateToAndroidFormat(int n) {
        switch (n) {
            case 12: {
                return 17;
            }
            case 1: {
                return 842094169;
            }
            case 0: {
                return 35;
            }
            case 2: {
                return 20;
            }
        }
        return 0;
    }

    @CaptureOutputDataType
    public static int translateToCaptureOutputDataType(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isEmulator() {
        if ("nokia".equalsIgnoreCase(Build.MANUFACTURER) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
            return false;
        }
        if (Build.FINGERPRINT != null && (Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys"))) {
            return true;
        }
        if (Build.MODEL != null && (Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MODEL.equalsIgnoreCase("MuMu"))) {
            return true;
        }
        if (Build.MANUFACTURER != null && Build.MANUFACTURER.contains("Genymotion")) {
            return true;
        }
        if (Build.BRAND != null && Build.BRAND.startsWith("generic") && Build.DEVICE != null && Build.DEVICE.startsWith("generic")) {
            return true;
        }
        if ("google_sdk".equalsIgnoreCase(Build.PRODUCT)) {
            return true;
        }
        String string = "";
        try {
            String[] stringArray = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader.close();
            string = stringBuffer.toString().toLowerCase();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return string.contains("intel") || string.contains("amd");
    }

    protected int checkOrientation() {
        Display display;
        if (this.mContext != null && this.mContext.getSystemService("window") != null && (display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                int n = display.getRotation();
                return n;
            }
            catch (RuntimeException runtimeException) {
                Logging.e("VideoCapture", "video capture checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }

    public static boolean checkVideoPermission(Context context) {
        return context != null && context.checkCallingOrSelfPermission("android.permission.CAMERA") == 0;
    }

    protected void onRawBufferAvailable(byte[] byArray, int n, int n2, int n3, int n4) {
        AgoraVideoDebugger.onRawBufferAvailable(this, byArray, n, n2, n3, n4);
        if (this.mCaptureOutputDataType == 0) {
            this.ProvideCameraFrame(byArray, n, this.mNativeVideoCaptureDeviceAndroid);
        } else if (this.mCaptureOutputDataType == 2) {
            this.mTextureAndRawBufferSynchronizer.onRawBufferAvailable(byArray, n);
        }
    }

    protected void onTextureBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n, long l) {
        VideoFrame.TextureBuffer textureBuffer2 = null;
        if (this.mSurfaceTextureHelper != null) {
            textureBuffer2 = FORCE_TEXTURE_OES ? textureBuffer : this.mSurfaceTextureHelper.textureCopy(textureBuffer);
        }
        if (textureBuffer2 == null) {
            ++this.mDroppedTextureBufferCount;
            if (this.mDroppedTextureBufferCount % 50 == 1) {
                Logging.w(TAG, "Dropped texture buffer count: " + this.mDroppedTextureBufferCount);
            }
            if (this.mCaptureOutputDataType == 2) {
                this.mTextureAndRawBufferSynchronizer.onDropTextureBuffer(l);
            }
            AgoraVideoDebugger.onDropTextureBuffer(l);
            this.onCameraFrameDropped(this.mNativeVideoCaptureDeviceAndroid, 1);
            return;
        }
        ATrace.beginSection("onTextureBufferAvailable");
        AgoraVideoDebugger.onTextureBufferAvailable(this, this.mEglContext, textureBuffer2, n, l);
        if (this.mCaptureOutputDataType == 1) {
            this.ProvideCameraTexture(textureBuffer2, n, l, this.mNativeVideoCaptureDeviceAndroid);
        } else if (this.mCaptureOutputDataType == 2) {
            this.mTextureAndRawBufferSynchronizer.onTextureBufferAvailable(textureBuffer2, n, l);
        }
        ATrace.endSection();
        textureBuffer2.release();
    }

    protected void onTextureAndRawBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n, long l, byte[] byArray, int n2) {
        AgoraVideoDebugger.onTextureAndRawBufferAvailable(this, textureBuffer, n, l, byArray, n2);
        this.ProvideCameraTextureAndRaw(textureBuffer, n, l, byArray, n2, this.mNativeVideoCaptureDeviceAndroid);
    }

    protected static class TexBuffer {
        VideoFrame.TextureBuffer textureBuffer;
        int rotation;
        long timestampNs;

        TexBuffer(VideoFrame.TextureBuffer textureBuffer, int n, long l) {
            this.textureBuffer = textureBuffer;
            this.rotation = n;
            this.timestampNs = l;
        }
    }

    protected static class RawBuffer {
        byte[] data;
        int length;

        RawBuffer(byte[] byArray, int n) {
            this.data = byArray;
            this.length = n;
        }
    }

    protected class TextureAndRawBufferSynchronizer {
        Queue<RawBuffer> rawBufferQueue = new LinkedList<RawBuffer>();
        Queue<TexBuffer> texBufferQueue = new LinkedList<TexBuffer>();
        int pendingRemoveRawBufferCount = 0;

        protected TextureAndRawBufferSynchronizer() {
        }

        void onRawBufferAvailable(byte[] byArray, int n) {
            this.checkAndResetIfNeeded();
            if (this.pendingRemoveRawBufferCount > 0) {
                --this.pendingRemoveRawBufferCount;
                return;
            }
            TexBuffer texBuffer = this.texBufferQueue.poll();
            if (texBuffer != null) {
                VideoCapture.this.onTextureAndRawBufferAvailable(texBuffer.textureBuffer, texBuffer.rotation, texBuffer.timestampNs, byArray, n);
                texBuffer.textureBuffer.release();
            } else {
                this.rawBufferQueue.offer(new RawBuffer(Arrays.copyOf(byArray, n), n));
            }
        }

        void onTextureBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n, long l) {
            this.checkAndResetIfNeeded();
            RawBuffer rawBuffer = this.rawBufferQueue.poll();
            if (rawBuffer != null) {
                VideoCapture.this.onTextureAndRawBufferAvailable(textureBuffer, n, l, rawBuffer.data, rawBuffer.length);
            } else {
                textureBuffer.retain();
                this.texBufferQueue.offer(new TexBuffer(textureBuffer, n, l));
            }
        }

        void onDropTextureBuffer(long l) {
            RawBuffer rawBuffer = this.rawBufferQueue.poll();
            if (rawBuffer == null) {
                ++this.pendingRemoveRawBufferCount;
            }
        }

        void reset() {
            Logging.i(TAG, "TextureAndRawBufferSynchronizer reset");
            this.rawBufferQueue.clear();
            for (TexBuffer texBuffer : this.texBufferQueue) {
                texBuffer.textureBuffer.release();
            }
            this.texBufferQueue.clear();
            this.pendingRemoveRawBufferCount = 0;
        }

        private void checkAndResetIfNeeded() {
            if (this.texBufferQueue.size() > 16 || this.rawBufferQueue.size() > 16) {
                String string = this.texBufferQueue.size() > 16 ? "raw" : "texture";
                Logging.e(TAG, string + " buffer stall, something is broken!");
                this.reset();
            }
        }
    }

    static @interface VideoCaptureDropFrameReason {
        public static final int kCameraDropFrameReasonTextureCopy = 1;
    }

    static @interface VideoCaptureEvent {
        public static final int kVideoCaptureEventNone = 0;
        public static final int kCameraErrorCameraInUse = 1;
        public static final int kCameraErrorMaxCamerasInUse = 2;
        public static final int kCameraErrorCameraDisabled = 3;
        public static final int kCameraErrorCameraDevice = 4;
        public static final int kCameraErrorCameraService = 5;
        public static final int kCameraErrorDisconnected = 6;
        public static final int kCameraErrorDeviceNotFound = 7;
        public static final int kCameraErrorNoPermission = 8;
        public static final int kCameraErrorConfigureInitiation = 100;
        public static final int kCameraErrorConfigureSession = 101;
        public static final int kCameraErrorConfigureRequest = 102;
        public static final int kCameraErrorRuntimeUnknown = 901;
    }

    static @interface CaptureOutputDataType {
        public static final int CAPTURE_OUTPUT_RAW = 0;
        public static final int CAPTURE_OUTPUT_TEXTURE = 1;
        public static final int CAPTURE_OUTPUT_TEXTURE_AND_RAW = 2;
    }
}

