/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "CAMERA1";
    private static final boolean VERBOSE = false;
    private static final int CAMERA_ALLOCATE_TIMEOUT_MS = 6000;
    protected Camera mCamera;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private ReentrantLock mCaptureLock = new ReentrantLock();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private boolean isFaceDetectionStarted = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 17;
    private static final long CAMERA_OPEN_REQUEST_INTERVAL = 2000L;
    private HandlerThread mCameraPreviewHandlerThread = null;
    private Handler mPreviewHandler = null;
    private volatile int mAllocated;
    private Object mObjectLock = new Object();
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDetectEnabled = false;
    private String mAntiBandingMode = "auto";
    private final boolean mIsCameraFacingFront;
    private static final int NUM_OF_CAPTURE_BUFFERS = 3;
    private SurfaceTexture mDummySurfaceTexture = null;

    VideoCaptureCamera(Context context, int n, int n2, EglBase.Context context2, long l) {
        super(context, n, n2, context2, l);
        this.mIsCameraFacingFront = VideoCaptureCamera.isCameraFacingFront(n);
    }

    static boolean isCameraFacingFront(int n) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n);
        if (cameraInfo != null) {
            return cameraInfo.facing == 1;
        }
        return true;
    }

    protected static Camera.CameraInfo getCameraInfo(int n) {
        if (n < 0 || n > Camera.getNumberOfCameras() - 1) {
            return null;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: ", runtimeException);
            return null;
        }
        return cameraInfo;
    }

    public static int getFrontCameraIndex() {
        int n = 0;
        try {
            n = Camera.getNumberOfCameras() > 1 ? 1 : 0;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
        return n;
    }

    static int getNumberOfCameras() {
        int n = Camera.getNumberOfCameras();
        Logging.e(TAG, "camera1 listCount:" + n);
        return n;
    }

    static String getName(int n) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n);
        if (cameraInfo == null) {
            return null;
        }
        return "camera " + n + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    static String getCaptureName() {
        return "camera1";
    }

    static int getSensorOrientation(int n) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n);
        if (cameraInfo == null) {
            return -1;
        }
        return cameraInfo.orientation;
    }

    @Override
    public int UnRegisterNativeHandle() {
        Logging.d(TAG, "UnRegisterNativeHandle called");
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        return 0;
    }

    @Override
    public int allocate() {
        if (this.mCameraPreviewHandlerThread == null) {
            this.mCameraPreviewHandlerThread = new HandlerThread("camera-preview-thread");
            this.mCameraPreviewHandlerThread.start();
            if (this.mCameraPreviewHandlerThread != null) {
                this.mPreviewHandler = new Handler(this.mCameraPreviewHandlerThread.getLooper());
            }
        }
        this.mAllocated = -1;
        if (this.mPreviewHandler != null) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            this.mPreviewHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.mAllocated = VideoCaptureCamera.this.allocate_l();
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await(6000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.mAllocated;
    }

    private int allocate_l() {
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "allocate: Camera.open: ", runtimeException);
            return -1;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            this.mCamera.release();
            this.mCamera = null;
            return -2;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext, VideoCaptureCamera.getCaptureName()) == null) {
            this.createCapabilities();
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        this.faceDetectEnabled = this.isFaceDetectionEnabled(this.mNativeVideoCaptureDeviceAndroid);
        return 0;
    }

    @Override
    public int setCaptureFormat(int n, int n2, boolean bl) {
        Logging.i(TAG, "setCaptureFormat: " + n + " type: " + n2 + " force texture oes: " + bl);
        VideoCapture.FORCE_TEXTURE_OES = bl;
        this.mCaptureOutputDataType = VideoCaptureCamera.translateToCaptureOutputDataType(n2);
        this.mCaptureFormat = VideoCaptureCamera.translateToAndroidFormat(n);
        if (this.mCaptureFormat == 0) {
            Logging.e(TAG, "setCaptureFormat failed, unkonwn format: " + n);
            return -1;
        }
        return 0;
    }

    private int tryStartCapture(int n, int n2, int n3) {
        if (this.mCamera == null) {
            Logging.e(TAG, "Camera not initialized %d" + this.mId);
            return -1;
        }
        Logging.i(TAG, "tryStartCapture: " + n + "*" + n2 + ", frameRate: " + n3 + ", isCaptureRunning: " + this.isCaptureRunning + ", isSurfaceReady: " + this.isSurfaceReady + ", isCaptureStarted: " + this.isCaptureStarted + ", outputDataType: " + this.mCaptureOutputDataType);
        if (this.isCaptureRunning || !this.isCaptureStarted) {
            Logging.w(TAG, "tryStartCapture return");
            return 0;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewSize(n, n2);
        parameters.setPreviewFormat(this.mCaptureFormat);
        if (this.mPQFirst < 1) {
            Logging.i(TAG, "camera1::fps first");
            this.setPreviewFrameRateModeFPS(parameters, n3);
        } else {
            Logging.i(TAG, "camera1::PQ first");
            this.setPreviewFrameRateModePQ(parameters, n3);
        }
        this.setAdvancedCameraParameters(parameters);
        this.setDeviceSpecificParameters(parameters);
        this.mCamera.setParameters(parameters);
        int n4 = 0;
        if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
            n4 = n * n2 * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
            n4 += 4096;
            byte[] byArray = null;
            for (int i = 0; i < 3; ++i) {
                byArray = new byte[n4];
                this.mCamera.addCallbackBuffer(byArray);
            }
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.mCamera.setErrorCallback(new Camera.ErrorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(int n, Camera camera) {
                Logging.e(VideoCaptureCamera.TAG, "onError: error code " + n);
                if (VideoCaptureCamera.this.mCamera != null) {
                    VideoCaptureCamera.this.stopCapture();
                    VideoCaptureCamera.this.mCaptureLock.lock();
                    try {
                        if (VideoCaptureCamera.this.mCamera != null) {
                            VideoCaptureCamera.this.mCamera.release();
                            VideoCaptureCamera.this.mCamera = null;
                        }
                    }
                    catch (Exception exception) {
                        Logging.e(VideoCaptureCamera.TAG, "Camera release failed, " + exception);
                    }
                    finally {
                        VideoCaptureCamera.this.mCaptureLock.unlock();
                    }
                }
                if (VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    int n2 = 901;
                    if (n == 2) {
                        n2 = 6;
                    } else if (n == 100) {
                        n2 = 5;
                    }
                    VideoCaptureCamera.this.onCameraError(VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid, n2);
                }
            }
        });
        this.mCamera.startPreview();
        if (this.isAutoFaceFocusSupported()) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){
                private long mLastFocusedTs;

                public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                    if (VideoCaptureCamera.this.faceDetectEnabled) {
                        VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                    }
                    if (faceArray == null || faceArray.length == 0 || camera == null || !VideoCaptureCamera.this.mIsAutoFaceFocusEnabled) {
                        return;
                    }
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faceArray[0].score > 20) {
                            VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                        }
                        return;
                    }
                    if (faceArray[0].score <= 50) {
                        Logging.i(VideoCaptureCamera.TAG, "face score = " + faceArray[0].score);
                        return;
                    }
                    try {
                        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
                        Camera.Area area = new Camera.Area(faceArray[0].rect, 1000);
                        arrayList.add(area);
                        if (camera.getParameters().getMaxNumFocusAreas() > 0) {
                            camera.getParameters().setFocusAreas(arrayList);
                        }
                        if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                            camera.getParameters().setMeteringAreas(arrayList);
                        }
                        VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                        camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean bl, Camera camera) {
                                Logging.d(VideoCaptureCamera.TAG, "auto face focus called api1 every 3 seconds");
                                try {
                                    if (camera != null) {
                                        camera.cancelAutoFocus();
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    Logging.w(VideoCaptureCamera.TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)runtimeException));
                                }
                            }
                        });
                        this.mLastFocusedTs = System.currentTimeMillis();
                    }
                    catch (RuntimeException runtimeException) {
                        Logging.w(VideoCaptureCamera.TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)runtimeException));
                    }
                }
            });
            if (this.mIsAutoFaceFocusEnabled || this.faceDetectEnabled) {
                this.startFaceDetection();
            }
        } else if (this.isFaceDetectedSupported()) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                    if (VideoCaptureCamera.this.faceDetectEnabled) {
                        VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                    }
                }
            });
            if (this.faceDetectEnabled) {
                this.startFaceDetection();
            }
        }
        this.mPreviewBufferLock.lock();
        this.mExpectedRawBufferSize = n4;
        this.isCaptureRunning = true;
        this.mPreviewBufferLock.unlock();
        parameters = this.mCamera.getParameters();
        Logging.i(TAG, "Params: " + parameters.flatten());
        return 0;
    }

    private void startFaceDetection() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.startFaceDetection_l();
                }
            });
        }
    }

    private void startFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        try {
            Logging.i(TAG, "enable face detection");
            this.mCamera.startFaceDetection();
            this.isFaceDetectionStarted = true;
        }
        catch (Exception exception) {
            Logging.e(TAG, "start face detection failed:" + exception);
            this.mCamera.stopFaceDetection();
            this.isFaceDetectionStarted = false;
        }
    }

    private void stopFaceDetection() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.stopFaceDetection_l();
                }
            });
        }
    }

    private void stopFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        Logging.i(TAG, "disable face detection");
        this.mCamera.stopFaceDetection();
        this.isFaceDetectionStarted = false;
    }

    private void notifyCameraFocusAreaChanged(Rect rect) {
        boolean bl = false;
        if (this.mId == 1) {
            bl = true;
        }
        RectF rectF = CoordinatesTransform.normalizedFaceRect(rect, 0, bl);
        float f = rectF.left;
        float f2 = rectF.top;
        float f3 = rectF.width();
        float f4 = rectF.height();
        Logging.d(TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom);
        this.NotifyCameraFocusAreaChanged(f, f2, f3, f4, this.mNativeVideoCaptureDeviceAndroid);
    }

    private void notifyFaceDetection(Camera.Face[] faceArray) {
        this.rectArray = null;
        int n = 0;
        boolean bl = false;
        if (this.mId == 1) {
            bl = true;
        }
        if (faceArray != null && faceArray.length > 0) {
            n = faceArray.length;
            this.rectArray = new RectF[n];
            this.distanceArray = new int[n];
            for (int i = 0; i < n; ++i) {
                this.rectArray[i] = CoordinatesTransform.normalizedFaceRect(faceArray[i].rect, 0, bl);
                this.distanceArray[i] = 5;
            }
        } else {
            this.rectArray = new RectF[0];
        }
        this.NotifyFaceDetection(this.mCaptureWidth, this.mCaptureHeight, this.rectArray, n, this.mNativeVideoCaptureDeviceAndroid);
    }

    private void setPreviewFrameRateModePQ(Camera.Parameters parameters, int n) {
        List list = parameters.getSupportedPreviewFrameRates();
        if (list == null || list.size() == 0) {
            Logging.w(TAG, "setPreviewFrameRate: camera don't supported PQ first.");
            this.setPreviewFrameRateModeFPS(parameters, n);
        } else {
            Logging.w(TAG, "getSupportedPreviewFrameRates: " + list.toString());
            int n2 = Math.abs((Integer)list.get(0) - n);
            int n3 = (Integer)list.get(0);
            for (Integer n4 : list) {
                int n5 = Math.abs(n4 - n);
                if (n5 >= n2) continue;
                n2 = n5;
                n3 = n4;
            }
            parameters.setPreviewFrameRate(n3);
        }
    }

    private void setPreviewFrameRateModeFPS(Camera.Parameters parameters, int n) {
        List list = parameters.getSupportedPreviewFpsRange();
        if (list == null || list.size() <= 0) {
            parameters.setPreviewFrameRate(n);
        } else {
            int n2;
            for (n2 = 0; n2 < list.size(); ++n2) {
                if (((int[])list.get(n2))[0] < n * 1000) continue;
                parameters.setPreviewFpsRange(((int[])list.get(n2))[0], ((int[])list.get(n2))[1]);
                break;
            }
            if (n2 == list.size()) {
                parameters.setPreviewFpsRange(((int[])list.get(n2 - 1))[0], ((int[])list.get(n2 - 1))[1]);
            }
        }
    }

    @Override
    public int setZoom(float f) {
        final float f2 = f;
        if (this.mPreviewHandler != null) {
            Integer n = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.setZoom_l(f2);
                    return n;
                }
            });
            return n;
        }
        return -1;
    }

    private int setZoom_l(float f) {
        Camera.Parameters parameters;
        int n;
        if (f < 0.0f) {
            return -1;
        }
        int n2 = (int)(f * 100.0f + 0.5f);
        List<Integer> list = this.getZoomRatios();
        if (list == null) {
            return -1;
        }
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            n = list.get(i);
            if (n2 > n) continue;
            n3 = i;
            break;
        }
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            n = parameters.getMaxZoom();
            if (n3 > n) {
                Logging.w(TAG, "zoom value is larger than maxZoom value");
                return -1;
            }
            parameters.setZoom(n3);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.w(TAG, "setParameters failed, zoomLevel: " + n3 + ", " + exception);
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mPreviewHandler != null) {
            Float f = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Float>(){

                @Override
                public Float call() {
                    float f = VideoCaptureCamera.this.getMaxZoom_l();
                    return Float.valueOf(f);
                }
            });
            return f.floatValue();
        }
        return -1.0f;
    }

    private float getMaxZoom_l() {
        if (this.mCamera != null) {
            List<Integer> list;
            Camera.Parameters parameters = this.getCameraParameters();
            int n = 0;
            if (this.isZoomSupported(parameters)) {
                n = parameters.getMaxZoom();
            }
            if ((list = this.getZoomRatios()) != null && list.size() > n) {
                return (float)list.get(n).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    @Override
    public int setTorchMode(boolean bl) {
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.setTorchMode_l(bl2);
                    return n;
                }
            });
            return n;
        }
        return -1;
    }

    private int setTorchMode_l(boolean bl) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            List list = parameters.getSupportedFlashModes();
            if (list != null && list.contains("torch")) {
                if (bl) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    @Override
    public int setFocus(float f, float f2, boolean bl) {
        final float f3 = f;
        final float f4 = f2;
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.setFocus_l(f3, f4, bl2);
                    return n;
                }
            });
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setFocus_l(float f, float f2, boolean bl) {
        Object object;
        Logging.d(TAG, "setFocus called camera api1");
        if (this.mCamera == null) {
            return -1;
        }
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        Rect rect = VideoCaptureCamera.calculateTapArea(f, f2, 1.0f);
        Rect rect2 = VideoCaptureCamera.calculateTapArea(f, f2, 1.5f);
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException runtimeException) {
            Logging.w(TAG, "Failed to cancle AutoFocus" + runtimeException);
        }
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters == null) {
            return -1;
        }
        if (parameters.getMaxNumFocusAreas() > 0) {
            object = new ArrayList<Camera.Area>();
            object.add(new Camera.Area(rect, 800));
            parameters.setFocusAreas((List)object);
        } else {
            Logging.i(TAG, "focus areas not supported");
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            object = new ArrayList();
            object.add(new Camera.Area(rect2, 800));
            parameters.setMeteringAreas((List)object);
        } else {
            Logging.i(TAG, "metering areas not supported");
        }
        object = parameters.getFocusMode();
        if (VideoCaptureCamera.isSupported("macro", parameters.getSupportedFocusModes())) {
            parameters.setFocusMode("macro");
            Object object2 = this.mObjectLock;
            synchronized (object2) {
                this.mCamera.setParameters(parameters);
            }
        } else {
            Logging.i("focus", "FOCUS_MODE_MACRO is not supported");
        }
        try {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback((String)object){
                final /* synthetic */ String val$currentFocusMode;
                {
                    this.val$currentFocusMode = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAutoFocus(boolean bl, Camera camera) {
                    if (VideoCaptureCamera.this.mCamera == null) {
                        return;
                    }
                    Camera.Parameters parameters = camera.getParameters();
                    parameters.setFocusMode(this.val$currentFocusMode);
                    Object object = VideoCaptureCamera.this.mObjectLock;
                    synchronized (object) {
                        camera.setParameters(parameters);
                    }
                }
            });
        }
        catch (Exception exception) {
            Logging.w(TAG, "mCamera.autoFocus Exception: " + exception);
            return -1;
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraFocusAreaChanged(f, f2, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setExposure(float f, float f2, boolean bl) {
        final float f3 = f;
        final float f4 = f2;
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.setExposure_l(f3, f4, bl2);
                    return n;
                }
            });
            return n;
        }
        return -1;
    }

    private int setExposure_l(float f, float f2, boolean bl) {
        Logging.d(TAG, "setExposure called camera api1 x = " + f + " y = " + f2);
        if (this.mCamera == null) {
            return -1;
        }
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        Rect rect = VideoCaptureCamera.calculateTapArea(f, f2, 1.5f);
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters == null) {
                return -1;
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
                arrayList.add(new Camera.Area(rect, 800));
                parameters.setMeteringAreas(arrayList);
            } else {
                Logging.i(TAG, "metering areas not supported");
            }
            try {
                this.mCamera.setParameters(parameters);
                this.mCamera.startPreview();
            }
            catch (Exception exception) {
                Logging.e(TAG, "setExposure failed, " + exception);
                return -1;
            }
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(f, f2, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setAutoFaceFocus(boolean bl) {
        Logging.d(TAG, "setAutoFaceFocus: " + bl);
        boolean bl2 = this.mIsAutoFaceFocusEnabled != bl;
        this.mIsAutoFaceFocusEnabled = bl;
        if (this.isAutoFaceFocusSupported() && bl2) {
            if (this.mIsAutoFaceFocusEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.mIsAutoFaceFocusEnabled && this.isFaceDetectionStarted && !this.faceDetectEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int setFaceDetection(boolean bl) {
        Logging.d(TAG, "setFaceDetection: " + bl);
        boolean bl2 = this.faceDetectEnabled != bl;
        this.faceDetectEnabled = bl;
        if (this.isFaceDetectedSupported() && bl2) {
            if (this.faceDetectEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.faceDetectEnabled && this.isFaceDetectionStarted && !this.mIsAutoFaceFocusEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int startCapture(int n, int n2, int n3) {
        final int n4 = n;
        final int n5 = n2;
        final int n6 = n3;
        if (this.mPreviewHandler != null) {
            Integer n7 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.startCapture_l(n4, n5, n6);
                    return n;
                }
            });
            return n7;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startCapture_l(int n, int n2, int n3) {
        Logging.i(TAG, "startCapture, w=" + n + ", h=" + n2 + ", fps=" + n3);
        if (this.mCamera == null) {
            Logging.e(TAG, "startCapture: camera is null!!");
            return -1;
        }
        SurfaceTexture surfaceTexture = null;
        if (this.mCaptureOutputDataType == 1 || this.mCaptureOutputDataType == 2) {
            this.mSurfaceTextureHelper = SurfaceTextureHelper.create("Camera1Tex-" + this.mId, this.mShareContext, 8);
            if (this.mSurfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create SurfaceTextureHelper, force fallback to raw data type");
                this.mCaptureOutputDataType = 0;
            } else {
                this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(n, n2);
                this.mSurfaceTextureHelper.startListening(this);
                this.mEglContext = this.mSurfaceTextureHelper.getEglContext();
                surfaceTexture = this.mSurfaceTextureHelper.getSurfaceTexture();
                if (this.mCaptureOutputDataType == 2 && this.mTextureAndRawBufferSynchronizer == null) {
                    this.mTextureAndRawBufferSynchronizer = new VideoCapture.TextureAndRawBufferSynchronizer(this);
                }
            }
        }
        int n4 = 0;
        if (this.mCaptureOutputDataType == 0) {
            if (this.mDummySurfaceTexture == null) {
                try {
                    this.mDummySurfaceTexture = new SurfaceTexture(42);
                }
                catch (Surface.OutOfResourcesException outOfResourcesException) {
                    Logging.e(TAG, "failed to create dummy SurfaceTexture!");
                }
            }
            surfaceTexture = this.mDummySurfaceTexture;
        }
        if (surfaceTexture == null) {
            n4 = -1;
        } else {
            this.mCaptureLock.lock();
            try {
                this.mCamera.setPreviewTexture(surfaceTexture);
            }
            catch (Exception exception) {
                Logging.e(TAG, "failed to set preview texture, invalid surfaceTexture!");
                this.mDummySurfaceTexture = null;
                n4 = -1;
            }
            finally {
                this.mCaptureLock.unlock();
            }
        }
        if (n4 != 0) {
            return n4;
        }
        this.mCaptureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = n;
        this.mCaptureHeight = n2;
        this.mCaptureFps = n3;
        try {
            n4 = this.tryStartCapture(n, n2, n3);
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "try start capture failed " + throwable);
            n4 = -1;
        }
        finally {
            this.mCaptureLock.unlock();
        }
        return n4;
    }

    @Override
    public int stopCapture() {
        if (this.mPreviewHandler != null) {
            Integer n = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.stopCapture_l();
                    return n;
                }
            });
            return n;
        }
        return -1;
    }

    private int stopCapture_l() {
        if (!this.isCaptureStarted) {
            Logging.w(TAG, "already stop capture");
            return 0;
        }
        try {
            if (this.isFaceDetectionStarted) {
                this.stopFaceDetection();
                this.mCamera.setFaceDetectionListener(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop face detection", runtimeException);
        }
        int n = 0;
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to cancle AutoFocus", runtimeException);
        }
        try {
            this.mPreviewBufferLock.lock();
            this.isCaptureRunning = false;
            this.mCamera.stopPreview();
            this.mCamera.setErrorCallback(null);
            AgoraVideoDebugger.reset();
            this.mDroppedTextureBufferCount = 0;
            if (this.mTextureAndRawBufferSynchronizer != null) {
                this.mTextureAndRawBufferSynchronizer.reset();
            }
            if (this.mSurfaceTextureHelper != null) {
                this.mSurfaceTextureHelper.stopListening();
                this.mSurfaceTextureHelper.dispose();
                this.mSurfaceTextureHelper = null;
            }
            this.mEglContext = null;
            if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop camera", runtimeException);
            n = -1;
        }
        this.mPreviewBufferLock.unlock();
        if (n == 0) {
            this.isCaptureStarted = false;
        }
        return n;
    }

    @Override
    public boolean isTorchSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isTorchSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isTorchSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCaptureCamera.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    @Override
    public boolean isFocusSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isFocusSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isFocusSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            boolean bl = parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
            return bl;
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isExposureSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isExposureSupported_l() {
        Camera.Parameters parameters;
        boolean bl = false;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            bl = parameters.getMaxNumMeteringAreas() > 0;
        }
        return bl;
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isZoomSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isZoomSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.isZoomSupported();
        }
        return false;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isAutoFaceFocusSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isAutoFaceFocusSupported_l() {
        Camera.Parameters parameters;
        return this.mCamera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
    }

    private boolean isFaceDetectedSupported() {
        Camera.Parameters parameters;
        return this.mCamera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0;
    }

    @Override
    public void deallocate() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.deallocate_l();
                }
            });
        }
        if (this.mPreviewHandler != null) {
            this.mPreviewHandler.removeCallbacksAndMessages(null);
        }
        if (this.mCameraPreviewHandlerThread != null) {
            this.mCameraPreviewHandlerThread.quit();
            this.mCameraPreviewHandlerThread = null;
            this.mPreviewHandler = null;
        }
    }

    private void deallocate_l() {
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        this.stopCapture();
        this.mCaptureLock.lock();
        try {
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "Camera release failed, " + exception);
        }
        finally {
            this.mCaptureLock.unlock();
        }
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        try {
            this.mPreviewBufferLock.lock();
            if (byArray == null || !this.isCaptureRunning) {
                return;
            }
            if (byArray.length == this.mExpectedRawBufferSize && this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.onRawBufferAvailable(byArray, this.mExpectedRawBufferSize, this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFormat);
            } else if (this.mNativeVideoCaptureDeviceAndroid == 0L) {
                Logging.w(TAG, "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            }
        }
        finally {
            if (camera != null && this.isCaptureRunning) {
                camera.addCallbackBuffer(byArray);
            }
            this.mPreviewBufferLock.unlock();
        }
    }

    @Override
    public void onTextureFrameAvailable(int n, float[] fArray, long l) {
        int n2 = this.getFrameOrientation();
        if (this.mIsCameraFacingFront) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        VideoFrame.TextureBuffer textureBuffer = this.mSurfaceTextureHelper.createTextureBuffer(this.mCaptureWidth, this.mCaptureHeight, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
        this.onTextureBufferAvailable(textureBuffer, n2, l);
        textureBuffer.release();
    }

    private static boolean isSupported(String string, List<String> list) {
        return list == null ? false : list.indexOf(string) >= 0;
    }

    private void setAdvancedCameraParameters(Camera.Parameters parameters) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = "off";
        if (VideoCaptureCamera.isSupported(string5, parameters.getSupportedFlashModes())) {
            Logging.i(TAG, "AgoraVideo set flash mode = FLASH_MODE_OFF");
            parameters.setFlashMode(string5);
        }
        if (VideoCaptureCamera.isSupported(string4 = "auto", parameters.getSupportedWhiteBalance())) {
            Logging.i(TAG, "AgoraVideo set white blance = WHITE_BALANCE_AUTO");
            parameters.setWhiteBalance(string4);
        }
        if (VideoCaptureCamera.isSupported(string3 = "continuous-video", parameters.getSupportedFocusModes())) {
            Logging.i(TAG, "AgoraVideo set Focus mode = FOCUS_MODE_CONTINUOUS_VIDEO");
            parameters.setFocusMode(string3);
        }
        if (VideoCaptureCamera.isSupported(string2 = this.mAntiBandingMode, parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + this.mAntiBandingMode);
            parameters.setAntibanding(string2);
        }
        if (VideoCaptureCamera.isSupported(string = "auto", parameters.getSupportedSceneModes())) {
            Logging.i(TAG, "AgoraVideo set sence mode = " + string);
            if (parameters.getSceneMode() != string) {
                parameters.setSceneMode(string);
            }
        }
    }

    private void setDeviceSpecificParameters(Camera.Parameters parameters) {
        String string = DeviceUtils.buildDeviceId();
        String string2 = DeviceUtils.getCpuName();
        String string3 = DeviceUtils.getCpuABI();
        int n = DeviceUtils.getNumberOfCPUCores();
        int n2 = DeviceUtils.getCPUMaxFreqKHz();
        Logging.i(TAG, "Current Device: " + string);
        Logging.i(TAG, "CPU name: " + string2 + ", with " + n + " cores, arch: " + string3 + ", max Freq: " + n2);
        if (string.contains("xiaomi/mi note")) {
            Logging.i(TAG, "set MiNote config");
            parameters.set("scene-detect", "on");
            parameters.set("xiaomi-still-beautify-values", "i:3");
            parameters.set("skinToneEnhancement", "enable");
            parameters.set("auto-exposure", "center-weighted");
        }
        if (string.contains("oppo/r7c/r7c")) {
            Logging.i(TAG, "set oppo r7c config");
            parameters.set("skinToneEnhancement", 1);
            parameters.set("face-beautify", 100);
            parameters.set("auto-exposure", "center-weighted");
        }
    }

    public Camera.Parameters getCameraParameters() {
        Camera.Parameters parameters;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", runtimeException);
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
            return null;
        }
        return parameters;
    }

    public int createCapabilities() {
        String string = null;
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters != null) {
            String string2 = "\"id\":" + this.mId + ",";
            String string3 = "\"resolution\":";
            String string4 = "";
            List list = parameters.getSupportedPreviewSizes();
            for (int i = 0; i < list.size(); ++i) {
                int n = ((Camera.Size)list.get((int)i)).width;
                int n2 = ((Camera.Size)list.get((int)i)).height;
                if (n < 240 || n2 < 240 || n < 320 && n2 < 320) continue;
                String string5 = "{\"w\":" + n + ",\"h\":" + n2 + "}";
                string4 = !string4.isEmpty() ? string4 + "," + string5 : string5;
            }
            String string6 = "\"format\":";
            String string7 = "";
            List list2 = parameters.getSupportedPreviewFormats();
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS != null && Build.SUPPORTED_ABIS[0].startsWith("x86")) {
                bl = true;
            }
            if (VideoCapture.isEmulator() || bl && list2.size() > 1) {
                list2.remove((Object)842094169);
            }
            for (int i = 0; i < list2.size(); ++i) {
                int n = VideoCaptureCamera.translateToEngineFormat((Integer)list2.get(i));
                string7 = i != list2.size() - 1 ? string7 + n + "," : string7 + n;
            }
            String string8 = "\"fps\":";
            String string9 = "";
            List list3 = parameters.getSupportedPreviewFrameRates();
            for (int i = 0; i < list3.size(); ++i) {
                int n = (Integer)list3.get(i);
                string9 = i != list3.size() - 1 ? string9 + n + "," : string9 + n;
            }
            string = "{" + string2 + string3 + "[" + string4 + "]," + string6 + "[" + string7 + "]," + string8 + "[" + string9 + "]}";
        }
        VideoCaptureCamera.cacheCapability(this.mId, this.mContext, string, VideoCaptureCamera.getCaptureName());
        return 0;
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean bl = parameters.isZoomSupported();
            if (bl) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported ");
            return false;
        }
        return false;
    }

    private static Rect calculateTapArea(float f, float f2, float f3) {
        float f4 = 300.0f;
        int n = Float.valueOf(f4 * f3).intValue();
        int n2 = (int)(f * 2000.0f - 1000.0f);
        int n3 = (int)(f2 * 2000.0f - 1000.0f);
        int n4 = n / 2;
        RectF rectF = new RectF((float)VideoCaptureCamera.clamp(n2 - n4, -1000, 1000), (float)VideoCaptureCamera.clamp(n3 - n4, -1000, 1000), (float)VideoCaptureCamera.clamp(n2 + n4, -1000, 1000), (float)VideoCaptureCamera.clamp(n3 + n4, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    private int getFrameOrientation() {
        int n = this.checkOrientation();
        if (!this.mIsCameraFacingFront) {
            n = 360 - n;
        }
        return (VideoCaptureCamera.getSensorOrientation(this.mId) + n) % 360;
    }

    private String toCamera1ABMode(int n) {
        switch (n) {
            case 1: {
                return "50hz";
            }
            case 2: {
                return "60hz";
            }
            case 3: {
                return "auto";
            }
            case 0: {
                return "off";
            }
        }
        return "auto";
    }

    @Override
    public int setAntiBandingMode(int n) {
        final int n2 = n;
        if (this.mPreviewHandler != null) {
            Integer n3 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n = VideoCaptureCamera.this.setAntiBandingMode_l(n2);
                    return n;
                }
            });
            return n3;
        }
        return -1;
    }

    private int setAntiBandingMode_l(int n) {
        this.mAntiBandingMode = this.toCamera1ABMode(n);
        if (this.mCamera == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (parameters == null) {
            return -1;
        }
        String string = this.mAntiBandingMode;
        if (VideoCaptureCamera.isSupported(string, parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + string);
            parameters.setAntibanding(string);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.e(TAG, "anti banding got exception:" + exception);
            }
            return 0;
        }
        Logging.i(TAG, "not supported anti-banding = " + string);
        return -1;
    }

    @Override
    public int setExposureCompensation(int n) {
        final int n2 = n;
        if (this.mPreviewHandler != null) {
            Integer n3 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    VideoCaptureCamera.this.setExposureCompensation_l(n2);
                    return 0;
                }
            });
            return n3;
        }
        return -1;
    }

    @Override
    public int setNoiseReductionMode(int n) {
        Logging.e(TAG, "NoiseReduction not supported in camera1 ");
        return -1;
    }

    @Override
    public int setEdgeEnhanceMode(int n) {
        Logging.e(TAG, "EdgeEnhancement not supported in camera1 ");
        return -1;
    }

    @Override
    public int setVideoStabilityMode(int n) {
        Logging.e(TAG, "VideoStability not supported in camera1 ");
        return -1;
    }

    private void setExposureCompensation_l(int n) {
        Camera.Parameters parameters;
        Logging.i(TAG, "setExposureCompensation:" + n);
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()) != null) {
            float f = parameters.getExposureCompensationStep();
            int n2 = parameters.getMinExposureCompensation();
            int n3 = parameters.getMaxExposureCompensation();
            int n4 = parameters.getExposureCompensation();
            Logging.i(TAG, "compensation step=" + f + ", min=" + n2 + ", max=" + n3 + ", cur index=" + n4);
            if (n > n3) {
                n = n3;
            }
            if (n < n2) {
                n = n2;
            }
            parameters.setExposureCompensation(n);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.e(TAG, "exposure compensation got exception:" + exception);
            }
            n4 = parameters.getExposureCompensation();
            float f2 = f * (float)n4;
            Logging.i(TAG, "cur index=" + n4 + ", ev=" + f2);
        }
    }
}

