/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture
implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "CAMERA2";
    private static final boolean VERBOSE = false;
    private CameraDevice mCameraDevice = null;
    private CaptureRequest.Builder mPreviewBuilder = null;
    private CameraCaptureSession mCaptureSession = null;
    private static final double kNanoSecondsToFps = 1.0E-9;
    private CameraState mCameraState = CameraState.STOPPED;
    private CameraManager mManager = null;
    private Handler mStateHandler = null;
    private HandlerThread mCameraStateThread = null;
    private HandlerThread mPreviewThread = null;
    private final Object mCameraStateLock = new Object();
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 35;
    private boolean mFaceDetectSupported;
    private int mFaceDetectMode;
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDistaneEnabled = false;
    private static final int DEFAULT_MATCH_FPS = 15;
    private static boolean usingLibyuv = false;
    private static final MeteringRectangle[] ZERO_WEIGHT_3A_REGION = new MeteringRectangle[]{new MeteringRectangle(0, 0, 0, 0, 0)};
    private MeteringRectangle[] mAFAERegions = ZERO_WEIGHT_3A_REGION;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 1.0f;
    private static final float DEFAULT_VALUE = -1.0f;
    private float mLastZoomRatio = -1.0f;
    private float mCurZoomRatio = 1.0f;
    private float mMaxZoom = -1.0f;
    private Rect mSensorRect = null;
    private int mAntiBandingMode = 3;
    private int mNoiseReductionMode = 1;
    private int mEdgeEnhanceMode = 0;
    private int mVideoStabilityMode = 0;
    private final Object mCaptureSessionLock = new Object();
    private final boolean mIsCameraFacingFront;
    private byte[] mCaptureData;
    private ImageReader mImageReader = null;
    private final Object mImageReaderLock = new Object();
    private Surface mTextureOutputSurface;
    public CameraManager.AvailabilityCallback mAvailabilityCallback = new CameraManager.AvailabilityCallback(){

        public synchronized void onCameraAvailable(String string) {
            super.onCameraAvailable(string);
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                Logging.i(VideoCaptureCamera2.TAG, "Camera " + string + " available, try start capture again");
                if (VideoCaptureCamera2.this.tryOpenCamera() == 0) {
                    if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                        VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 0);
                    }
                } else {
                    Logging.e(VideoCaptureCamera2.TAG, "start capture failed");
                }
            }
        }

        public synchronized void onCameraUnavailable(String string) {
            super.onCameraUnavailable(string);
            Logging.e(VideoCaptureCamera2.TAG, "Camera " + string + " unavailable");
        }
    };
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        private void notifyCameraFocusAreaChanged(Rect rect, Rect rect2) {
            Rect rect3 = CoordinatesTransform.sensorToNormalizedPreview(rect2, VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, rect);
            Logging.d(VideoCaptureCamera2.TAG, "face bound = " + rect2.toString());
            Logging.d(VideoCaptureCamera2.TAG, "rect (-1000, 1000) = " + rect3.toString());
            boolean bl = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            RectF rectF = CoordinatesTransform.normalizedFaceRect(rect3, 0, bl);
            Logging.d(VideoCaptureCamera2.TAG, "preview size width = " + VideoCaptureCamera2.this.mCaptureWidth + " height = " + VideoCaptureCamera2.this.mCaptureHeight);
            Logging.d(VideoCaptureCamera2.TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom + "isMirror =" + bl);
            float f = rectF.left;
            float f2 = rectF.top;
            float f3 = rectF.width();
            float f4 = rectF.height();
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.NotifyCameraFocusAreaChanged(f, f2, f3, f4, VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
            }
        }

        private void notifyFaceDetection(Rect rect, Face[] faceArray) {
            VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, null);
            int n = 0;
            boolean bl = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            if (faceArray != null && faceArray.length > 0) {
                n = faceArray.length;
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, new RectF[n]);
                VideoCaptureCamera2.access$502(VideoCaptureCamera2.this, new int[n]);
                for (int i = 0; i < n; ++i) {
                    Rect rect2 = CoordinatesTransform.sensorToNormalizedPreview(faceArray[i].getBounds(), VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, rect);
                    ((VideoCaptureCamera2)VideoCaptureCamera2.this).rectArray[i] = CoordinatesTransform.normalizedFaceRect(rect2, 0, bl);
                    ((VideoCaptureCamera2)VideoCaptureCamera2.this).distanceArray[i] = 5;
                }
            } else {
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, new RectF[0]);
            }
            Logging.d(VideoCaptureCamera2.TAG, "before notify face");
            VideoCaptureCamera2.this.NotifyFaceDetection(VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, VideoCaptureCamera2.this.rectArray, n, VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(CaptureResult captureResult) {
            Face[] faceArray = (Face[])captureResult.get(CaptureResult.STATISTICS_FACES);
            if (faceArray != null && faceArray.length > 0) {
                block13: {
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faceArray[0].getScore() > 20) {
                            Rect rect = (Rect)captureResult.get(CaptureResult.SCALER_CROP_REGION);
                            this.notifyCameraFocusAreaChanged(rect, faceArray[0].getBounds());
                        }
                        return;
                    }
                    if (faceArray[0].getScore() <= 50) {
                        return;
                    }
                    VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, new MeteringRectangle[]{new MeteringRectangle(faceArray[0].getBounds(), 1000)});
                    if (VideoCaptureCamera2.this.mPreviewBuilder == null) {
                        return;
                    }
                    VideoCaptureCamera2.this.addRegionsToCaptureRequestBuilder(VideoCaptureCamera2.this.mPreviewBuilder);
                    if (VideoCaptureCamera2.this.mCameraState != CameraState.STARTED) {
                        return;
                    }
                    try {
                        Rect rect = (Rect)captureResult.get(CaptureResult.SCALER_CROP_REGION);
                        Logging.d(VideoCaptureCamera2.TAG, "cropRegion = " + rect.toString());
                        Logging.d(VideoCaptureCamera2.TAG, "capture size wxh = " + VideoCaptureCamera2.this.mCaptureWidth + " x " + VideoCaptureCamera2.this.mCaptureHeight);
                        this.notifyCameraFocusAreaChanged(rect, faceArray[0].getBounds());
                        if (VideoCaptureCamera2.this.mCaptureSession == null) break block13;
                        Object object = VideoCaptureCamera2.this.mCaptureSessionLock;
                        synchronized (object) {
                            if (VideoCaptureCamera2.this.mCaptureSession != null) {
                                VideoCaptureCamera2.this.mCaptureSession.capture(VideoCaptureCamera2.this.mPreviewBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, null);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logging.e(VideoCaptureCamera2.TAG, "capture: " + exception);
                        return;
                    }
                }
                VideoCaptureCamera2.this.createCaptureRequest();
                this.mLastFocusedTs = System.currentTimeMillis();
            } else {
                VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, ZERO_WEIGHT_3A_REGION);
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            if (VideoCaptureCamera2.this.mIsAutoFaceFocusEnabled && VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this.process((CaptureResult)totalCaptureResult);
            }
            if (VideoCaptureCamera2.this.faceDistaneEnabled) {
                this.notifyFaceDetection((Rect)totalCaptureResult.get(CaptureResult.SCALER_CROP_REGION), (Face[])totalCaptureResult.get(CaptureResult.STATISTICS_FACES));
            }
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult captureResult) {
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
            if (null == n) {
                return;
            }
            if (VideoCaptureCamera2.this.mPreviewBuilder == null) {
                return;
            }
            if (4 == n || 5 == n) {
                VideoCaptureCamera2.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCaptureCamera2.this.startNormalPreview();
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };

    static boolean isCameraFacingFront(Context context, int n) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n);
        if (cameraCharacteristics != null) {
            return Integer.valueOf(0).equals(cameraCharacteristics.get(CameraCharacteristics.LENS_FACING));
        }
        return true;
    }

    private static CameraCharacteristics getCameraCharacteristics(Context context, int n) {
        if (n != 0 && n != 1 && n != 2) {
            Logging.i(TAG, "getCameraCharacteristics error,  camera id: " + n);
            return null;
        }
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            return cameraManager.getCameraCharacteristics(Integer.toString(n));
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.i(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)cameraAccessException));
        }
        catch (Exception exception) {
            Logging.i(TAG, "getNumberOfCameras: got exception: " + exception);
        }
        return null;
    }

    public static int getFrontCameraIndex(Context context) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            for (String string : cameraManager.getCameraIdList()) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                Integer n = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (n == null || n != 0) continue;
                Logging.d(TAG, "getFrontCameraIndex str= " + string + ", int = " + Integer.parseInt(string));
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "getFrontCameraIndex: ", exception);
        }
        return 0;
    }

    static boolean isLegacyDevice(Context context, int n) {
        try {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n);
            return cameraCharacteristics == null || (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
        }
        catch (Throwable throwable) {
            Logging.w(TAG, "this is a legacy camera device");
            return true;
        }
    }

    static int getNumberOfCameras(Context context) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            int n = cameraManager.getCameraIdList().length;
            Logging.i(TAG, "VideoCaptureCamera2 listCount:" + n);
            return n;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): ", exception);
            return 0;
        }
    }

    static String getName(int n, Context context) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n);
        if (cameraCharacteristics == null) {
            return null;
        }
        int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + n + ", facing " + (n2 == 0 ? "front" : "back");
    }

    static String getCaptureName() {
        return "camera2";
    }

    static int getSensorOrientation(int n, Context context) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n);
        if (cameraCharacteristics == null) {
            return -1;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    VideoCaptureCamera2(Context context, int n, int n2, EglBase.Context context2, long l) {
        super(context, n, n2, context2, l);
        this.mIsCameraFacingFront = VideoCaptureCamera2.isCameraFacingFront(context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNormalPreview() {
        if (this.mPreviewBuilder == null || this.mPreviewThread == null || this.mCaptureSession == null) {
            return;
        }
        try {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewBuilder != null && this.mPreviewThread != null && this.mCaptureSession != null) {
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                }
            }
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "setRepeatingRequest failed, error message : " + cameraAccessException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(CameraState cameraState) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = cameraState;
            this.mCameraStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createCaptureRequest() {
        block10: {
            if (this.mPreviewBuilder == null) {
                return -1;
            }
            try {
                if (this.mCaptureSession == null) break block10;
                Object object = this.mCaptureSessionLock;
                synchronized (object) {
                    if (this.mCaptureSession != null) {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, null);
                    }
                }
            }
            catch (CameraAccessException cameraAccessException) {
                Logging.e(TAG, "setRepeatingRequest: ", cameraAccessException);
                return -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "setRepeatingRequest: ", illegalArgumentException);
                return -2;
            }
            catch (SecurityException securityException) {
                Logging.e(TAG, "setRepeatingRequest: ", securityException);
                return -3;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "capture:" + illegalStateException);
                return -4;
            }
        }
        return 0;
    }

    private static void setUsingLibyuv(boolean bl) {
        usingLibyuv = bl;
    }

    private static void readImageIntoBuffer(Image image, byte[] byArray) {
        int n;
        Object object;
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        Image.Plane[] planeArray = image.getPlanes();
        if (usingLibyuv) {
            Image.Plane plane = planeArray[0];
            Image.Plane plane2 = planeArray[1];
            object = planeArray[2];
            n = VideoCaptureCamera2.ConvertFrameToI420(n2, n3, plane.getBuffer(), plane.getRowStride(), plane2.getBuffer(), object.getBuffer(), plane2.getRowStride(), plane2.getPixelStride(), byArray);
            if (n == 0) {
                return;
            }
            Logging.w(TAG, "readImageIntoBuffer: native convert I420 failed, using java method instead");
        }
        int n4 = 0;
        for (int i = 0; i < planeArray.length; ++i) {
            int n5;
            int n6;
            object = planeArray[i].getBuffer();
            if (object == null) {
                Logging.e(TAG, "plane " + i + " buffer is null ");
                break;
            }
            n = planeArray[i].getRowStride();
            int n7 = planeArray[i].getPixelStride();
            int n8 = i == 0 ? n2 : n2 / 2;
            int n9 = n6 = i == 0 ? n3 : n3 / 2;
            if (n7 == 1 && n == n8) {
                ((ByteBuffer)object).get(byArray, n4, n8 * n6);
                n4 += n8 * n6;
                continue;
            }
            byte[] byArray2 = new byte[n];
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                ((ByteBuffer)object).get(byArray2, 0, n);
                for (int j = 0; j < n8; ++j) {
                    byArray[n4++] = byArray2[j * n7];
                }
            }
            ((ByteBuffer)object).get(byArray2, 0, Math.min(n, ((Buffer)object).remaining()));
            for (n5 = 0; n5 < n8; ++n5) {
                byArray[n4++] = byArray2[n5 * n7];
            }
        }
    }

    private int tryOpenCamera() {
        CrStateListener crStateListener = new CrStateListener();
        try {
            this.mManager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)crStateListener, this.mStateHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", securityException);
            return -3;
        }
        catch (Exception exception) {
            Logging.e(TAG, "unknown error", exception);
            return -4;
        }
        return 0;
    }

    private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder) {
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        builder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doStartCapture() {
        Object object;
        if (this.mPreviewThread == null) {
            this.mPreviewThread = new HandlerThread("CameraPreview");
            this.mPreviewThread.start();
        }
        try {
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureRequest: ", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureRequest: ", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureRequest ", securityException);
            return -3;
        }
        if (this.mPreviewBuilder == null) {
            Logging.e(TAG, "mPreviewBuilder error");
            return -4;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics != null && (object = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) != null) {
            if (this.mPQFirst < 1) {
                Arrays.sort(object, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getLower() - (Integer)range2.getLower();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object));
                for (Object object2 : object) {
                    if ((Integer)object2.getLower() < Math.max(this.mCaptureFps, 15)) continue;
                    Logging.i(TAG, "set fps :" + object2.toString() + " to camera2::fps first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object2);
                    break;
                }
            } else {
                Arrays.sort(object, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getUpper() - (Integer)range2.getUpper();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object));
                for (Object object2 : object) {
                    if ((Integer)object2.getUpper() < this.mCaptureFps) continue;
                    Logging.i(TAG, "set fps :" + object2.toString() + " to camera2::PQ first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object2);
                    break;
                }
            }
        }
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.setFaceDetect(this.mPreviewBuilder, this.mFaceDetectMode);
        object = new ArrayList();
        if (this.mCaptureOutputDataType == 1 || this.mCaptureOutputDataType == 2) {
            this.mSurfaceTextureHelper = SurfaceTextureHelper.create("Camera2Tex-" + this.mId, this.mShareContext, 8);
            if (this.mSurfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create SurfaceTextureHelper, force fallback to raw data type");
                this.mCaptureOutputDataType = 0;
            } else {
                this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(this.mCaptureWidth, this.mCaptureHeight);
                this.mSurfaceTextureHelper.startListening(this);
                this.mEglContext = this.mSurfaceTextureHelper.getEglContext();
                this.mTextureOutputSurface = new Surface(this.mSurfaceTextureHelper.getSurfaceTexture());
                this.mPreviewBuilder.addTarget(this.mTextureOutputSurface);
                object.add(this.mTextureOutputSurface);
                if (this.mCaptureOutputDataType == 2 && this.mTextureAndRawBufferSynchronizer == null) {
                    this.mTextureAndRawBufferSynchronizer = new VideoCapture.TextureAndRawBufferSynchronizer();
                }
            }
        }
        if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
            this.mExpectedRawBufferSize = this.mCaptureWidth * this.mCaptureHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
            this.mCaptureData = new byte[this.mExpectedRawBufferSize];
            Object securityException = this.mImageReaderLock;
            synchronized (securityException) {
                Object object2;
                this.mImageReader = ImageReader.newInstance((int)this.mCaptureWidth, (int)this.mCaptureHeight, (int)this.mCaptureFormat, (int)2);
                Handler handler = new Handler(this.mPreviewThread.getLooper());
                object2 = new ImageReaderListener();
                this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)object2, handler);
            }
            securityException = this.mImageReader.getSurface();
            this.mPreviewBuilder.addTarget((Surface)securityException);
            object.add(securityException);
        }
        CaptureSessionListener captureSessionListener = new CaptureSessionListener();
        try {
            this.mCameraDevice.createCaptureSession((List)object, (CameraCaptureSession.StateCallback)captureSessionListener, null);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureSession :", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureSession :", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureSession :", securityException);
            return -3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doStopCapture() {
        Logging.i(TAG, "doStopCapture");
        int n = 0;
        Object object = this.mCaptureSessionLock;
        synchronized (object) {
            if (this.mPreviewThread != null) {
                this.mPreviewThread.quitSafely();
                this.mPreviewThread = null;
            }
            try {
                if (this.mCaptureSession != null) {
                    this.mCaptureSession.abortCaptures();
                    this.mCaptureSession = null;
                }
            }
            catch (CameraAccessException cameraAccessException) {
                Logging.e(TAG, "abortCaptures: ", cameraAccessException);
                n = -1;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "abortCaptures: ", illegalStateException);
                n = -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "abortCaptures: ", illegalArgumentException);
                n = -1;
            }
            catch (Exception exception) {
                Logging.e(TAG, "abortCaptures: ", exception);
                n = -1;
            }
        }
        if (this.mImageReader != null) {
            object = this.mImageReaderLock;
            synchronized (object) {
                if (this.mImageReader != null) {
                    this.mImageReader.setOnImageAvailableListener(null, null);
                    this.mImageReader.close();
                    this.mImageReader = null;
                }
            }
        }
        AgoraVideoDebugger.reset();
        this.mDroppedTextureBufferCount = 0;
        if (this.mTextureAndRawBufferSynchronizer != null) {
            this.mTextureAndRawBufferSynchronizer.reset();
        }
        if (this.mSurfaceTextureHelper != null) {
            this.mSurfaceTextureHelper.stopListening();
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
            this.mEglContext = null;
        }
        if (this.mTextureOutputSurface != null) {
            this.mTextureOutputSurface.release();
            this.mTextureOutputSurface = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
        }
        return n;
    }

    @Override
    public int UnRegisterNativeHandle() {
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == CameraState.OPENING) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring");
                return -1;
            }
        }
        object = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (object == null) {
            return -1;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext, VideoCaptureCamera2.getCaptureName()) == null) {
            VideoCaptureCamera2.createCapabilities(this.mId, this.mContext);
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
            this.faceDistaneEnabled = this.isFaceDetectionEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        this.mCameraNativeOrientation = (Integer)object.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mManager = (CameraManager)this.mContext.getSystemService("camera");
        int[] nArray = (int[])object.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int n = (Integer)object.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (nArray.length > 1 && n > 0) {
            this.mFaceDetectSupported = true;
            int n2 = 0;
            for (int n3 : nArray) {
                n2 += n3;
            }
            this.mFaceDetectMode = n2 % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "allocate() face detection: " + this.mFaceDetectMode + " " + n + " " + this.mFaceDetectSupported);
        if (this.mCameraStateThread == null) {
            this.mCameraStateThread = new HandlerThread("CameraCallbackThread");
            this.mCameraStateThread.start();
            this.mStateHandler = new SafeHandler(this.mCameraStateThread.getLooper());
        }
        this.mManager.registerAvailabilityCallback(this.mAvailabilityCallback, this.mStateHandler);
        return 0;
    }

    @Override
    public int setCaptureFormat(int n, int n2, boolean bl) {
        Logging.i(TAG, "setCaptureFormat: " + n + " type: " + n2 + " force texture oes: " + bl);
        VideoCapture.FORCE_TEXTURE_OES = bl;
        this.mCaptureOutputDataType = VideoCaptureCamera2.translateToCaptureOutputDataType(n2);
        int n3 = VideoCaptureCamera2.translateToAndroidFormat(n);
        if (n3 != this.mCaptureFormat) {
            Logging.e(TAG, "For camera2 api, only YUV_420_888 format are supported");
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startCapture(int n, int n2, int n3) {
        Logging.i(TAG, "startCapture, w=" + n + ", h=" + n2 + ", fps=" + n3);
        this.mCaptureWidth = n;
        this.mCaptureHeight = n2;
        this.mCaptureFps = n3;
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.e(TAG, "CaptureStartedEvent: ", interruptedException);
                }
            }
            if (this.mCameraState == CameraState.STARTED) {
                return 0;
            }
        }
        this.changeCameraStateAndNotify(CameraState.OPENING);
        int n4 = this.tryOpenCamera();
        if (n4 != 0) {
            this.changeCameraStateAndNotify(CameraState.STOPPED);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopCapture() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.e(TAG, "CaptureStartedEvent: ", interruptedException);
                }
            }
            if (this.mCameraState == CameraState.EVICTED) {
                this.mCameraState = CameraState.STOPPED;
            }
            if (this.mCameraState == CameraState.STOPPED) {
                return 0;
            }
        }
        this.doStopCapture();
        this.changeCameraStateAndNotify(CameraState.STOPPED);
        return 0;
    }

    @Override
    public boolean isTorchSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Boolean bl = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl2 = bl == null ? false : bl;
        return bl2;
    }

    @Override
    public boolean isFocusSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                Logging.d(TAG, "isExposureSupported AE mode = " + nArray[i]);
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        float f = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        return f > 1.0f;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!this.isFocusSupported()) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer n = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setZoom(float f) {
        boolean bl;
        Logging.d(TAG, "setCameraZoom api2 called zoomValue =" + f);
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setZoom mPreviewBuilder is null");
            return -1;
        }
        if (this.mSensorRect == null) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1;
            }
            this.mSensorRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        if (Math.abs(this.mMaxZoom - 1.0f) < 0.001f) {
            Logging.w(TAG, "Camera " + this.mId + " does not support camera zoom");
            return -1;
        }
        this.mCurZoomRatio = f;
        boolean bl2 = bl = this.mCurZoomRatio >= 1.0f && this.mCurZoomRatio <= this.mMaxZoom && this.mCurZoomRatio != this.mLastZoomRatio;
        if (!bl) {
            return -2;
        }
        Rect rect = this.cropRegionForZoom(this.mCurZoomRatio);
        if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    this.mPreviewBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)rect);
                    this.mLastZoomRatio = this.mCurZoomRatio;
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                        return -3;
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        return -4;
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mMaxZoom <= 0.0f) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1.0f;
            }
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return this.mMaxZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setTorchMode(boolean bl) {
        boolean bl2;
        Logging.d(TAG, "setFlashMode isTorchOn " + bl);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            return -1;
        }
        Boolean bl3 = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl4 = bl2 = bl3 == null ? false : bl3;
        if (bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                Object object = this.mCaptureSessionLock;
                synchronized (object) {
                    if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                        Handler handler = new Handler(this.mPreviewThread.getLooper());
                        if (bl) {
                            this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                        } else {
                            this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                        }
                        try {
                            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, handler);
                            return 0;
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                    }
                }
            }
        } else {
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFocus(float f, float f2, boolean bl) {
        int n;
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setFocus mPreviewBuilder is null");
            return -1;
        }
        double d = f;
        double d2 = f2;
        if (this.mPreviewBuilder == null) {
            return -1;
        }
        Rect rect = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            return -1;
        }
        int n2 = rect.width();
        int n3 = rect.height();
        Logging.d(TAG, "crop width = " + n2 + " crop height = " + n3 + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight);
        int n4 = 0;
        int n5 = 0;
        if (n2 * this.mCaptureHeight > n3 * this.mCaptureWidth) {
            n = n3 * this.mCaptureWidth / this.mCaptureHeight;
            n4 = (int)((double)((float)(n2 - n) / 2.0f) + d * (double)n);
            n5 = (int)(d2 * (double)n3);
        } else {
            n = n2 * this.mCaptureHeight / this.mCaptureWidth;
            n4 = (int)(d * (double)n2);
            n5 = (int)((double)((float)(n3 - n) / 2.0f) + d2 * (double)n);
        }
        double d3 = 0.1;
        Rect rect2 = new Rect();
        rect2.left = VideoCaptureCamera2.clamp((int)((double)n4 - d3 / 2.0 * (double)n2), 0, n2);
        rect2.right = VideoCaptureCamera2.clamp((int)((double)n4 + d3 / 2.0 * (double)n2), 0, n2);
        rect2.top = VideoCaptureCamera2.clamp((int)((double)n5 - d3 / 2.0 * (double)n3), 0, n3);
        rect2.bottom = VideoCaptureCamera2.clamp((int)((double)n5 + d3 / 2.0 * (double)n3), 0, n3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mPreviewThread != null && this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mCaptureSession != null) {
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mAfCaptureCallback, handler);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                        return -1;
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        return -1;
                    }
                }
            }
            if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.NotifyCameraFocusAreaChanged(f, f2, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExposure(float f, float f2, boolean bl) {
        int n;
        Logging.d(TAG, "setExposure called camera api2");
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setExposure mPreviewBuilder is null");
            return -1;
        }
        double d = f;
        double d2 = f2;
        Rect rect = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            return -1;
        }
        int n2 = rect.width();
        int n3 = rect.height();
        Logging.d(TAG, "crop width = " + n2 + " crop height = " + n3 + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight);
        int n4 = 0;
        int n5 = 0;
        if (n2 * this.mCaptureHeight > n3 * this.mCaptureWidth) {
            n = n3 * this.mCaptureWidth / this.mCaptureHeight;
            n4 = (int)((double)((float)(n2 - n) / 2.0f) + d * (double)n);
            n5 = (int)(d2 * (double)n3);
        } else {
            n = n2 * this.mCaptureHeight / this.mCaptureWidth;
            n4 = (int)(d * (double)n2);
            n5 = (int)((double)((float)(n3 - n) / 2.0f) + d2 * (double)n);
        }
        double d3 = 0.1;
        Rect rect2 = new Rect();
        rect2.left = VideoCaptureCamera2.clamp((int)((double)n4 - d3 / 2.0 * (double)n2), 0, n2);
        rect2.right = VideoCaptureCamera2.clamp((int)((double)n4 + d3 / 2.0 * (double)n2), 0, n2);
        rect2.top = VideoCaptureCamera2.clamp((int)((double)n5 - d3 / 2.0 * (double)n3), 0, n3);
        rect2.bottom = VideoCaptureCamera2.clamp((int)((double)n5 + d3 / 2.0 * (double)n3), 0, n3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mCaptureSession != null) {
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, null);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                        return -1;
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        return -1;
                    }
                }
            }
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(f, f2, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAutoFaceFocus(boolean bl) {
        boolean bl2 = this.mIsAutoFaceFocusEnabled != bl;
        this.mIsAutoFaceFocusEnabled = bl;
        if (this.mFaceDetectSupported && bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSessionLock != null) {
                Object object = this.mCaptureSessionLock;
                synchronized (object) {
                    if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                        Handler handler = new Handler(this.mPreviewThread.getLooper());
                        if (this.mIsAutoFaceFocusEnabled) {
                            this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                        } else {
                            if (this.faceDistaneEnabled) {
                                Logging.w(TAG, "face detect did not turn off due to faceDistance on");
                                return 0;
                            }
                            this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                        }
                        try {
                            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                            return 0;
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                    }
                }
            }
        } else {
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFaceDetection(boolean bl) {
        boolean bl2 = this.faceDistaneEnabled != bl;
        this.faceDistaneEnabled = bl;
        if (this.mFaceDetectSupported && bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                Object object = this.mCaptureSessionLock;
                synchronized (object) {
                    if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                        Handler handler = new Handler(this.mPreviewThread.getLooper());
                        if (this.faceDistaneEnabled) {
                            this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                        } else {
                            if (this.mIsAutoFaceFocusEnabled) {
                                Logging.w(TAG, "face detect did not turn off due to autoFocus on");
                                return 0;
                            }
                            this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                        }
                        try {
                            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                            return 0;
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                    }
                }
            }
        } else {
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    @Override
    public void deallocate() {
        if (this.mManager != null) {
            this.mManager.unregisterAvailabilityCallback(this.mAvailabilityCallback);
            if (this.mCameraStateThread != null) {
                this.mCameraStateThread.quitSafely();
                this.mCameraStateThread = null;
                this.mStateHandler = null;
            }
        }
    }

    private void setFaceDetect(CaptureRequest.Builder builder, int n) {
        if (this.mFaceDetectSupported && (this.mIsAutoFaceFocusEnabled || this.faceDistaneEnabled)) {
            builder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int createCapabilities(int n, Context context) {
        Object object;
        Object object2;
        String string = null;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n);
        if (cameraCharacteristics == null) {
            return -1;
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamConfigurationMap == null) {
            Logging.e(TAG, "Failed to create capabilities");
            return -1;
        }
        try {
            Logging.i(TAG, "dump configuration map:" + streamConfigurationMap.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ArrayList<Object> arrayList = new ArrayList<Size>(Arrays.asList(streamConfigurationMap.getOutputSizes(35)));
        if ("SM-G9300".equals(Build.MODEL)) {
            object2 = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((Size)arrayList.get(i)).getHeight() < 720) continue;
                object2.add(arrayList.get(i));
            }
            arrayList = object2;
        }
        object2 = "\"id\":" + n + ",";
        String string2 = "\"resolution\":";
        String string3 = "";
        String string4 = String.valueOf(15);
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (rangeArray != null) {
            void n2;
            ArrayList<Comparable> arrayList2 = new ArrayList<Comparable>();
            object = rangeArray;
            int n3 = ((Range[])object).length;
            boolean bl = false;
            while (n2 < n3) {
                Range range = object[n2];
                arrayList2.add(range.getUpper());
                ++n2;
            }
            object = new StringBuilder();
            for (Integer string5 : arrayList2) {
                ((StringBuilder)object).append(string5 + ",");
            }
            if (arrayList2.size() > 0) {
                ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
            }
            string4 = ((StringBuilder)object).toString();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3 = ((Size)arrayList.get(i)).getWidth();
            int n4 = ((Size)arrayList.get(i)).getHeight();
            if (n3 < 240 || n4 < 240 || n3 < 320 && n4 < 320) continue;
            String string8 = "{\"w\":" + n3 + ",\"h\":" + n4 + "}";
            string3 = !string3.isEmpty() ? string3 + "," + string8 : string8;
        }
        String string6 = "\"format\":";
        object = "" + VideoCaptureCamera2.translateToEngineFormat(35);
        String string7 = "\"fps\":";
        String string5 = string4;
        string = "{" + (String)object2 + string2 + "[" + string3 + "]," + string6 + "[" + (String)object + "]," + string7 + "[" + string5 + "]}";
        VideoCaptureCamera2.cacheCapability(n, context, string, VideoCaptureCamera2.getCaptureName());
        return 0;
    }

    private Rect cropRegionForZoom(float f) {
        int n = this.mSensorRect.width() / 2;
        int n2 = this.mSensorRect.height() / 2;
        int n3 = (int)(0.5f * (float)this.mSensorRect.width() / f);
        int n4 = (int)(0.5f * (float)this.mSensorRect.height() / f);
        return new Rect(n - n3, n2 - n4, n + n3, n2 + n4);
    }

    private static int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    private boolean isMeteringAreaAFSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) >= 1;
    }

    @Override
    public void onTextureFrameAvailable(int n, float[] fArray, long l) {
        int n2 = this.getFrameOrientation();
        if (this.mIsCameraFacingFront) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        fArray = RendererCommon.rotateTextureMatrix(fArray, 360 - n2);
        VideoFrame.TextureBuffer textureBuffer = this.mSurfaceTextureHelper.createTextureBuffer(this.mCaptureWidth, this.mCaptureHeight, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
        this.onTextureBufferAvailable(textureBuffer, n2, l);
        textureBuffer.release();
    }

    private int getFrameOrientation() {
        int n = this.checkOrientation();
        if (!this.mIsCameraFacingFront) {
            n = 360 - n;
        }
        return (VideoCaptureCamera2.getSensorOrientation(this.mId, this.mContext) + n) % 360;
    }

    private int toCamera2ABMode(int n) {
        if (n < 0 || n > 3) {
            return 3;
        }
        return n;
    }

    private int toCamera2NoiseMode(int n) {
        if (n < 0 || n > 4) {
            return 0;
        }
        return n;
    }

    private int toCamera2EdgeEnhanceMode(int n) {
        if (n < 0 || n > 3) {
            return 0;
        }
        return n;
    }

    private int toCamera2VideoStabilityMode(int n) {
        if (n < 0 || n > 1) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAntiBandingMode(int n) {
        this.mAntiBandingMode = this.toCamera2ABMode(n);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int n2 = this.mAntiBandingMode;
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES);
        if (nArray.length > 0) {
            for (int n3 : nArray) {
                if (n3 != n2) continue;
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    Object object = this.mCaptureSessionLock;
                    synchronized (object) {
                        if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                            Handler handler = new Handler(this.mPreviewThread.getLooper());
                            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_ANTIBANDING_MODE, (Object)n2);
                            try {
                                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                                return 0;
                            }
                            catch (CameraAccessException cameraAccessException) {
                                cameraAccessException.printStackTrace();
                            }
                            catch (IllegalStateException illegalStateException) {
                                illegalStateException.printStackTrace();
                            }
                        }
                    }
                }
                Logging.i(TAG, "AgoraVideo set anti-banding = " + n2);
                return 0;
            }
        }
        Logging.i(TAG, "not supported anti-banding = " + n2);
        return -1;
    }

    @Override
    public int setExposureCompensation(int n) {
        this.setExposureCompensation_l(n);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setNoiseReductionMode(int n) {
        this.mNoiseReductionMode = this.toCamera2NoiseMode(n);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES);
        if (VideoCaptureCamera2.isSupported(this.mNoiseReductionMode, nArray) && this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    this.mPreviewBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)this.mNoiseReductionMode);
                    try {
                        Logging.i(TAG, "setNoiseReductionMode = " + n);
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported NoiseReductionMode = " + n);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setEdgeEnhanceMode(int n) {
        this.mEdgeEnhanceMode = this.toCamera2EdgeEnhanceMode(n);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.EDGE_AVAILABLE_EDGE_MODES);
        if (VideoCaptureCamera2.isSupported(this.mEdgeEnhanceMode, nArray) && this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    this.mPreviewBuilder.set(CaptureRequest.EDGE_MODE, (Object)this.mEdgeEnhanceMode);
                    try {
                        Logging.i(TAG, "setEdgeEnhanceMode = " + n);
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported EdgeEnhance Mode = " + n);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setVideoStabilityMode(int n) {
        this.mVideoStabilityMode = this.toCamera2VideoStabilityMode(n);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        if (VideoCaptureCamera2.isSupported(this.mVideoStabilityMode, nArray) && this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
            Object object = this.mCaptureSessionLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)this.mVideoStabilityMode);
                    try {
                        Logging.i(TAG, "setVideoStabilityMode = " + n);
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported VideoStability Mode = " + n);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExposureCompensation_l(int n) {
        Logging.i(TAG, "setExposureCompensation:" + n);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return;
        }
        Rational rational = (Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        int n2 = (Integer)range.getUpper();
        int n3 = (Integer)range.getLower();
        Logging.i(TAG, "compensation step=" + rational + ", min=" + n3 + ", max=" + n2);
        if (n > n2) {
            n = n2;
        }
        if (n < n3) {
            n = n3;
        }
        if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
            Object object = this.mCameraStateLock;
            synchronized (object) {
                if (this.mPreviewThread != null && this.mPreviewBuilder != null && this.mCaptureSession != null) {
                    Handler handler = new Handler(this.mPreviewThread.getLooper());
                    int n4 = (Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
                    Logging.i(TAG, "bf cur index=" + n4);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)n);
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        n4 = (Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
                        Logging.i(TAG, "af cur index=" + n4 + ", ev=" + n4 * rational.getNumerator() / rational.getDenominator());
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        }
    }

    private static boolean isSupported(int n, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ RectF[] access$402(VideoCaptureCamera2 videoCaptureCamera2, RectF[] rectFArray) {
        videoCaptureCamera2.rectArray = rectFArray;
        return rectFArray;
    }

    static /* synthetic */ int[] access$502(VideoCaptureCamera2 videoCaptureCamera2, int[] nArray) {
        videoCaptureCamera2.distanceArray = nArray;
        return nArray;
    }

    static /* synthetic */ MeteringRectangle[] access$602(VideoCaptureCamera2 videoCaptureCamera2, MeteringRectangle[] meteringRectangleArray) {
        videoCaptureCamera2.mAFAERegions = meteringRectangleArray;
        return meteringRectangleArray;
    }

    static /* synthetic */ Object access$2100(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCameraStateLock;
    }

    static /* synthetic */ byte[] access$2200(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureData;
    }

    static /* synthetic */ ImageReader access$2300(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mImageReader;
    }

    static /* synthetic */ Object access$2400(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mImageReaderLock;
    }

    static /* synthetic */ void access$2500(Image image, byte[] byArray) {
        VideoCaptureCamera2.readImageIntoBuffer(image, byArray);
    }

    static /* synthetic */ int access$2600(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureFormat;
    }

    private class ImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private ImageReaderListener() {
        }

        /*
         * Exception decompiling
         */
        public void onImageAvailable(ImageReader var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class CaptureSessionListener
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mCaptureSession = cameraCaptureSession;
            if (VideoCaptureCamera2.this.createCaptureRequest() != 0) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 102);
                }
            } else {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STARTED);
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Logging.e(VideoCaptureCamera2.TAG, "onConfigureFailed");
            if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            }
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 101);
            }
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            if (VideoCaptureCamera2.this.doStartCapture() < 0) {
                VideoCaptureCamera2.this.doStopCapture();
                if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                    VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                }
                Logging.e(VideoCaptureCamera2.TAG, "Camera startCapture failed!!");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 100);
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            if (VideoCaptureCamera2.this.mCameraState != CameraState.STOPPED) {
                Logging.w(VideoCaptureCamera2.TAG, "camera client is evicted by other application");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 6);
                }
                Logging.i(VideoCaptureCamera2.TAG, "Camera device enter state: EVICTED");
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    VideoCaptureCamera2.this.mCameraDevice.close();
                    VideoCaptureCamera2.this.mCameraDevice = null;
                }
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.EVICTED);
                return;
            }
        }

        public void onError(CameraDevice cameraDevice, int n) {
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                return;
            }
            if (VideoCaptureCamera2.this.mCameraDevice != null) {
                VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            Logging.e(VideoCaptureCamera2.TAG, "CameraDevice Error :" + Integer.toString(n));
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                int n2 = 901;
                if (n == 1) {
                    n2 = 1;
                } else if (n == 2) {
                    n2 = 2;
                } else if (n == 3) {
                    n2 = 3;
                } else if (n == 4) {
                    n2 = 4;
                } else if (n == 5) {
                    n2 = 5;
                }
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, n2);
            }
        }
    }

    private static class SafeHandler
    extends Handler {
        public SafeHandler(Looper looper) {
            super(looper);
        }

        public void dispatchMessage(Message message) {
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                Logging.e(VideoCaptureCamera2.TAG, "handler exception", throwable);
            }
        }
    }

    private static enum CameraState {
        OPENING,
        STARTED,
        EVICTED,
        STOPPED;

    }
}

