/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCapture;
import io.agora.rtc.video.VideoCaptureCamera;
import io.agora.rtc.video.VideoCaptureCamera2;

public class VideoCaptureFactory {
    private static final String TAG = "CAM-FACTORY";
    private static final int ANDROID_CAMERA_NOT_DEFINE = -1;
    private static final int ANDROID_CAMERA1 = 0;
    private static final int ANDROID_CAMERA2 = 1;

    public static boolean isCamera2Available() {
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return false;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return false;
        }
        if ("m2c".equals(Build.DEVICE) || "M578CA".equals(Build.MODEL)) {
            return false;
        }
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
            return false;
        }
        if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER) && !Build.MODEL.contains("ONEPLUS A6")) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    public static VideoCapture createVideoCapture(Context context, int n, int n2, boolean bl, int n3, int n4, EglBase.Context context2, long l) {
        Logging.i(TAG, "createVideoCapture id: " + n + " select: " + n2 + " fallback: " + bl + " pqFirst: " + n3 + " lowPowerFlag: " + n4);
        int n5 = VideoCaptureFactory.fetchLowPowerFlag(context);
        if (n4 != n5) {
            VideoCaptureFactory.cacheLowPowerFlag(context, n4);
            VideoCapture.clearCapabilityCache(context);
        }
        if (VideoCaptureFactory.useCamera2(n, context, n2, bl)) {
            Logging.d(TAG, "create CAMERA2, id:" + n);
            return new VideoCaptureCamera2(context, n, n3, context2, l);
        }
        Logging.d(TAG, "create CAMERA1, id:" + n);
        return new VideoCaptureCamera(context, n, n3, context2, l);
    }

    public static int getNumberOfCameras(Context context) {
        if (Build.VERSION.SDK_INT < 23 && context.getPackageManager().checkPermission("android.permission.CAMERA", context.getPackageName()) != 0) {
            Logging.e(TAG, "Missing android.permission.CAMERA permission, no system camera available");
            return 0;
        }
        int n = 0;
        if (VideoCaptureFactory.isCamera2Available()) {
            n = VideoCaptureCamera2.getNumberOfCameras(context);
        }
        if (n == 0) {
            n = VideoCaptureCamera.getNumberOfCameras();
        }
        return n;
    }

    public static int getFrontCameraIndex(Context context) {
        int n = VideoCaptureFactory.isCamera2Available() ? VideoCaptureCamera2.getFrontCameraIndex(context) : VideoCaptureCamera.getFrontCameraIndex();
        Logging.i(TAG, "getFrontCameraIndex  = " + n);
        return n;
    }

    public static String getDeviceName(int n, Context context, int n2, boolean bl) {
        if (VideoCaptureFactory.useCamera2(n, context, n2, bl)) {
            return VideoCaptureCamera2.getName(n, context);
        }
        return VideoCaptureCamera.getName(n);
    }

    private static boolean useCamera2(int n, Context context, int n2, boolean bl) {
        if (!VideoCaptureFactory.isCamera2Available()) {
            return false;
        }
        if (n2 == 1 || n2 == 0) {
            return n2 == 1;
        }
        return !VideoCaptureCamera2.isLegacyDevice(context, n) && !bl;
    }

    public static int getDeviceOrientation(int n, Context context, int n2, boolean bl) {
        if (VideoCaptureFactory.useCamera2(n, context, n2, bl)) {
            return VideoCaptureCamera2.getSensorOrientation(n, context);
        }
        return VideoCaptureCamera.getSensorOrientation(n);
    }

    public static String getCapabilities(int n, Context context, int n2, boolean bl) {
        String string = null;
        string = VideoCaptureFactory.useCamera2(n, context, n2, bl) ? VideoCapture.fetchCapability(n, context, VideoCaptureCamera2.getCaptureName()) : VideoCapture.fetchCapability(n, context, VideoCaptureCamera.getCaptureName());
        if (string == null) {
            Logging.e(TAG, "Capability hasn't been created");
        } else {
            VideoCaptureFactory.printCameraInfo(string);
        }
        return string;
    }

    public static void cacheLowPowerFlag(Context context, int n) {
        String string = "CamCapsLowPower";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt("Cam_LowPower", n);
        editor.commit();
    }

    public static int fetchLowPowerFlag(Context context) {
        String string = "CamCapsLowPower";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
        if (sharedPreferences != null) {
            return sharedPreferences.getInt("Cam_LowPower", -1);
        }
        return 0;
    }

    public static int printCameraInfo(String string) {
        int n = 150;
        int n2 = string.length() / n + 1;
        for (int i = 0; i < n2; ++i) {
            try {
                String string2 = "lines = " + n2 + ":";
                string2 = i == n2 - 1 ? string2 + string.substring(i * n, string.length()) : string2 + string.substring(i * n, (i + 1) * n);
                Logging.d("CameraInfo", string2);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }
        return 0;
    }
}

