/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import java.nio.ByteBuffer;

public class VideoRenderer {
    long nativeVideoRenderer;

    public static native void nativeCopyPlane(ByteBuffer var0, int var1, int var2, int var3, ByteBuffer var4, int var5);

    public static void renderFrameDone(I420Frame i420Frame) {
        i420Frame.yuvPlanes = null;
        i420Frame.textureId = 0;
        if (i420Frame.nativeFramePointer != 0L) {
            VideoRenderer.releaseNativeFrame(i420Frame.nativeFramePointer);
            i420Frame.nativeFramePointer = 0L;
        }
    }

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeWrapVideoRenderer(callbacks);
    }

    public void dispose() {
        if (this.nativeVideoRenderer == 0L) {
            return;
        }
        VideoRenderer.freeWrappedVideoRenderer(this.nativeVideoRenderer);
        this.nativeVideoRenderer = 0L;
    }

    private static native long nativeWrapVideoRenderer(Callbacks var0);

    private static native void freeWrappedVideoRenderer(long var0);

    private static native void releaseNativeFrame(long var0);

    public static interface Callbacks {
        public void renderFrame(I420Frame var1);
    }

    public static class I420Frame {
        public final int width;
        public final int height;
        public final int[] yuvStrides;
        public ByteBuffer[] yuvPlanes;
        public final boolean yuvFrame;
        public final float[] samplingMatrix;
        public int textureId;
        private long nativeFramePointer;
        public int rotationDegree;

        I420Frame(int n, int n2, int n3, int[] nArray, ByteBuffer[] byteBufferArray, long l) {
            this.width = n;
            this.height = n2;
            this.yuvStrides = nArray;
            this.yuvPlanes = byteBufferArray;
            this.yuvFrame = true;
            this.rotationDegree = n3;
            this.nativeFramePointer = l;
            if (n3 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n3);
            }
            this.samplingMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        }

        I420Frame(int n, int n2, int n3, int n4, float[] fArray, long l) {
            this.width = n;
            this.height = n2;
            this.yuvStrides = null;
            this.yuvPlanes = null;
            this.samplingMatrix = fArray;
            this.textureId = n4;
            this.yuvFrame = false;
            this.rotationDegree = n3;
            this.nativeFramePointer = l;
            if (n3 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n3);
            }
        }

        public int rotatedWidth() {
            return this.rotationDegree % 180 == 0 ? this.width : this.height;
        }

        public int rotatedHeight() {
            return this.rotationDegree % 180 == 0 ? this.height : this.width;
        }

        public String toString() {
            return this.width + "x" + this.height + ":" + this.yuvStrides[0] + ":" + this.yuvStrides[1] + ":" + this.yuvStrides[2];
        }
    }
}

