/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.multimedia.audiokit.interfaces;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.huawei.multimedia.audioengine.IHwAudioEngine;
import com.huawei.multimedia.audiokit.interfaces.AudioFeaturesKit;
import com.huawei.multimedia.audiokit.interfaces.FeatureKitManager;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;
import com.huawei.multimedia.audiokit.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class HwAudioKit {
    private static final String TAG = "HwAudioKit.HwAudioKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioEngineService";
    private static final List<Integer> DEFAULT_FEATURE_LIST = new ArrayList<Integer>(0);
    private Context mContext = null;
    private IHwAudioEngine mIHwAudioEngine = null;
    private boolean mIsServiceConnected = false;
    private FeatureKitManager mFeatureKitManager;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            HwAudioKit.this.mIHwAudioEngine = IHwAudioEngine.Stub.asInterface(service);
            LogUtils.info(HwAudioKit.TAG, "onServiceConnected");
            if (HwAudioKit.this.mIHwAudioEngine != null) {
                HwAudioKit.this.mIsServiceConnected = true;
                LogUtils.info(HwAudioKit.TAG, "onServiceConnected, mIHwAudioEngine is not null");
                HwAudioKit.this.mFeatureKitManager.onCallBack(0);
                HwAudioKit.this.serviceInit(HwAudioKit.this.mContext.getPackageName(), "1.0.1");
                HwAudioKit.this.serviceLinkToDeath(service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            LogUtils.info(HwAudioKit.TAG, "onServiceDisconnected");
            HwAudioKit.this.mIHwAudioEngine = null;
            HwAudioKit.this.mIsServiceConnected = false;
            HwAudioKit.this.mFeatureKitManager.onCallBack(4);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            HwAudioKit.this.mService.unlinkToDeath(HwAudioKit.this.mDeathRecipient, 0);
            HwAudioKit.this.mFeatureKitManager.onCallBack(6);
            LogUtils.error(HwAudioKit.TAG, "service binder died");
            HwAudioKit.this.mService = null;
        }
    };

    public HwAudioKit(Context context, IAudioKitCallback callback) {
        this.mFeatureKitManager = FeatureKitManager.getInstance();
        this.mFeatureKitManager.setCallBack(callback);
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException e2) {
            this.mFeatureKitManager.onCallBack(5);
            LogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
        }
    }

    public void initialize() {
        LogUtils.info(TAG, "initialize");
        if (this.mContext == null) {
            LogUtils.info(TAG, "mContext is null");
            this.mFeatureKitManager.onCallBack(7);
            return;
        }
        if (!this.mFeatureKitManager.isMediaKitSupport(this.mContext)) {
            LogUtils.info(TAG, "not install AudioKitEngine");
            this.mFeatureKitManager.onCallBack(2);
            return;
        }
        this.bindService(this.mContext);
    }

    private void bindService(Context context) {
        LogUtils.info(TAG, "bindService, mIsServiceConnected = {}", this.mIsServiceConnected);
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void destroy() {
        LogUtils.info(TAG, "destroy, mIsServiceConnected = {}", this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    public List<Integer> getSupportedFeatures() {
        LogUtils.info(TAG, "getSupportedFeatures");
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.getSupportedFeatures();
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "getSupportedFeatures, createFeature,wait bind service fail");
        }
        LogUtils.info(TAG, "getSupportedFeatures, service not bind");
        return DEFAULT_FEATURE_LIST;
    }

    public boolean isFeatureSupported(FeatureType type) {
        LogUtils.info(TAG, "isFeatureSupported, type = {}", type.getFeatureType());
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.isFeatureSupported(type.getFeatureType());
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "isFeatureSupported,RemoteException ex : {}", ex.getMessage());
        }
        return false;
    }

    public <T extends AudioFeaturesKit> T createFeature(FeatureType type) {
        return this.mFeatureKitManager.createFeatureKit(type.getFeatureType(), this.mContext);
    }

    private void serviceInit(String packageName, String sdkVersion) {
        LogUtils.info(TAG, "serviceInit");
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                this.mIHwAudioEngine.init(packageName, sdkVersion);
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "isFeatureSupported,RemoteException ex : {}", ex.getMessage());
        }
    }

    public static enum FeatureType {
        HWAUDIO_FEATURE_KARAOKE(1);

        private int mFeatureType;

        private FeatureType(int type) {
            this.mFeatureType = type;
        }

        public int getFeatureType() {
            return this.mFeatureType;
        }
    }
}

