/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TextureTransformer {
    private static final String TAG = TextureTransformer.class.getSimpleName();
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer[] textureFrameBuffer;
    private final GlRectDrawer drawer;
    private final int maxBufferSlot;
    private final Map<Integer, Integer> textureId2SlotMap = new HashMap<Integer, Integer>();
    private final ConcurrentLinkedQueue<Integer> freeSlots = new ConcurrentLinkedQueue();
    public static final float[] IDENTITY_MATRIX = new float[16];

    public TextureTransformer(int n2) {
        this.threadChecker.checkIsOnValidThread();
        this.maxBufferSlot = Math.max(n2, 1);
        this.textureFrameBuffer = new GlTextureFrameBuffer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.textureFrameBuffer[i2] = new GlTextureFrameBuffer(6408);
            this.textureId2SlotMap.put(this.textureFrameBuffer[i2].getTextureId(), i2);
            this.freeSlots.offer(i2);
        }
        this.drawer = new GlRectDrawer();
    }

    public int copy(int n2, int n3, int n4, int n5) {
        this.threadChecker.checkIsOnValidThread();
        Integer n6 = this.freeSlots.poll();
        if (n6 == null) {
            return -1;
        }
        int n7 = n4;
        int n8 = n5;
        int n9 = n7;
        int n10 = n8;
        this.textureFrameBuffer[n6].setSize(n9, n10);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer[n6].getFrameBufferId());
        GlUtil.checkNoGLES2Error("TextureHelper.glBindFramebuffer");
        GLES20.glClear((int)16384);
        switch (n3) {
            case 11: {
                this.drawer.drawOes(n2, IDENTITY_MATRIX, n7, n8, 0, 0, n9, n10);
                break;
            }
            case 10: {
                this.drawer.drawRgb(n2, IDENTITY_MATRIX, n7, n8, 0, 0, n9, n10);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("TextureHelper.draw");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
        int n11 = this.textureFrameBuffer[n6].getTextureId();
        this.freeSlots.offer(this.textureId2SlotMap.get(n11));
        return n11;
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        for (int i2 = 0; i2 < this.maxBufferSlot; ++i2) {
            this.textureFrameBuffer[i2].release();
        }
        this.drawer.release();
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

