/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.live;

import io.agora.rtc.video.AgoraImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LiveTranscoding {
    public int width = 360;
    public int height = 640;
    public int videoBitrate = 400;
    public int videoFramerate = 15;
    @Deprecated
    public boolean lowLatency = false;
    public int videoGop = 30;
    public AgoraImage watermark;
    private ArrayList<AgoraImage> watermarkList;
    public AgoraImage backgroundImage;
    private ArrayList<AgoraImage> backgroundImageList;
    public AudioSampleRateType audioSampleRate;
    public int audioBitrate = 48;
    public int audioChannels = 1;
    public AudioCodecProfileType audioCodecProfile;
    public VideoCodecProfileType videoCodecProfile = VideoCodecProfileType.HIGH;
    public VideoCodecType videoCodecType = VideoCodecType.H264;
    @Deprecated
    public int userCount;
    @Deprecated
    public int backgroundColor = -16777216;
    public String userConfigExtraInfo = null;
    @Deprecated
    public String metadata = null;
    private Map<Integer, TranscodingUser> transcodingUsers;
    public static final String LBHQ = "lbhq";
    public static final String VEO = "veo";
    private Map<String, Boolean> advancedFeatures;

    public void addWatermark(AgoraImage agoraImage) {
        if (this.watermarkList == null) {
            this.watermarkList = new ArrayList();
        }
        this.watermarkList.add(agoraImage);
    }

    public boolean removeWatermark(AgoraImage agoraImage) {
        if (this.watermarkList == null) {
            return false;
        }
        return this.watermarkList.remove(agoraImage);
    }

    public ArrayList<AgoraImage> getWatermarkList() {
        return this.watermarkList;
    }

    public void addBackgroundImage(AgoraImage agoraImage) {
        if (this.backgroundImageList == null) {
            this.backgroundImageList = new ArrayList();
        }
        this.backgroundImageList.add(agoraImage);
    }

    public boolean removeBackgroundImage(AgoraImage agoraImage) {
        if (this.backgroundImageList == null) {
            return false;
        }
        return this.backgroundImageList.remove(agoraImage);
    }

    public ArrayList<AgoraImage> getBackgroundImageList() {
        return this.backgroundImageList;
    }

    public void setAdvancedFeatures(String string, Boolean bl) {
        this.advancedFeatures.put(string, bl);
    }

    public Map<String, Boolean> getAdvancedFeatures() {
        return this.advancedFeatures;
    }

    public LiveTranscoding() {
        this.watermark = new AgoraImage();
        this.backgroundImage = new AgoraImage();
        this.audioSampleRate = AudioSampleRateType.TYPE_44100;
        this.audioCodecProfile = AudioCodecProfileType.LC_AAC;
        this.transcodingUsers = new HashMap<Integer, TranscodingUser>();
        this.advancedFeatures = new HashMap<String, Boolean>();
    }

    public int addUser(TranscodingUser transcodingUser) {
        if (transcodingUser == null || transcodingUser.uid == 0) {
            return -2;
        }
        this.transcodingUsers.put(transcodingUser.uid, transcodingUser);
        this.userCount = this.transcodingUsers.size();
        return 0;
    }

    public final ArrayList<TranscodingUser> getUsers() {
        Collection<TranscodingUser> collection = this.transcodingUsers.values();
        return new ArrayList<TranscodingUser>(collection);
    }

    public void setUsers(ArrayList<TranscodingUser> arrayList) {
        this.transcodingUsers.clear();
        if (arrayList != null) {
            for (TranscodingUser transcodingUser : arrayList) {
                this.transcodingUsers.put(transcodingUser.uid, transcodingUser);
            }
        }
        this.userCount = this.transcodingUsers.size();
    }

    public void setUsers(Map<Integer, TranscodingUser> map) {
        this.transcodingUsers.clear();
        if (map != null) {
            this.transcodingUsers.putAll(map);
        }
        this.userCount = this.transcodingUsers.size();
    }

    public int removeUser(int n2) {
        if (!this.transcodingUsers.containsKey(n2)) {
            return -2;
        }
        this.transcodingUsers.remove(n2);
        this.userCount = this.transcodingUsers.size();
        return 0;
    }

    public int getUserCount() {
        return this.transcodingUsers.size();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int n2) {
        this.backgroundColor = n2;
    }

    public void setBackgroundColor(int n2, int n3, int n4) {
        this.backgroundColor = n2 << 16 | n3 << 8 | n4 << 0;
    }

    @Deprecated
    public int getRed() {
        return this.backgroundColor >> 16 & 0xFF;
    }

    @Deprecated
    public int getGreen() {
        return this.backgroundColor >> 8 & 0xFF;
    }

    @Deprecated
    public int getBlue() {
        return this.backgroundColor & 0xFF;
    }

    @Deprecated
    public void setRed(int n2) {
        int n3 = this.getGreen();
        int n4 = this.getBlue();
        this.backgroundColor = n2 << 16 | n3 << 8 | n4 << 0;
    }

    @Deprecated
    public void setGreen(int n2) {
        int n3 = this.getRed();
        int n4 = this.getBlue();
        this.backgroundColor = n3 << 16 | n2 << 8 | n4 << 0;
    }

    @Deprecated
    public void setBlue(int n2) {
        int n3 = this.getRed();
        int n4 = this.getGreen();
        this.backgroundColor = n3 << 16 | n4 << 8 | n2 << 0;
    }

    public static class TranscodingUser {
        public int uid;
        public int x;
        public int y;
        public int width;
        public int height;
        public int zOrder;
        public float alpha = 1.0f;
        public int audioChannel;
    }

    public static enum VideoCodecType {
        H264(1),
        H265(2);

        private int value;

        private VideoCodecType(int n3) {
            this.value = n3;
        }

        public static int getValue(VideoCodecType videoCodecType) {
            return videoCodecType.value;
        }
    }

    public static enum AudioCodecProfileType {
        LC_AAC(0),
        HE_AAC(1),
        HE_AAC_V2(2);

        private int value;

        private AudioCodecProfileType(int n3) {
            this.value = n3;
        }

        public static int getValue(AudioCodecProfileType audioCodecProfileType) {
            return audioCodecProfileType.value;
        }
    }

    public static enum VideoCodecProfileType {
        BASELINE(66),
        MAIN(77),
        HIGH(100);

        private int value;

        private VideoCodecProfileType(int n3) {
            this.value = n3;
        }

        public static int getValue(VideoCodecProfileType videoCodecProfileType) {
            return videoCodecProfileType.value;
        }
    }

    public static enum AudioSampleRateType {
        TYPE_32000(32000),
        TYPE_44100(44100),
        TYPE_48000(48000);

        private int value;

        private AudioSampleRateType(int n3) {
            this.value = n3;
        }

        public static int getValue(AudioSampleRateType audioSampleRateType) {
            return audioSampleRateType.value;
        }
    }
}

