/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.media.MediaRouter;
import android.os.Build;
import android.os.Handler;
import io.agora.rtc.audio.HardwareEarbackController;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private int mActiveRecordCnt;
    private AudioManager audioManager;
    AudioRecordingCallbackImpl mActiveRecordingCallback;
    private WeakReference<Context> mcontext;
    private static final String TAG = "AudioManagerAndroid";

    private AudioManagerAndroid(Context context) {
        Object object;
        this.mcontext = new WeakReference<Context>(context);
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        this.mActiveRecordCnt = 1;
        if (Build.VERSION.SDK_INT >= 17) {
            String string;
            object = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (object != null) {
                this.mNativeOutputSampleRate = Integer.parseInt((String)object);
            }
            if ((string = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(string);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
        this.mActiveRecordingCallback = null;
        if (Build.VERSION.SDK_INT >= 24) {
            this.mActiveRecordingCallback = new AudioRecordingCallbackImpl();
            this.audioManager.registerAudioRecordingCallback((AudioManager.AudioRecordingCallback)this.mActiveRecordingCallback, new Handler(context.getMainLooper()));
            object = this.audioManager.getActiveRecordingConfigurations();
            this.mActiveRecordCnt = object.size();
        }
        Logging.d(TAG, "ctor " + this + ", cb " + (Object)((Object)this.mActiveRecordingCallback));
    }

    private int prepareRelease() {
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "Release resource, cb " + (Object)((Object)this.mActiveRecordingCallback));
            if (this.mActiveRecordingCallback != null) {
                this.audioManager.unregisterAudioRecordingCallback((AudioManager.AudioRecordingCallback)this.mActiveRecordingCallback);
                this.mActiveRecordingCallback = null;
            }
        }
        return n2;
    }

    private int getCurrentRecordingCnt() {
        return this.mActiveRecordCnt;
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private int QuerySpeakerStatus() {
        boolean bl = this.audioManager.getMode() == 3 || this.audioManager.getMode() == 2;
        Context context = (Context)this.mcontext.get();
        if (this.audioManager == null && context != null) {
            this.audioManager = (AudioManager)context.getSystemService("audio");
        }
        if (bl) {
            if (this.audioManager.isSpeakerphoneOn()) {
                return 3;
            }
            if (this.audioManager.isBluetoothScoOn()) {
                return 5;
            }
            if (this.audioManager.isWiredHeadsetOn()) {
                return 0;
            }
            return 1;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            MediaRouter mediaRouter = (MediaRouter)context.getSystemService("media_router");
            MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute(1);
            if (routeInfo.getDeviceType() == 3) {
                return 5;
            }
            if (this.audioManager.isWiredHeadsetOn()) {
                return 0;
            }
            if (this.audioManager.isSpeakerphoneOn()) {
                return 3;
            }
            return 1;
        }
        if (this.audioManager.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        if (this.audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        this.audioManager.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetAudioMode(int n2) {
        try {
            switch (n2) {
                case 0: {
                    this.audioManager.setMode(0);
                    break;
                }
                case 1: {
                    this.audioManager.setMode(1);
                    break;
                }
                case 2: {
                    this.audioManager.setMode(2);
                    break;
                }
                case 3: {
                    this.audioManager.setMode(3);
                    break;
                }
                default: {
                    this.audioManager.setMode(0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    private int GetAudioMode() {
        return this.audioManager.getMode();
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            bl = HardwareEarbackController.getInstance(context).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        int n2 = -1;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            n2 = HardwareEarbackController.getInstance(context).enableHardwareEarback(bl);
        }
        return n2;
    }

    private int setHardwareEarbackVolume(int n2) {
        int n3 = -1;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            n3 = HardwareEarbackController.getInstance(context).setHardwareEarbackVolume(n2);
        }
        return n3;
    }

    private boolean checkAudioPermission() {
        Context context = (Context)this.mcontext.get();
        boolean bl = true;
        if (context != null) {
            bl = context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0;
        }
        return bl;
    }

    private int getStreamType() {
        int n2 = 0;
        int n3 = this.audioManager.getMode();
        if (n3 == 3) {
            n2 = 0;
        } else if (n3 == 0) {
            n2 = 3;
        } else {
            Logging.w(TAG, "invalid audio mode");
        }
        Logging.d(TAG, "get stream type is " + n2);
        return n2;
    }

    private int getCurrenPlayoutDevices() {
        int n2 = 0;
        try {
            int n3 = this.getStreamType();
            Method method = AudioManager.class.getMethod("getDevicesForStream", Integer.TYPE);
            n2 = (Integer)method.invoke((Object)this.audioManager, n3);
            Logging.d(TAG, "get current playout devices: " + n2);
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error getDevicesForStream! ", exception);
        }
        return n2;
    }

    @TargetApi(value=24)
    private class AudioRecordingCallbackImpl
    extends AudioManager.AudioRecordingCallback {
        private AudioRecordingCallbackImpl() {
        }

        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> list) {
            super.onRecordingConfigChanged(list);
            Logging.d(AudioManagerAndroid.TAG, "recording callback, cnt : " + list.size());
            for (AudioRecordingConfiguration audioRecordingConfiguration : list) {
            }
            AudioManagerAndroid.this.mActiveRecordCnt = list.size();
        }
    }
}

