/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.util.Log;
import android.view.Surface;

public final class EglCore {
    private static final String TAG = "GDPGlUtil";
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;

    public EglCore() {
        this(null, 0);
    }

    public EglCore(EGLContext eGLContext, int n2) {
        EGLContext eGLContext2;
        int[] nArray;
        Object object;
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("EGL already set up");
        }
        if (eGLContext == null) {
            eGLContext = EGL14.EGL_NO_CONTEXT;
        }
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] nArray2 = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])nArray2, (int)0, (int[])nArray2, (int)1)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        if ((n2 & 2) != 0 && (object = this.getConfig(n2, 3)) != null) {
            nArray = new int[]{12440, 3, 12344};
            eGLContext2 = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)object, (EGLContext)eGLContext, (int[])nArray, (int)0);
            if (EGL14.eglGetError() == 12288) {
                this.mEGLConfig = object;
                this.mEGLContext = eGLContext2;
                this.mGlVersion = 3;
            }
        }
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
            object = this.getConfig(n2, 2);
            if (object == null) {
                throw new RuntimeException("Unable to find a suitable EGLConfig");
            }
            nArray = new int[]{12440, 2, 12344};
            eGLContext2 = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)object, (EGLContext)eGLContext, (int[])nArray, (int)0);
            this.checkEglError("eglCreateContext");
            this.mEGLConfig = object;
            this.mEGLContext = eGLContext2;
            this.mGlVersion = 2;
        }
        object = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])object, (int)0);
        Log.d((String)TAG, (String)("EGLContext created, client version " + (int)object[0]));
    }

    private EGLConfig getConfig(int n2, int n3) {
        int[] nArray;
        EGLConfig[] eGLConfigArray;
        int n4 = 4;
        if (n3 >= 3) {
            n4 |= 0x40;
        }
        int[] nArray2 = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, n4, 12344, 0, 12344};
        if ((n2 & 1) != 0) {
            nArray2[nArray2.length - 3] = 12610;
            nArray2[nArray2.length - 2] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])nArray2, (int)0, (EGLConfig[])(eGLConfigArray = new EGLConfig[1]), (int)0, (int)eGLConfigArray.length, (int[])(nArray = new int[1]), (int)0)) {
            Log.w((String)TAG, (String)("unable to find RGB8888 / " + n3 + " EGLConfig"));
            return null;
        }
        return eGLConfigArray[0];
    }

    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
                Log.w((String)TAG, (String)"WARNING: EglCore was not explicitly released -- state may be leaked");
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void releaseSurface(EGLSurface eGLSurface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public EGLSurface createWindowSurface(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + object);
        }
        int[] nArray = new int[]{12344};
        EGLSurface eGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)object, (int[])nArray, (int)0);
        this.checkEglError("eglCreateWindowSurface");
        if (eGLSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eGLSurface;
    }

    public EGLSurface createOffscreenSurface(int n2, int n3) {
        int[] nArray = new int[]{12375, n2, 12374, n3, 12344};
        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])nArray, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eGLSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eGLSurface;
    }

    public void makeCurrent(EGLSurface eGLSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Log.d((String)TAG, (String)"NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public void makeCurrent(EGLSurface eGLSurface, EGLSurface eGLSurface2) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Log.d((String)TAG, (String)"NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface2, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent(draw,read) failed");
        }
    }

    public void makeNothingCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public boolean swapBuffers(EGLSurface eGLSurface) {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public void setPresentationTime(EGLSurface eGLSurface, long l2) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (long)l2);
    }

    public boolean isCurrent(EGLSurface eGLSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eGLSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    public int querySurface(EGLSurface eGLSurface, int n2) {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (int)n2, (int[])nArray, (int)0);
        return nArray[0];
    }

    public String queryString(int n2) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)n2);
    }

    public int getGlVersion() {
        return this.mGlVersion;
    }

    public static void logCurrent(String string) {
        EGLDisplay eGLDisplay = EGL14.eglGetCurrentDisplay();
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        EGLSurface eGLSurface = EGL14.eglGetCurrentSurface((int)12377);
        Log.i((String)TAG, (String)("Current EGL (" + string + "): display=" + eGLDisplay + ", context=" + eGLContext + ", surface=" + eGLSurface));
    }

    private void checkEglError(String string) {
        int n2 = EGL14.eglGetError();
        if (n2 != 12288) {
            throw new RuntimeException(string + ": EGL error: 0x" + Integer.toHexString(n2));
        }
    }
}

