/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.SparseIntArray;
import io.agora.rtc.internal.AudioDeviceInventoryLowerThanM;
import io.agora.rtc.internal.AudioDeviceInventoryMorHigher;
import io.agora.rtc.internal.AudioRoutingListener;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private WeakReference<Context> mContext;
    private EventHandler mEventHandler;
    private WeakReference<AudioRoutingListener> mListener;
    AudioManager am = null;
    private static final int HEADSET = 0;
    private static final int EARPIECE = 1;
    private static final int SPEAKER = 3;
    private static final int STOP = 4;
    private static final int BLUETOOTH = 5;
    private AudioRouteState mState;
    private StopState mStopState = null;
    private SpeakerState mSpeakerState = null;
    private EarpieceState mEarpieceState = null;
    private BTState mBTState = null;
    private HeadsetState mHeadsetState = null;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET_A2DP = 2;
    private static final int EVT_BT_SCO = 3;
    private static final int EVT_BT_HEADSET_HFP = 4;
    public static final int CMD_DEFAULT_DEVICE = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    public static final int EVT_USING_COMM_PARAMETERS = 112;
    public static final int EVT_USING_NORM_PARAMETERS = 113;
    public static final int EVT_AUDIO_ADM_ROUTING_UPDATE = 114;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int DEVICE_HEADSET = 1;
    public static final int DEVICE_HEADPHONE = 2;
    public static final int DEVICE_BLUETOOTH_SCO = 3;
    public static final int DEVICE_BLUETOOTH_A2DP = 4;
    public static final int DEVICE_USB_HEADSET = 5;
    private static final int FEATURE_BYPASS_A2DP_Y = 0;
    private static final int FEATURE_BYPASS_A2DP_N = 1;
    private static final int FEATURE_ROUTING_V_BELOW_M = 2;
    private static final int FEATURE_ROUTING_V_HIGHER_M = 3;
    private AudioDeviceList mAvailDevices;
    private int mTargetRoute = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private boolean mVideoDisabled = true;
    private boolean mMuteLocal = false;
    private boolean mMuteRemotes = false;
    private boolean mPhoneInCall = false;
    private boolean mHfpEnable = false;
    private boolean mA2dpEnable = false;
    private boolean mA2dpEventBypass = false;
    private AudioDeviceInventory mAudioDeviceInventory;
    AudioManagerScoStateReceiver mScoStateReceiver = null;
    private int mVersionInUsed;
    public static final int DEVICE_EVT_BT_OFF = 0;
    public static final int DEVICE_EVT_BT_RECONNECT = 1;
    private static final SparseIntArray ROUTE_TYPE_TO_EVT = new SparseIntArray();
    private int mStreamType = 0;
    private int mChannelProfile = 1;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 3000;
    private static final int BLUETOOTH_RESET_BT_DELAY = 3000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 3;
    private int dynamic_timeout = 0;
    private int mScoConnectionAttemps;
    private int mLastNotifiedRouting = -1;
    private int mHfpDeviceId = -1;
    private final Runnable TryConnectBtScoRunnable = new Runnable(){

        @Override
        public void run() {
            AudioRoutingController.this.tryToConnectBtSco();
        }
    };
    private final Runnable TrytoResetBTRunnable = new Runnable(){

        @Override
        public void run() {
            if (!AudioRoutingController.this.am.isBluetoothA2dpOn() && !AudioRoutingController.this.am.isBluetoothScoOn()) {
                Logging.d(AudioRoutingController.TAG, "bluetooth routing start failed a2dp:false sco:false");
                if (AudioRoutingController.this.mListener.get() != null) {
                    ((AudioRoutingListener)AudioRoutingController.this.mListener.get()).onAudioRoutingError(1800);
                }
            }
        }
    };

    private void checkNeedResetBT() {
        this.mEventHandler.postDelayed(this.TrytoResetBTRunnable, 3000L);
    }

    private void startTimer() {
        this.dynamic_timeout += 3000;
        Logging.i(TAG, "audio route start bluetooth timer " + this.dynamic_timeout + ", times:" + this.mScoConnectionAttemps);
        this.mEventHandler.postDelayed(this.TryConnectBtScoRunnable, 3000L);
    }

    private void cancelTimer() {
        Logging.i(TAG, "cancel bluetooth timer");
        this.dynamic_timeout = 0;
        this.mScoConnectionAttemps = 0;
        this.mEventHandler.removeCallbacks(this.TryConnectBtScoRunnable);
    }

    private void rescheTimer() {
        Logging.i(TAG, "re-schedule bluetooth timer");
        this.mEventHandler.removeCallbacks(this.TryConnectBtScoRunnable);
        this.mEventHandler.postDelayed(this.TryConnectBtScoRunnable, 0L);
    }

    public AudioRoutingController(Context context, AudioRoutingListener audioRoutingListener) {
        this.mContext = new WeakReference<Context>(context);
        this.mListener = new WeakReference<AudioRoutingListener>(audioRoutingListener);
        this.am = this.getAudioManager();
        this.mVersionInUsed = Build.VERSION.SDK_INT >= 31 ? 1 : 0;
    }

    private void changeState(int n2) {
        switch (n2) {
            case 4: {
                if (this.mStopState == null) {
                    this.mStopState = new StopState();
                }
                this.mState = this.mStopState;
                Logging.d(TAG, "--------------------Comming to STOP-------------------- ");
                break;
            }
            case 5: {
                if (this.mBTState == null) {
                    this.mBTState = new BTState();
                }
                this.mState = this.mBTState;
                Logging.d(TAG, "--------------------Comming to BLUETOOTH--------------- ");
                break;
            }
            case 0: {
                if (this.mHeadsetState == null) {
                    this.mHeadsetState = new HeadsetState();
                }
                this.mState = this.mHeadsetState;
                Logging.d(TAG, "--------------------Comming to HEADSET----------------- ");
                break;
            }
            case 3: {
                if (this.mSpeakerState == null) {
                    this.mSpeakerState = new SpeakerState();
                }
                this.mState = this.mSpeakerState;
                Logging.d(TAG, "--------------------Comming to SPEAKER----------------- ");
                break;
            }
            case 1: {
                if (this.mEarpieceState == null) {
                    this.mEarpieceState = new EarpieceState();
                }
                this.mState = this.mEarpieceState;
                Logging.d(TAG, "--------------------Comming to EARPIECE---------------- ");
                break;
            }
            default: {
                Logging.d(TAG, "--------------------Comming to UNKNOWN STATE----------- ");
                if (this.mSpeakerState == null) {
                    this.mSpeakerState = new SpeakerState();
                }
                this.mState = this.mSpeakerState;
            }
        }
        this.mState.switchtoTargetRoute();
    }

    public void sendEvent(int n2, int n3) {
        Logging.d(TAG, "sendEvent: [" + this.getEventDesc(n2) + "], Parameters: " + n3 + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(n2, n3, 0);
            this.mEventHandler.sendMessage(message);
        }
    }

    public void sendEvent(int n2, int n3, int n4) {
        Logging.d(TAG, "sendEvent: [" + this.getEventDesc(n2) + "], Parameters: " + n3 + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(n2, n3, n4);
            this.mEventHandler.sendMessage(message);
        }
    }

    public void sendBtEventDelay(int n2, int n3, int n4, int n5) {
        Logging.d(TAG, "sendBtEventDelay: [" + this.getEventDesc(n2) + "], Parameters: " + n3 + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            this.mEventHandler.removeMessages(4);
            this.mEventHandler.removeMessages(2);
            Message message = this.mEventHandler.obtainMessage(n2, n3, n4);
            this.mEventHandler.sendMessageDelayed(message, n5);
        }
    }

    public int resetAudioDeviceInventory() {
        if (this.mAudioDeviceInventory != null) {
            this.mAudioDeviceInventory.dispose();
        }
        return this.initAudioDeviceInventory();
    }

    public int initAudioDeviceInventory() {
        int n2;
        Context context = (Context)this.mContext.get();
        if (context == null) {
            Logging.e(TAG, "initAudioDeviceInventory Failed cause of invalid context");
            return -1;
        }
        if (this.mVersionInUsed == 1 && Build.VERSION.SDK_INT >= 23) {
            this.mAudioDeviceInventory = new AudioDeviceInventoryMorHigher(context);
            n2 = 1;
        } else {
            this.mAudioDeviceInventory = new AudioDeviceInventoryLowerThanM(context);
            n2 = 0;
        }
        this.mAudioDeviceInventory.setAudioDeviceChangeCallback(new AudioDeviceChangedCallbackImpl());
        this.mAudioDeviceInventory.initialize();
        Logging.i(TAG, "initAudioDeviceInventory to " + (n2 == 1 ? "Callback Invertory " : "Old intent Inventory"));
        return n2;
    }

    public int initialize() {
        Logging.i(TAG, "initialize +");
        this.mAvailDevices = new AudioDeviceList();
        this.mAvailDevices.mDefaultRoute = -1;
        this.mAvailDevices.mForcedRoute = -1;
        this.mAvailDevices.mHeadSetRoute = -1;
        this.mAvailDevices.mBTRoute = -1;
        Context context = (Context)this.mContext.get();
        if (context == null || this.am == null) {
            Logging.e(TAG, "Initilize Failed cause of invalid context or invalid audiomanager");
            return -1;
        }
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mEventHandler = new EventHandler(handlerThread.getLooper());
        this.initAudioDeviceInventory();
        this.changeState(4);
        this.mScoStateReceiver = new AudioManagerScoStateReceiver();
        IntentFilter intentFilter = new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        context.registerReceiver((BroadcastReceiver)this.mScoStateReceiver, intentFilter);
        this.mScoStateReceiver.setRegistered(true);
        Logging.i(TAG, "initialize -");
        return 0;
    }

    public void uninitialize() {
        Logging.d(TAG, "uninitialize");
        if (this.mAudioDeviceInventory != null) {
            this.mAudioDeviceInventory.dispose();
        }
        if (this.mScoStateReceiver != null && this.mScoStateReceiver.getRegistered()) {
            Context context = (Context)this.mContext.get();
            if (context != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mScoStateReceiver);
                Logging.d(TAG, "unregisterReceiver mScoStateReceiver");
            }
            this.mScoStateReceiver.setRegistered(false);
        }
    }

    public void startMonitoring(int n2, int n3) {
        Context context = (Context)this.mContext.get();
        int n4 = 0;
        Logging.i(TAG, "--------------Comming to startMonitoring--------------------");
        this.notifyAudioBtProfileChanged();
        this.changeAvailDevices(10, n2);
        this.mChannelProfile = n3;
        if (this.mAvailDevices.mDefaultRoute == -1) {
            if (this.mChannelProfile == 0 && this.isAudioOnly()) {
                this.changeAvailDevices(10, 1);
                this.am.setSpeakerphoneOn(false);
            } else {
                this.changeAvailDevices(10, 3);
                if (this.am.getMode() != 3) {
                    this.am.setSpeakerphoneOn(false);
                    this.am.setSpeakerphoneOn(true);
                }
            }
        }
        this.mTargetRoute = -1;
        if (this.getBtDeviceList() > 0) {
            this.mAvailDevices.mBTRoute = 5;
        }
        n4 = this.setTargetRouteByPriority();
        Logging.i(TAG, "mDefaultRoute: ," + this.mAvailDevices.mDefaultRoute + "  mAvailDevices.mForcedRoute :" + this.mAvailDevices.mForcedRoute);
        Logging.i(TAG, "mBtRoute: " + this.getAudioRouteDesc(this.mAvailDevices.mBTRoute) + ",mAvailDevices.mHeadSetRoute :" + this.getAudioRouteDesc(this.mAvailDevices.mHeadSetRoute));
        if (n4 == 5) {
            this.checkNeedResetBT();
        }
        this.changeState(n4);
    }

    public void stopMonitoring() {
        Logging.i(TAG, "Stop Mornitor State process");
        this.changeState(4);
    }

    public void setRoutingFeature(int n2) {
        Logging.d(TAG, "setRoutingFeature : " + n2);
        if (n2 == 0) {
            this.mA2dpEventBypass = true;
        } else if (n2 == 1) {
            this.mA2dpEventBypass = false;
        } else if (n2 == 2 && this.mVersionInUsed == 1) {
            this.mVersionInUsed = 0;
            this.resetAudioDeviceInventory();
        } else if (n2 == 3 && this.mVersionInUsed == 0) {
            this.mVersionInUsed = 1;
            this.resetAudioDeviceInventory();
        }
    }

    public void clearListenerNativeHandle() {
        Logging.d(TAG, "clearListenerNativeHandle");
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingDestroyed();
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int n2) {
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingChanged(n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private void updateAudioBtProfileState() {
        this.mA2dpEnable = this.mAudioDeviceInventory.isDeviceAvaliable(4);
        this.mHfpEnable = this.mAudioDeviceInventory.isDeviceAvaliable(3);
    }

    private void notifyAudioBtProfileChanged() {
        this.updateAudioBtProfileState();
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            int n2 = 0;
            n2 |= this.mHfpEnable ? 1 : 0;
            audioRoutingListener.onAudioBtProfileChanged(n2 |= this.mA2dpEnable ? 2 : 0);
            Logging.i(TAG, "BT headset  btProfile " + n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    public void changeAvailDevices(int n2, int n3) {
        switch (n2) {
            case 11: {
                if (n3 == 0) {
                    this.mAvailDevices.mForcedRoute = 1;
                    break;
                }
                this.mAvailDevices.mForcedRoute = 3;
                break;
            }
            case 1: {
                if (n3 >= 0) {
                    this.mAvailDevices.mHeadSetRoute = n3 > 0 ? 2 : 0;
                    break;
                }
                this.mAvailDevices.mHeadSetRoute = -1;
                break;
            }
            case 2: 
            case 4: {
                if (this.mA2dpEnable | this.mHfpEnable) {
                    this.mAvailDevices.mBTRoute = 5;
                    break;
                }
                this.mAvailDevices.mBTRoute = -1;
                break;
            }
            case 10: {
                this.mAvailDevices.mDefaultRoute = n3;
                break;
            }
            default: {
                Logging.i(TAG, "No device changed!");
            }
        }
        Logging.i(TAG, "event device changed!" + n2 + "  mAvailDevices.mDefaultRoute" + this.mAvailDevices.mDefaultRoute);
    }

    private void enableBtSco() {
        try {
            this.am.startBluetoothSco();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void disableBtSco() {
        try {
            this.am.stopBluetoothSco();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resetBtSco() {
        this.disableBtSco();
        this.cancelTimer();
        this.enableBtSco();
        this.startTimer();
    }

    private String modeAsString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "MODE_NORMAL";
                break;
            }
            case 1: {
                string = "MODE_RINGTONE";
                break;
            }
            case 2: {
                string = "MODE_IN_CALL";
                break;
            }
            case 3: {
                string = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                string = "Unknown " + n2;
            }
        }
        return string;
    }

    private void tryToConnectBtSco() {
        if (this.am.isBluetoothScoOn()) {
            return;
        }
        try {
            if (++this.mScoConnectionAttemps < 3) {
                this.startTimer();
                Logging.d(TAG, "Attemp retry sco connected  times:" + this.mScoConnectionAttemps);
                this.am.stopBluetoothSco();
                this.enableBtSco();
                Logging.e(TAG, "start bluetooth sco on ? " + this.am.isBluetoothScoOn() + ",audiomode:" + this.am.getMode());
            } else {
                Logging.e(TAG, "start bluetooth sco timeout, mA2dpEventBypass " + this.mA2dpEventBypass);
                if (!this.mA2dpEventBypass) {
                    this.am.setMode(0);
                    this.am.stopBluetoothSco();
                    this.checkFallbackA2dpIfNeed();
                }
                if (this.mListener.get() != null) {
                    ((AudioRoutingListener)this.mListener.get()).onAudioRoutingError(1030);
                }
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "fatal error for connect sco", exception);
        }
    }

    private void checkFallbackA2dpIfNeed() {
        if (!this.mA2dpEnable) {
            return;
        }
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioBtProfileChanged(2);
            this.notifyAudioRoutingChanged(5);
            this.checkNeedResetBT();
            Logging.i(TAG, "set A2DP profile only to fallback !");
        }
    }

    private boolean sysRouteToBt() {
        boolean bl = true;
        Context context = (Context)this.mContext.get();
        if (Build.VERSION.SDK_INT >= 24 && context != null) {
            MediaRouter mediaRouter = (MediaRouter)context.getSystemService("media_router");
            MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute(1);
            bl = routeInfo.getDeviceType() == 3;
        }
        return bl;
    }

    private int getBtDeviceList() {
        this.mA2dpEnable = this.mAudioDeviceInventory.isDeviceAvaliable(4);
        this.mHfpEnable = this.mAudioDeviceInventory.isDeviceAvaliable(3);
        int n2 = this.mA2dpEventBypass ? (this.mHfpEnable ? 1 : 0) : (this.mHfpEnable || this.mA2dpEnable ? 1 : 0);
        Logging.i(TAG, "System bluetooth state:  hfp " + this.mHfpEnable + " a2dp " + this.mA2dpEnable);
        return n2;
    }

    private String getAudioRouteDesc(int n2) {
        switch (n2) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "UNSET";
            }
        }
        return "Unknown";
    }

    private String getEventDesc(int n2) {
        switch (n2) {
            case 1: {
                return "headset connect/disconnect event";
            }
            case 4: {
                return "bt hfp connect/disconnect event";
            }
            case 2: {
                return "bt a2dp connect/disconnect event";
            }
            case 3: {
                return "sco connect/disconnect event";
            }
            case 11: {
                return "set forcespeakerphone event";
            }
            case 112: {
                return "communication stream event";
            }
            case 113: {
                return "music stream event";
            }
        }
        return "unkown event";
    }

    private int setTargetRouteByPriority() {
        try {
            if (this.mAvailDevices.mBTRoute != -1 && this.mAvailDevices.mHeadSetRoute != -1) {
                if (this.sysRouteToBt()) {
                    return 5;
                }
                return 0;
            }
            if (this.mAvailDevices.mBTRoute != -1) {
                return 5;
            }
            if (this.mAvailDevices.mHeadSetRoute != -1 && this.isHeadSetConnected()) {
                return 0;
            }
            if (this.mAvailDevices.mForcedRoute != -1) {
                return this.mAvailDevices.mForcedRoute;
            }
            return this.mAvailDevices.mDefaultRoute;
        }
        catch (Exception exception) {
            Logging.e(TAG, "fatal error setTargetRouteByPriority", exception);
            return -1;
        }
    }

    private boolean isHeadSetConnected() {
        if (this.am == null) {
            return false;
        }
        return this.am.isWiredHeadsetOn();
    }

    private boolean isSpeakerEnable() {
        if (this.am == null) {
            return true;
        }
        return this.am.isSpeakerphoneOn();
    }

    private void checkAndUpdateRouteAfterCall() {
        if (this.mPhoneInCall) {
            return;
        }
        int n2 = this.setTargetRouteByPriority();
        if (n2 != this.mTargetRoute) {
            Logging.i(TAG, "after call, sys route is different from sdk route, update to " + n2);
            this.sendEvent(114, n2);
        }
    }

    protected boolean hasPermission(Context context, String string) {
        return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    public void muteAudioStream(boolean bl) {
        try {
            boolean bl2 = false;
            if (Build.VERSION.SDK_INT >= 23) {
                if (bl) {
                    this.am.adjustStreamVolume(3, -100, 0);
                } else {
                    this.am.adjustStreamVolume(3, 100, 0);
                }
            } else if (bl) {
                this.am.setStreamMute(3, true);
            } else {
                this.am.setStreamMute(3, false);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "muteAudioStream: " + exception);
        }
    }

    static {
        ROUTE_TYPE_TO_EVT.put(1, 1);
        ROUTE_TYPE_TO_EVT.put(2, 1);
        ROUTE_TYPE_TO_EVT.put(3, 4);
        ROUTE_TYPE_TO_EVT.put(4, 2);
    }

    private class HeadsetState
    extends AudioRouteBaseState {
        private HeadsetState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At HeadSet Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            super.headSetPlugOutProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At HeadSet headSetPlugOutProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                AudioRoutingController.this.changeState(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute);
            } else {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btPlugInProcess(int n2, int n3, int n4) {
            super.btPlugInProcess(n2, n3, n4);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At HeadSet bt PlugInProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3, int n4) {
            super.btPlugOutProcess(n2, n3, n4);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            super.btScoConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoConnectProcess Nothing to-do");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            super.btScoDisConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoDisConnectProcess Nothing to-do");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute) {
                AudioRoutingController.this.mTargetRoute = ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute;
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At HeadSet State switchtoTargetRoute:  " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute));
            }
        }
    }

    private class BTState
    extends AudioRouteBaseState {
        private BTState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet connect event param = " + n3);
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            if (AudioRoutingController.this.mStreamType == 0) {
                AudioRoutingController.this.disableBtSco();
            }
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            super.headSetPlugOutProcess(n2, n3);
            AudioRoutingController.this.am.setSpeakerphoneOn(false);
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet disconnect,Nothting need todo ");
        }

        @Override
        public void btPlugInProcess(int n2, int n3, int n4) {
            super.btPlugInProcess(n2, n3, n4);
            Logging.i(AudioRoutingController.TAG, "At BTState Process bt plug in event " + n2);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.notifyAudioRoutingChanged(5);
            if (4 == n2 && AudioRoutingController.this.mStreamType == 0) {
                Logging.i(AudioRoutingController.TAG, "At BTState Process bt plug in process reconnect sco!");
                AudioRoutingController.this.resetBtSco();
            }
        }

        @Override
        public void btPlugOutProcess(int n2, int n3, int n4) {
            super.btPlugOutProcess(n2, n3, n4);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At BTState Process bt plug out, mStreamType " + AudioRoutingController.this.mStreamType + " event " + n2 + " deviceId " + n4 + " mHfpDeviceId " + AudioRoutingController.this.mHfpDeviceId);
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                Logging.i(AudioRoutingController.TAG, "At BTState Process bt plug out but still has other headset!");
                if (n2 == 4 && AudioRoutingController.this.mHfpEnable) {
                    AudioRoutingController.this.resetBtSco();
                    return;
                }
                if (AudioRoutingController.this.sysRouteToBt() && AudioRoutingController.this.am.isBluetoothA2dpOn()) {
                    AudioRoutingController.this.changeState(5);
                    AudioRoutingController.this.notifyAudioRoutingChanged(5);
                    return;
                }
                Logging.i(AudioRoutingController.TAG, "At BTState Process bt plug out but route error!");
                AudioRoutingController.this.cancelTimer();
                AudioRoutingController.this.disableBtSco();
                if (AudioRoutingController.this.mListener.get() != null) {
                    ((AudioRoutingListener)AudioRoutingController.this.mListener.get()).onAudioRoutingError(1800);
                }
            }
            if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute != -1) {
                AudioRoutingController.this.changeState(0);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute);
            } else {
                Logging.i(AudioRoutingController.TAG, "At BTState Process btPlugOutProcess default device:" + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            super.btScoConnectProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            try {
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Logging.i(AudioRoutingController.TAG, "At BTState Process SCO Connect,Nothing todo since already in BT State");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process BT SCO DisConnect");
            super.btScoDisConnectProcess(n2, n3);
            if (AudioRoutingController.this.mStreamType == 0) {
                AudioRoutingController.this.rescheTimer();
            }
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            AudioRoutingController.this.enableBtSco();
            AudioRoutingController.this.startTimer();
            Logging.i(AudioRoutingController.TAG, "At BTState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            AudioRoutingController.this.cancelTimer();
            AudioRoutingController.this.disableBtSco();
            Logging.i(AudioRoutingController.TAG, "At BTState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (5 != AudioRoutingController.this.mTargetRoute) {
                AudioRoutingController.this.mTargetRoute = 5;
                AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At BT State switchtoTargetRoute:  " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute));
            }
        }
    }

    private class EarpieceState
    extends AudioRouteBaseState {
        private EarpieceState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.muteAudioStream(true);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3, int n4) {
            super.btPlugInProcess(n2, n3, n4);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.changeState(5);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process BT connect event");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.forceSpkProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process ForceSpeaker event param =  " + n3);
            if (!AudioRoutingController.this.isSpeakerEnable()) {
                AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController.this.changeState(3);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At Earpiece Process SCO connect event,Nothing to-do");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (1 != AudioRoutingController.this.mTargetRoute) {
                AudioRoutingController.this.mTargetRoute = 1;
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At Earpiece State switchtoTargetRoute: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute));
            }
        }
    }

    private class SpeakerState
    extends AudioRouteBaseState {
        private SpeakerState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3, int n4) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.btPlugInProcess(n2, n3, n4);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process BT connect event");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.forceEarpieceProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process ForceEarpiece event param =  " + n3);
            AudioRoutingController.this.changeState(1);
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.forceSpkProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process ForceSpeaker event param =  " + n3);
            if (!AudioRoutingController.this.isSpeakerEnable()) {
                int n4 = AudioRoutingController.this.am.getMode();
                Logging.i(AudioRoutingController.TAG, "At SpeakerState Process audio mode =  " + n4);
                AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController.this.changeState(3);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process SCO connect event,Nothing to-do");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != 3) {
                AudioRoutingController.this.mTargetRoute = 3;
                AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At Speaker State switchtoTargetRoute: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute));
            }
        }
    }

    private class StopState
    extends AudioRouteBaseState {
        private StopState() {
        }

        @Override
        public void switchtoTargetRoute() {
            Logging.i(AudioRoutingController.TAG, "Coming to Stop state, switchtoTargetRoute");
            AudioRoutingController.this.cancelTimer();
            AudioRoutingController.this.disableBtSco();
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = AudioRoutingController.this.getBtDeviceList() > 0 ? 5 : -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute = AudioRoutingController.this.isHeadSetConnected() ? 0 : -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute = -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute = -1;
            AudioRoutingController.this.mTargetRoute = -1;
        }
    }

    private abstract class AudioRouteBaseState
    implements AudioRouteState {
        private AudioRouteBaseState() {
        }

        @Override
        public void switchtoTargetRoute() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugin event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + AudioRoutingController.this.getAudioRouteDesc(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugout event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + AudioRoutingController.this.getAudioRouteDesc(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void btPlugInProcess(int n2, int n3, int n4) {
            AudioRoutingController.this.notifyAudioBtProfileChanged();
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            AudioRoutingController.this.mHfpDeviceId = 4 == n2 ? n4 : AudioRoutingController.this.mHfpDeviceId;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugin event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3, int n4) {
            AudioRoutingController.this.updateAudioBtProfileState();
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugout event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Connect event ");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = AudioRoutingController.this.getBtDeviceList() > 0 ? 5 : -1;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Disconnect, bt route: " + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute);
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceEarpiece event ");
        }

        @Override
        public void phoneChangeEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mPhoneInCall = n3 > 0;
            AudioRoutingController.this.checkAndUpdateRouteAfterCall();
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Phone state change event " + n3);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mStreamType = 0;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Communication stream event ");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mStreamType = 3;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Music stream event");
        }
    }

    private static interface AudioRouteState {
        public void switchtoTargetRoute();

        public void headSetPlugInProcess(int var1, int var2);

        public void headSetPlugOutProcess(int var1, int var2);

        public void btPlugInProcess(int var1, int var2, int var3);

        public void btPlugOutProcess(int var1, int var2, int var3);

        public void btScoConnectProcess(int var1, int var2);

        public void btScoDisConnectProcess(int var1, int var2);

        public void forceSpkProcess(int var1, int var2);

        public void forceEarpieceProcess(int var1, int var2);

        public void phoneChangeEvtProcess(int var1, int var2);

        public void commStreamEvtProcess(int var1, int var2);

        public void musicStreamEvtProcess(int var1, int var2);
    }

    private class AudioManagerScoStateReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private AudioManagerScoStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (string.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                int n2 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                int n3 = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                Logging.i(AudioRoutingController.TAG, "BT ACTION_SCO_AUDIO_STATE_UPDATED prev " + n3 + "," + n2);
                switch (n2) {
                    case 1: {
                        Logging.i(AudioRoutingController.TAG, "Bluetooth SCO state connected");
                        AudioRoutingController.this.sendEvent(3, 1);
                        break;
                    }
                    case 2: {
                        Logging.i(AudioRoutingController.TAG, "Bluetooth SCO state connecting");
                        break;
                    }
                    case -1: {
                        Logging.i(AudioRoutingController.TAG, "Bluetooth SCO state error");
                        break;
                    }
                    case 0: {
                        Logging.i(AudioRoutingController.TAG, "Bluetooth SCO state disconnected");
                        AudioRoutingController.this.sendEvent(3, 0);
                        break;
                    }
                    default: {
                        Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device unknown event, state=" + n2);
                    }
                }
            }
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }
    }

    private class AudioDeviceChangedCallbackImpl
    implements AudioDeviceChangedCallback {
        private AudioDeviceChangedCallbackImpl() {
        }

        @Override
        public void onAudioDeviceChanged(int n2, boolean bl) {
            switch (n2) {
                case 3: {
                    int n3 = bl ? 1 : 0;
                    int n4 = bl ? 1000 : 500;
                    AudioRoutingController.this.sendBtEventDelay(4, n3, -1, n4);
                    break;
                }
                case 4: {
                    if (AudioRoutingController.this.mA2dpEventBypass) {
                        Logging.w(AudioRoutingController.TAG, "dont handle a2dp event !");
                        return;
                    }
                    int n5 = bl ? 1 : 0;
                    int n6 = bl ? 1000 : 500;
                    AudioRoutingController.this.sendBtEventDelay(2, n5, -1, n6);
                    break;
                }
                case 2: {
                    int n7 = bl ? 2 : -1;
                    AudioRoutingController.this.sendEvent(1, n7);
                    break;
                }
                case 1: {
                    int n8 = bl ? 0 : -1;
                    AudioRoutingController.this.sendEvent(1, n8);
                    break;
                }
                default: {
                    Logging.i(AudioRoutingController.TAG, "not handle device: " + n2 + " connect: " + bl);
                }
            }
        }

        @Override
        public void onAudioDeviceEvent(int n2) {
            if (n2 == 0) {
                AudioRoutingController.this.cancelTimer();
            } else if (n2 == 1) {
                // empty if block
            }
        }
    }

    public static interface AudioDeviceChangedCallback {
        public void onAudioDeviceChanged(int var1, boolean var2);

        public void onAudioDeviceEvent(int var1);
    }

    public static interface AudioDeviceInventory {
        public void initialize();

        public void dispose();

        public boolean isDeviceAvaliable(int var1);

        public void setAudioDeviceChangeCallback(AudioDeviceChangedCallback var1);
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            int n2 = message.what;
            int n3 = message.arg1;
            if (AudioRoutingController.this.mState == null) {
                Logging.e(AudioRoutingController.TAG, "dont handle evt " + n2 + " in error state!");
                return;
            }
            switch (n2) {
                case 11: {
                    if (n3 == 0) {
                        AudioRoutingController.this.mState.forceEarpieceProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.forceSpkProcess(n2, n3);
                    break;
                }
                case 114: {
                    AudioRoutingController.this.changeState(n3);
                    break;
                }
                case 1: {
                    if (n3 >= 0) {
                        AudioRoutingController.this.mState.headSetPlugInProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.headSetPlugOutProcess(n2, n3);
                    break;
                }
                case 3: {
                    if (n3 == 1) {
                        AudioRoutingController.this.mState.btScoConnectProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.btScoDisConnectProcess(n2, n3);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = message.arg2;
                    if (n3 == 1) {
                        AudioRoutingController.this.mState.btPlugInProcess(n2, n3, n4);
                        break;
                    }
                    AudioRoutingController.this.mState.btPlugOutProcess(n2, n3, n4);
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mState.phoneChangeEvtProcess(n2, n3);
                    break;
                }
                case 112: {
                    AudioRoutingController.this.mState.commStreamEvtProcess(n2, n3);
                    break;
                }
                case 113: {
                    AudioRoutingController.this.mState.musicStreamEvtProcess(n2, n3);
                    break;
                }
                case 14: {
                    AudioRoutingController.this.mVideoDisabled = n3 > 0;
                    break;
                }
                case 12: {
                    AudioRoutingController.this.mMuteLocal = n3 > 0;
                    break;
                }
                case 13: {
                    AudioRoutingController.this.mMuteRemotes = n3 > 0;
                    break;
                }
            }
        }
    }

    public static class AudioDeviceList {
        public int mForcedRoute;
        public int mDefaultRoute;
        public int mHeadSetRoute;
        public int mBTRoute;
    }
}

