/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-Bitmaps;
import coil.util.-Extensions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/decode/DrawableDecoderService;", "", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "(Lcoil/bitmap/BitmapPool;)V", "convert", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "config", "Landroid/graphics/Bitmap$Config;", "size", "Lcoil/size/Size;", "scale", "Lcoil/size/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "Companion", "coil-base_release"})
public final class DrawableDecoderService {
    private final BitmapPool bitmapPool;
    private static final int DEFAULT_SIZE = 512;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Bitmap convert(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Size size, @NotNull Scale scale, boolean allowInexactSize) {
        void oldRight;
        void oldTop;
        void oldLeft;
        Rect rect;
        void width;
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
            if (this.isConfigValid(bitmap2, config) && this.isSizeValid(allowInexactSize, size, bitmap, scale)) {
                return bitmap;
            }
        }
        int n = -Extensions.getWidth(drawable);
        int n2 = 0;
        boolean bl = false;
        int it22 = n;
        boolean bl2 = false;
        int srcWidth = it22 > 0 ? it22 : 512;
        n2 = -Extensions.getHeight(drawable);
        bl = false;
        it22 = 0;
        int it = n2;
        boolean bl3 = false;
        int srcHeight = it > 0 ? it : 512;
        PixelSize it22 = DecodeUtils.computePixelSize(srcWidth, srcHeight, size, scale);
        n2 = it22.component1();
        int height = it22.component2();
        Bitmap bitmap = this.bitmapPool.get((int)width, height, -Bitmaps.toSoftware(config));
        Drawable drawable2 = drawable;
        boolean bl4 = false;
        boolean bl5 = false;
        Drawable $this$apply = drawable2;
        boolean bl6 = false;
        Rect $this$component1$iv = rect = drawable.getBounds();
        boolean $i$f$component1 = false;
        int n3 = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int n4 = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int n5 = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$apply.setBounds(0, 0, (int)width, height);
        $this$apply.draw(new Canvas(bitmap));
        $this$apply.setBounds((int)oldLeft, (int)oldTop, (int)oldRight, oldBottom);
        return bitmap;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == -Bitmaps.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Size size, Bitmap bitmap, Scale scale) {
        return allowInexactSize || size instanceof OriginalSize || Intrinsics.areEqual((Object)size, (Object)DecodeUtils.computePixelSize(bitmap.getWidth(), bitmap.getHeight(), size, scale));
    }

    public DrawableDecoderService(@NotNull BitmapPool bitmapPool) {
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        this.bitmapPool = bitmapPool;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/DrawableDecoderService$Companion;", "", "()V", "DEFAULT_SIZE", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

