/*
 * Decompiled with CFR 0.152.
 */
package coil.map;

import android.net.Uri;
import coil.map.Mapper;
import coil.request.Options;
import coil.util.-Utils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcoil/map/FileUriMapper;", "Lcoil/map/Mapper;", "Landroid/net/Uri;", "Ljava/io/File;", "()V", "isApplicable", "", "data", "map", "options", "Lcoil/request/Options;", "coil-base_release"})
public final class FileUriMapper
implements Mapper<Uri, File> {
    @Override
    @Nullable
    public File map(@NotNull Uri data, @NotNull Options options) {
        if (!this.isApplicable(data)) {
            return null;
        }
        String string = data.getPath();
        Intrinsics.checkNotNull((Object)string);
        return new File(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(Uri data) {
        if (-Utils.isAssetUri(data)) return false;
        String it = data.getScheme();
        boolean bl = false;
        if (it != null) {
            if (!Intrinsics.areEqual((Object)it, (Object)"file")) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        String string = data.getPath();
        if (string == null) {
            string = "";
        }
        if (!StringsKt.startsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null)) return false;
        if (-Utils.getFirstPathSegment(data) == null) return false;
        return true;
    }
}

