/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import androidx.collection.LruCache;
import coil.memory.MemoryCache;
import coil.memory.RealStrongMemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.util.-Bitmaps;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004*\u0001\b\b\u0000\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\fH\u0016J,\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0003H\u0016R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\"\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcoil/memory/RealStrongMemoryCache;", "Lcoil/memory/StrongMemoryCache;", "maxSize", "", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "(ILcoil/memory/WeakMemoryCache;)V", "cache", "coil/memory/RealStrongMemoryCache$cache$1", "Lcoil/memory/RealStrongMemoryCache$cache$1;", "keys", "", "Lcoil/memory/MemoryCache$Key;", "kotlin.jvm.PlatformType", "getKeys", "()Ljava/util/Set;", "getMaxSize", "()I", "size", "getSize", "clearMemory", "", "get", "Lcoil/memory/MemoryCache$Value;", "key", "remove", "", "set", "bitmap", "Landroid/graphics/Bitmap;", "extras", "", "", "", "trimMemory", "level", "InternalValue", "coil-base_release"})
public final class RealStrongMemoryCache
implements StrongMemoryCache {
    @NotNull
    private final WeakMemoryCache weakMemoryCache;
    @NotNull
    private final cache.1 cache;

    public RealStrongMemoryCache(int maxSize, @NotNull WeakMemoryCache weakMemoryCache) {
        this.weakMemoryCache = weakMemoryCache;
        this.cache = new LruCache<MemoryCache.Key, InternalValue>(maxSize, this){
            final /* synthetic */ RealStrongMemoryCache this$0;
            {
                this.this$0 = $receiver;
                super($maxSize);
            }

            protected int sizeOf(@NotNull MemoryCache.Key key, @NotNull InternalValue value) {
                return value.getSize();
            }

            protected void entryRemoved(boolean evicted, @NotNull MemoryCache.Key key, @NotNull InternalValue oldValue, @Nullable InternalValue newValue) {
                RealStrongMemoryCache.access$getWeakMemoryCache$p(this.this$0).set(key, oldValue.getBitmap(), oldValue.getExtras(), oldValue.getSize());
            }
        };
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public int getMaxSize() {
        return this.cache.maxSize();
    }

    @Override
    @NotNull
    public Set<MemoryCache.Key> getKeys() {
        return this.cache.snapshot().keySet();
    }

    @Override
    @Nullable
    public MemoryCache.Value get(@NotNull MemoryCache.Key key) {
        MemoryCache.Value value;
        InternalValue internalValue = (InternalValue)this.cache.get(key);
        if (internalValue != null) {
            InternalValue it = internalValue;
            boolean bl = false;
            value = new MemoryCache.Value(it.getBitmap(), it.getExtras());
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras) {
        int size2 = -Bitmaps.getAllocationByteCountCompat(bitmap);
        if (size2 <= this.getMaxSize()) {
            this.cache.put(key, new InternalValue(bitmap, extras, size2));
        } else {
            this.cache.remove(key);
            this.weakMemoryCache.set(key, bitmap, extras, size2);
        }
    }

    @Override
    public boolean remove(@NotNull MemoryCache.Key key) {
        return this.cache.remove(key) != null;
    }

    @Override
    public void clearMemory() {
        this.cache.evictAll();
    }

    @Override
    public void trimMemory(int level) {
        if (level >= 40) {
            this.clearMemory();
        } else {
            boolean bl = 10 <= level ? level < 20 : false;
            if (bl) {
                this.cache.trimToSize(this.getSize() / 2);
            }
        }
    }

    public static final /* synthetic */ WeakMemoryCache access$getWeakMemoryCache$p(RealStrongMemoryCache $this) {
        return $this.weakMemoryCache;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcoil/memory/RealStrongMemoryCache$InternalValue;", "", "bitmap", "Landroid/graphics/Bitmap;", "extras", "", "", "size", "", "(Landroid/graphics/Bitmap;Ljava/util/Map;I)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getExtras", "()Ljava/util/Map;", "getSize", "()I", "coil-base_release"})
    private static final class InternalValue {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Map<String, Object> extras;
        private final int size;

        public InternalValue(@NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras, int size2) {
            this.bitmap = bitmap;
            this.extras = extras;
            this.size = size2;
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

