/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.-Bitmaps;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcoil/transform/CircleCropTransformation;", "Lcoil/transform/Transformation;", "()V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "transform", "Landroid/graphics/Bitmap;", "input", "size", "Lcoil/size/Size;", "(Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coil-base_release"})
public final class CircleCropTransformation
implements Transformation {
    @NotNull
    private final String cacheKey = this.getClass().getName();

    @Override
    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        int minSize = Math.min(input.getWidth(), input.getHeight());
        float radius = (float)minSize / 2.0f;
        Bitmap.Config config$iv = -Bitmaps.getSafeConfig(input);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)minSize, (int)minSize, (Bitmap.Config)config$iv);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
        Bitmap $this$applyCanvas$iv = output = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$transform_u24lambda_u2d0 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$transform_u24lambda_u2d0.drawCircle(radius, radius, radius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        $this$transform_u24lambda_u2d0.drawBitmap(input, radius - (float)input.getWidth() / 2.0f, radius - (float)input.getHeight() / 2.0f, paint);
        return output;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CircleCropTransformation;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

