/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil.decode.DecodeUtils;
import coil.size.-Sizes;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-Bitmaps;
import coil.util.-Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/util/DrawableUtils;", "", "()V", "DEFAULT_SIZE", "", "convertToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "config", "Landroid/graphics/Bitmap$Config;", "size", "Lcoil/size/Size;", "scale", "Lcoil/size/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "coil-base_release"})
public final class DrawableUtils {
    @NotNull
    public static final DrawableUtils INSTANCE = new DrawableUtils();
    private static final int DEFAULT_SIZE = 512;

    private DrawableUtils() {
    }

    @WorkerThread
    @NotNull
    public final Bitmap convertToBitmap(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Size size2, @NotNull Scale scale, boolean allowInexactSize) {
        Rect rect;
        Drawable drawable2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable && this.isConfigValid(bitmap = ((BitmapDrawable)drawable).getBitmap(), config) && this.isSizeValid(allowInexactSize, bitmap, size2, scale)) {
            return bitmap;
        }
        Drawable safeDrawable = drawable.mutate();
        int it = -Utils.getWidth(safeDrawable);
        boolean bl = false;
        int srcWidth = it > 0 ? it : 512;
        int it2 = -Utils.getHeight(safeDrawable);
        boolean bl2 = false;
        int srcHeight = it2 > 0 ? it2 : 512;
        int n6 = srcWidth;
        int n7 = srcHeight;
        Size $this$widthPx$iv = size2;
        boolean $i$f$widthPx = false;
        if (-Sizes.isOriginal($this$widthPx$iv)) {
            n5 = n7;
            n4 = n6;
            boolean bl3 = false;
            n3 = srcWidth;
            n6 = n4;
            n7 = n5;
            n2 = n3;
        } else {
            n2 = -Utils.toPx($this$widthPx$iv.getWidth(), scale);
        }
        Size $this$heightPx$iv = size2;
        boolean $i$f$heightPx = false;
        if (-Sizes.isOriginal($this$heightPx$iv)) {
            n3 = n2;
            n5 = n7;
            n4 = n6;
            boolean bl4 = false;
            int n8 = srcHeight;
            n6 = n4;
            n7 = n5;
            n2 = n3;
            n = n8;
        } else {
            n = -Utils.toPx($this$heightPx$iv.getHeight(), scale);
        }
        double multiplier = DecodeUtils.computeSizeMultiplier(n6, n7, n2, n, scale);
        int bitmapWidth = MathKt.roundToInt((double)(multiplier * (double)srcWidth));
        int bitmapHeight = MathKt.roundToInt((double)(multiplier * (double)srcHeight));
        Bitmap.Config config$iv = -Bitmaps.toSoftware(config);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
        Bitmap bitmap3 = bitmap2;
        Drawable $this$convertToBitmap_u24lambda_u2d4 = drawable2 = safeDrawable;
        boolean bl5 = false;
        Rect $this$component1$iv = rect = $this$convertToBitmap_u24lambda_u2d4.getBounds();
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$convertToBitmap_u24lambda_u2d4.setBounds(0, 0, bitmapWidth, bitmapHeight);
        $this$convertToBitmap_u24lambda_u2d4.draw(new Canvas(bitmap3));
        $this$convertToBitmap_u24lambda_u2d4.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap3;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == -Bitmaps.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Bitmap bitmap, Size size2, Scale scale) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (allowInexactSize) {
            return true;
        }
        int n6 = bitmap.getWidth();
        int n7 = bitmap.getHeight();
        Size $this$widthPx$iv = size2;
        boolean $i$f$widthPx = false;
        if (-Sizes.isOriginal($this$widthPx$iv)) {
            n5 = n7;
            n4 = n6;
            boolean bl = false;
            n3 = bitmap.getWidth();
            n6 = n4;
            n7 = n5;
            n2 = n3;
        } else {
            n2 = -Utils.toPx($this$widthPx$iv.getWidth(), scale);
        }
        Size $this$heightPx$iv = size2;
        boolean $i$f$heightPx = false;
        if (-Sizes.isOriginal($this$heightPx$iv)) {
            n3 = n2;
            n5 = n7;
            n4 = n6;
            boolean bl = false;
            int n8 = bitmap.getHeight();
            n6 = n4;
            n7 = n5;
            n2 = n3;
            n = n8;
        } else {
            n = -Utils.toPx($this$heightPx$iv.getHeight(), scale);
        }
        return DecodeUtils.computeSizeMultiplier(n6, n7, n2, n, scale) == 1.0;
    }
}

