/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import coil.decode.DecodeUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0010\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0012\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"GIF_HEADER_87A", "Lokio/ByteString;", "GIF_HEADER_89A", "HEIF_HEADER_FTYP", "HEIF_HEADER_HEVC", "HEIF_HEADER_HEVX", "HEIF_HEADER_MSF1", "WEBP_HEADER_RIFF", "WEBP_HEADER_VPX8", "WEBP_HEADER_WEBP", "isAnimatedHeif", "", "Lcoil/decode/DecodeUtils;", "source", "Lokio/BufferedSource;", "isAnimatedWebP", "isGif", "isHeif", "isWebP", "coil-gif_release"})
@JvmName(name="GifDecodeUtils")
public final class GifDecodeUtils {
    @NotNull
    private static final ByteString GIF_HEADER_87A = ByteString.Companion.encodeUtf8("GIF87a");
    @NotNull
    private static final ByteString GIF_HEADER_89A = ByteString.Companion.encodeUtf8("GIF89a");
    @NotNull
    private static final ByteString WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
    @NotNull
    private static final ByteString WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
    @NotNull
    private static final ByteString WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    @NotNull
    private static final ByteString HEIF_HEADER_FTYP = ByteString.Companion.encodeUtf8("ftyp");
    @NotNull
    private static final ByteString HEIF_HEADER_MSF1 = ByteString.Companion.encodeUtf8("msf1");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVC = ByteString.Companion.encodeUtf8("hevc");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVX = ByteString.Companion.encodeUtf8("hevx");

    public static final boolean isGif(@NotNull DecodeUtils $this$isGif, @NotNull BufferedSource source) {
        return source.rangeEquals(0L, GIF_HEADER_89A) || source.rangeEquals(0L, GIF_HEADER_87A);
    }

    public static final boolean isWebP(@NotNull DecodeUtils $this$isWebP, @NotNull BufferedSource source) {
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && source.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    public static final boolean isAnimatedWebP(@NotNull DecodeUtils $this$isAnimatedWebP, @NotNull BufferedSource source) {
        return GifDecodeUtils.isWebP($this$isAnimatedWebP, source) && source.rangeEquals(12L, WEBP_HEADER_VPX8) && source.request(17L) && (byte)(source.getBuffer().getByte(16L) & 2) > 0;
    }

    public static final boolean isHeif(@NotNull DecodeUtils $this$isHeif, @NotNull BufferedSource source) {
        return source.rangeEquals(4L, HEIF_HEADER_FTYP);
    }

    public static final boolean isAnimatedHeif(@NotNull DecodeUtils $this$isAnimatedHeif, @NotNull BufferedSource source) {
        return GifDecodeUtils.isHeif($this$isAnimatedHeif, source) && (source.rangeEquals(8L, HEIF_HEADER_MSF1) || source.rangeEquals(8L, HEIF_HEADER_HEVC) || source.rangeEquals(8L, HEIF_HEADER_HEVX));
    }
}

