/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import coil.ImageLoader;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.FrameDelayRewritingSource;
import coil.decode.GifDecodeUtils;
import coil.decode.ImageSource;
import coil.drawable.MovieDrawable;
import coil.fetch.SourceResult;
import coil.request.Gifs;
import coil.request.Options;
import coil.util.-GifUtils;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.InterruptibleKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcoil/decode/GifDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "enforceMinimumFrameDelay", "", "<init>", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Z)V", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "Companion", "coil-gif_release"})
@SourceDebugExtension(value={"SMAP\nGifDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GifDecoder.kt\ncoil/decode/GifDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class GifDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    private final boolean enforceMinimumFrameDelay;
    @NotNull
    public static final String REPEAT_COUNT_KEY = "coil#repeat_count";
    @NotNull
    public static final String ANIMATED_TRANSFORMATION_KEY = "coil#animated_transformation";
    @NotNull
    public static final String ANIMATION_START_CALLBACK_KEY = "coil#animation_start_callback";
    @NotNull
    public static final String ANIMATION_END_CALLBACK_KEY = "coil#animation_end_callback";

    @JvmOverloads
    public GifDecoder(@NotNull ImageSource source, @NotNull Options options, boolean enforceMinimumFrameDelay) {
        this.source = source;
        this.options = options;
        this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
    }

    public /* synthetic */ GifDecoder(ImageSource imageSource, Options options, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(imageSource, options, bl);
    }

    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        return InterruptibleKt.runInterruptible$default(null, () -> GifDecoder.decode$lambda$2(this), $completion, (int)1, null);
    }

    @JvmOverloads
    public GifDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DecodeResult decode$lambda$2(GifDecoder this$0) {
        BufferedSource bufferedSource = this$0.enforceMinimumFrameDelay ? Okio.buffer((Source)((Source)new FrameDelayRewritingSource((Source)this$0.source.source()))) : this$0.source.source();
        Closeable closeable = (Closeable)bufferedSource;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            it = Movie.decodeStream((InputStream)it.inputStream());
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BufferedSource movie = it;
        if (!(movie != null && movie.width() > 0 && movie.height() > 0)) {
            boolean $i$a$-check-GifDecoder$decode$2$22 = false;
            String $i$a$-check-GifDecoder$decode$2$22 = "Failed to decode GIF.";
            throw new IllegalStateException($i$a$-check-GifDecoder$decode$2$22.toString());
        }
        MovieDrawable drawable = new MovieDrawable((Movie)movie, movie.isOpaque() && this$0.options.getAllowRgb565() ? Bitmap.Config.RGB_565 : (-GifUtils.isHardware(this$0.options.getConfig()) ? Bitmap.Config.ARGB_8888 : this$0.options.getConfig()), this$0.options.getScale());
        Integer n = Gifs.repeatCount(this$0.options.getParameters());
        drawable.setRepeatCount(n != null ? n : -1);
        Function0<Unit> onStart = Gifs.animationStartCallback(this$0.options.getParameters());
        Function0<Unit> onEnd = Gifs.animationEndCallback(this$0.options.getParameters());
        if (onStart != null || onEnd != null) {
            drawable.registerAnimationCallback(-GifUtils.animatable2CompatCallbackOf(onStart, onEnd));
        }
        drawable.setAnimatedTransformation(Gifs.animatedTransformation(this$0.options.getParameters()));
        return new DecodeResult((Drawable)drawable, false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/decode/GifDecoder$Companion;", "", "<init>", "()V", "REPEAT_COUNT_KEY", "", "ANIMATED_TRANSFORMATION_KEY", "ANIMATION_START_CALLBACK_KEY", "ANIMATION_END_CALLBACK_KEY", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/decode/GifDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "enforceMinimumFrameDelay", "", "<init>", "(Z)V", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "equals", "other", "", "hashCode", "", "coil-gif_release"})
    public static final class Factory
    implements Decoder.Factory {
        private final boolean enforceMinimumFrameDelay;

        @JvmOverloads
        public Factory(boolean enforceMinimumFrameDelay) {
            this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        @Nullable
        public Decoder create(@NotNull SourceResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!GifDecodeUtils.isGif(DecodeUtils.INSTANCE, result.getSource().source())) {
                return null;
            }
            return new GifDecoder(result.getSource(), options, this.enforceMinimumFrameDelay);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Factory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

