/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.ImageDecoder;
import android.graphics.PostProcessor;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import coil.ImageLoader;
import coil.decode.AssetMetadata;
import coil.decode.ContentMetadata;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.FrameDelayRewritingSource;
import coil.decode.GifDecodeUtils;
import coil.decode.ImageDecoderDecoder;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.decode.ResourceMetadata;
import coil.drawable.ScaleDrawable;
import coil.fetch.SourceResult;
import coil.request.Gifs;
import coil.request.Options;
import coil.size.-Sizes;
import coil.size.Scale;
import coil.size.Size;
import coil.transform.AnimatedTransformation;
import coil.util.-GifUtils;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0003H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil/decode/ImageDecoderDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "enforceMinimumFrameDelay", "", "<init>", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Z)V", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wrapImageSource", "toImageDecoderSource", "Landroid/graphics/ImageDecoder$Source;", "configureImageDecoderProperties", "", "Landroid/graphics/ImageDecoder;", "wrapDrawable", "Landroid/graphics/drawable/Drawable;", "baseDrawable", "(Landroid/graphics/drawable/Drawable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "coil-gif_release"})
@RequiresApi(value=28)
@SourceDebugExtension(value={"SMAP\nImageDecoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDecoderDecoder.kt\ncoil/decode/ImageDecoderDecoder\n+ 2 ImageDecoder.kt\nandroidx/core/graphics/ImageDecoderKt\n*L\n1#1,187:1\n52#2:188\n*S KotlinDebug\n*F\n+ 1 ImageDecoderDecoder.kt\ncoil/decode/ImageDecoderDecoder\n*L\n54#1:188\n*E\n"})
public final class ImageDecoderDecoder
implements Decoder {
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    private final boolean enforceMinimumFrameDelay;

    @JvmOverloads
    public ImageDecoderDecoder(@NotNull ImageSource source, @NotNull Options options, boolean enforceMinimumFrameDelay) {
        this.source = source;
        this.options = options;
        this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
    }

    public /* synthetic */ ImageDecoderDecoder(ImageSource imageSource, Options options, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(imageSource, options, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        if (!($completion instanceof decode.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ImageDecoderDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.decode((Continuation<? super DecodeResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                isSampled = new Ref.BooleanRef();
                $continuation.L$0 = this;
                $continuation.L$1 = isSampled;
                $continuation.label = 1;
                v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, decode$lambda$3(coil.decode.ImageDecoderDecoder kotlin.jvm.internal.Ref$BooleanRef ), ()Landroid/graphics/drawable/Drawable;)((ImageDecoderDecoder)this, (Ref.BooleanRef)isSampled), (Continuation)$continuation, (int)1, null);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                isSampled = (Ref.BooleanRef)$continuation.L$1;
                this = (ImageDecoderDecoder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                drawable = (Drawable)v0;
                $continuation.L$0 = isSampled;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = this.wrapDrawable(drawable, (Continuation<? super Drawable>)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl37
            }
            case 2: {
                isSampled = (Ref.BooleanRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                var6_7 = isSampled.element;
                var7_8 = (Drawable)v1;
                return new DecodeResult(var7_8, var6_7 != false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final ImageSource wrapImageSource(ImageSource source) {
        ImageSource imageSource;
        if (this.enforceMinimumFrameDelay && GifDecodeUtils.isGif(DecodeUtils.INSTANCE, source.source())) {
            FrameDelayRewritingSource rewritingSource = new FrameDelayRewritingSource((Source)source.source());
            imageSource = ImageSources.create((BufferedSource)Okio.buffer((Source)((Source)rewritingSource)), (Context)this.options.getContext());
        } else {
            imageSource = source;
        }
        return imageSource;
    }

    private final ImageDecoder.Source toImageDecoderSource(ImageSource $this$toImageDecoderSource) {
        Path file = $this$toImageDecoderSource.fileOrNull();
        if (file != null) {
            return ImageDecoder.createSource((File)file.toFile());
        }
        ImageSource.Metadata metadata = $this$toImageDecoderSource.getMetadata();
        if (metadata instanceof AssetMetadata) {
            return ImageDecoder.createSource((AssetManager)this.options.getContext().getAssets(), (String)((AssetMetadata)metadata).getFilePath());
        }
        if (metadata instanceof ContentMetadata) {
            return ImageDecoder.createSource((ContentResolver)this.options.getContext().getContentResolver(), (Uri)((ContentMetadata)metadata).getUri());
        }
        if (metadata instanceof ResourceMetadata && Intrinsics.areEqual((Object)((ResourceMetadata)metadata).getPackageName(), (Object)this.options.getContext().getPackageName())) {
            return ImageDecoder.createSource((Resources)this.options.getContext().getResources(), (int)((ResourceMetadata)metadata).getResId());
        }
        return Build.VERSION.SDK_INT >= 31 ? ImageDecoder.createSource((byte[])$this$toImageDecoderSource.source().readByteArray()) : (Build.VERSION.SDK_INT == 30 ? ImageDecoder.createSource((ByteBuffer)ByteBuffer.wrap($this$toImageDecoderSource.source().readByteArray())) : ImageDecoder.createSource((File)$this$toImageDecoderSource.file().toFile()));
    }

    private final void configureImageDecoderProperties(ImageDecoder $this$configureImageDecoderProperties) {
        $this$configureImageDecoderProperties.setAllocator(-GifUtils.isHardware(this.options.getConfig()) ? 3 : 1);
        $this$configureImageDecoderProperties.setMemorySizePolicy(this.options.getAllowRgb565() ? 0 : 1);
        if (this.options.getColorSpace() != null) {
            $this$configureImageDecoderProperties.setTargetColorSpace(this.options.getColorSpace());
        }
        $this$configureImageDecoderProperties.setUnpremultipliedRequired(!this.options.getPremultipliedAlpha());
        AnimatedTransformation animatedTransformation = Gifs.animatedTransformation(this.options.getParameters());
        $this$configureImageDecoderProperties.setPostProcessor((PostProcessor)(animatedTransformation != null ? -GifUtils.asPostProcessor(animatedTransformation) : null));
    }

    /*
     * Unable to fully structure code
     */
    private final Object wrapDrawable(Drawable var1_1, Continuation<? super Drawable> $completion) {
        if (!($completion instanceof wrapDrawable.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ImageDecoderDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ImageDecoderDecoder.access$wrapDrawable(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(baseDrawable instanceof AnimatedImageDrawable)) {
                    return baseDrawable;
                }
                v0 = Gifs.repeatCount(this.options.getParameters());
                ((AnimatedImageDrawable)baseDrawable).setRepeatCount(v0 != null ? v0 : -1);
                onStart = Gifs.animationStartCallback(this.options.getParameters());
                onEnd = Gifs.animationEndCallback(this.options.getParameters());
                if (onStart != null || onEnd != null) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = baseDrawable;
                    $continuation.label = 1;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain().getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(baseDrawable, onStart, onEnd, null){
                        int label;
                        final /* synthetic */ Drawable $baseDrawable;
                        final /* synthetic */ Function0<Unit> $onStart;
                        final /* synthetic */ Function0<Unit> $onEnd;
                        {
                            this.$baseDrawable = $baseDrawable;
                            this.$onStart = $onStart;
                            this.$onEnd = $onEnd;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ((AnimatedImageDrawable)this.$baseDrawable).registerAnimationCallback(-GifUtils.animatable2CallbackOf(this.$onStart, this.$onEnd));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                }
                ** GOTO lbl31
            }
            case 1: {
                baseDrawable = (Drawable)$continuation.L$1;
                this = (ImageDecoderDecoder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                return new ScaleDrawable(baseDrawable, this.options.getScale());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmOverloads
    public ImageDecoderDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Drawable decode$lambda$3(ImageDecoderDecoder this$0, Ref.BooleanRef $isSampled) {
        Drawable drawable;
        Ref.ObjectRef imageDecoder = new Ref.ObjectRef();
        ImageSource wrappedSource = this$0.wrapImageSource(this$0.source);
        try {
            ImageDecoder.Source $this$decodeDrawable$iv = this$0.toImageDecoderSource(wrappedSource);
            boolean $i$f$decodeDrawable = false;
            drawable = ImageDecoder.decodeDrawable((ImageDecoder.Source)$this$decodeDrawable$iv, (ImageDecoder.OnHeaderDecodedListener)new ImageDecoder.OnHeaderDecodedListener(imageDecoder, this$0, $isSampled){
                final /* synthetic */ Ref.ObjectRef $imageDecoder$inlined;
                final /* synthetic */ ImageDecoderDecoder this$0;
                final /* synthetic */ Ref.BooleanRef $isSampled$inlined;
                {
                    this.$imageDecoder$inlined = objectRef;
                    this.this$0 = imageDecoderDecoder;
                    this.$isSampled$inlined = booleanRef;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void onHeaderDecoded(@NotNull ImageDecoder decoder, @NotNull ImageDecoder.ImageInfo info, @NotNull ImageDecoder.Source source) {
                    int dstHeight;
                    int n;
                    void $this$heightPx$iv;
                    int n2;
                    void $this$widthPx$iv;
                    void info2;
                    android.util.Size size;
                    ImageDecoder.ImageInfo imageInfo = info;
                    ImageDecoder $this$decode_u24lambda_u243_u24lambda_u242 = decoder;
                    boolean bl = false;
                    this.$imageDecoder$inlined.element = $this$decode_u24lambda_u243_u24lambda_u242;
                    android.util.Size $this$component1$iv = size = info2.getSize();
                    boolean $i$f$component1 = false;
                    int srcWidth = $this$component1$iv.getWidth();
                    android.util.Size $this$component2$iv = size;
                    boolean $i$f$component32 = false;
                    int srcHeight = $this$component2$iv.getHeight();
                    Size $i$f$component32 = ImageDecoderDecoder.access$getOptions$p(this.this$0).getSize();
                    Scale scale$iv = ImageDecoderDecoder.access$getOptions$p(this.this$0).getScale();
                    boolean $i$f$widthPx = false;
                    if (-Sizes.isOriginal((Size)$this$widthPx$iv)) {
                        boolean bl2 = false;
                        n2 = srcWidth;
                    } else {
                        n2 = -GifUtils.toPx($this$widthPx$iv.getWidth(), scale$iv);
                    }
                    int dstWidth = n2;
                    scale$iv = ImageDecoderDecoder.access$getOptions$p(this.this$0).getSize();
                    Scale scale$iv2 = ImageDecoderDecoder.access$getOptions$p(this.this$0).getScale();
                    boolean $i$f$heightPx = false;
                    if (-Sizes.isOriginal((Size)$this$heightPx$iv)) {
                        boolean bl3 = false;
                        n = srcHeight;
                    } else {
                        n = dstHeight = -GifUtils.toPx($this$heightPx$iv.getHeight(), scale$iv2);
                    }
                    if (srcWidth > 0 && srcHeight > 0 && (srcWidth != dstWidth || srcHeight != dstHeight)) {
                        double multiplier = DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)dstWidth, (int)dstHeight, (Scale)ImageDecoderDecoder.access$getOptions$p(this.this$0).getScale());
                        boolean bl4 = this.$isSampled$inlined.element = multiplier < 1.0;
                        if (this.$isSampled$inlined.element || !ImageDecoderDecoder.access$getOptions$p(this.this$0).getAllowInexactSize()) {
                            int targetWidth = MathKt.roundToInt((double)(multiplier * (double)srcWidth));
                            int targetHeight = MathKt.roundToInt((double)(multiplier * (double)srcHeight));
                            $this$decode_u24lambda_u243_u24lambda_u242.setTargetSize(targetWidth, targetHeight);
                        }
                    }
                    ImageDecoderDecoder.access$configureImageDecoderProperties(this.this$0, $this$decode_u24lambda_u243_u24lambda_u242);
                }
            });
        }
        finally {
            ImageDecoder imageDecoder2 = (ImageDecoder)imageDecoder.element;
            if (imageDecoder2 != null) {
                imageDecoder2.close();
            }
            wrappedSource.close();
        }
        return drawable;
    }

    public static final /* synthetic */ Object access$wrapDrawable(ImageDecoderDecoder $this, Drawable baseDrawable, Continuation $completion) {
        return $this.wrapDrawable(baseDrawable, (Continuation<? super Drawable>)$completion);
    }

    public static final /* synthetic */ Options access$getOptions$p(ImageDecoderDecoder $this) {
        return $this.options;
    }

    public static final /* synthetic */ void access$configureImageDecoderProperties(ImageDecoderDecoder $this, ImageDecoder $receiver) {
        $this.configureImageDecoderProperties($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcoil/decode/ImageDecoderDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "enforceMinimumFrameDelay", "", "<init>", "(Z)V", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "source", "Lokio/BufferedSource;", "equals", "other", "", "hashCode", "", "coil-gif_release"})
    public static final class Factory
    implements Decoder.Factory {
        private final boolean enforceMinimumFrameDelay;

        @JvmOverloads
        public Factory(boolean enforceMinimumFrameDelay) {
            this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        @Nullable
        public Decoder create(@NotNull SourceResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(result.getSource().source())) {
                return null;
            }
            return new ImageDecoderDecoder(result.getSource(), options, this.enforceMinimumFrameDelay);
        }

        private final boolean isApplicable(BufferedSource source) {
            return GifDecodeUtils.isGif(DecodeUtils.INSTANCE, source) || GifDecodeUtils.isAnimatedWebP(DecodeUtils.INSTANCE, source) || Build.VERSION.SDK_INT >= 30 && GifDecodeUtils.isAnimatedHeif(DecodeUtils.INSTANCE, source);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Factory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

