/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.InterruptibleSource;
import coil.decode.Options;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import com.caverock.androidsvg.SVG;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcoil/decode/SvgDecoder;", "Lcoil/decode/Decoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "decode", "Lcoil/decode/DecodeResult;", "pool", "Lcoil/bitmap/BitmapPool;", "source", "Lokio/BufferedSource;", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Lokio/BufferedSource;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "mimeType", "", "Companion", "coil-svg_release"})
public final class SvgDecoder
implements Decoder {
    private final Context context;
    private static final String MIME_TYPE_SVG = "image/svg+xml";
    private static final int DEFAULT_SIZE = 512;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public boolean handles(@NotNull BufferedSource source, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_SVG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Object decode(@NotNull BitmapPool pool, @NotNull BufferedSource source, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super DecodeResult> $completion) {
        boolean $i$f$withInterruptibleSource = false;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DecodeResult> uCont$iv$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv$iv), 1);
        cancellable$iv$iv.initCancellability();
        CancellableContinuation continuation$iv = (CancellableContinuation)cancellable$iv$iv;
        boolean bl2 = false;
        try {
            InterruptibleSource interruptibleSource$iv = new InterruptibleSource(continuation$iv, (Source)source);
            try {
                void $this$toDrawable$iv;
                BufferedSource svg;
                Continuation continuation = (Continuation)continuation$iv;
                Source interruptibleSource = (Source)interruptibleSource$iv;
                boolean bl3 = false;
                Closeable closeable = (Closeable)Okio.buffer((Source)interruptibleSource);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    BufferedSource it = (BufferedSource)closeable;
                    boolean bl6 = false;
                    it = SVG.getFromInputStream((InputStream)it.inputStream());
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                BufferedSource bufferedSource = svg = it;
                Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"svg");
                float svgWidth = bufferedSource.getDocumentWidth();
                float svgHeight = svg.getDocumentHeight();
                int bitmapWidth = 0;
                int bitmapHeight = 0;
                Size bl6 = size;
                if (bl6 instanceof PixelSize) {
                    if (svgWidth > 0.0f && svgHeight > 0.0f) {
                        float multiplier = DecodeUtils.computeSizeMultiplier((float)svgWidth, (float)svgHeight, (float)((PixelSize)size).getWidth(), (float)((PixelSize)size).getHeight(), (Scale)options.getScale());
                        bitmapWidth = (int)(multiplier * svgWidth);
                        bitmapHeight = (int)(multiplier * svgHeight);
                    } else {
                        bitmapWidth = ((PixelSize)size).getWidth();
                        bitmapHeight = ((PixelSize)size).getHeight();
                    }
                } else if (bl6 instanceof OriginalSize) {
                    if (svgWidth > 0.0f && svgHeight > 0.0f) {
                        bitmapWidth = (int)svgWidth;
                        bitmapHeight = (int)svgHeight;
                    } else {
                        SvgDecoder.Companion;
                        bitmapWidth = 512;
                        SvgDecoder.Companion;
                        bitmapHeight = 512;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (svg.getDocumentViewBox() == null && svgWidth > 0.0f && svgHeight > 0.0f) {
                    svg.setDocumentViewBox(0.0f, 0.0f, svgWidth, svgHeight);
                }
                svg.setDocumentWidth("100%");
                svg.setDocumentHeight("100%");
                Bitmap.Config config = Build.VERSION.SDK_INT >= 26 && options.getConfig() == Bitmap.Config.HARDWARE ? Bitmap.Config.ARGB_8888 : options.getConfig();
                Bitmap bitmap = pool.get(bitmapWidth, bitmapHeight, config);
                svg.renderToCanvas(new Canvas(bitmap));
                Bitmap bitmap2 = bitmap;
                Resources resources = this.context.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
                Resources resources$iv = resources;
                boolean $i$f$toDrawable = false;
                DecodeResult decodeResult = new DecodeResult((Drawable)new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv), true);
                boolean bl7 = false;
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                continuation.resumeWith(Result.constructor-impl((Object)decodeResult));
            }
            finally {
                interruptibleSource$iv.clearInterrupt();
            }
        }
        catch (Exception exception$iv) {
            if (exception$iv instanceof InterruptedException || exception$iv instanceof InterruptedIOException) {
                Throwable throwable = new CancellationException("Blocking call was interrupted due to parent cancellation.").initCause(exception$iv);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"CancellationException(\"B\u2026n.\").initCause(exception)");
                throw throwable;
            }
            throw (Throwable)exception$iv;
        }
        Object object = cancellable$iv$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public SvgDecoder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcoil/decode/SvgDecoder$Companion;", "", "()V", "DEFAULT_SIZE", "", "MIME_TYPE_SVG", "", "coil-svg_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

