/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.media.MediaDataSource;
import androidx.annotation.RequiresApi;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcoil/fetch/MediaDataSourceFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/media/MediaDataSource;", "options", "Lcoil/request/Options;", "(Landroid/media/MediaDataSource;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "MediaDataSourceOkioSource", "MediaSourceMetadata", "coil-video_release"})
@RequiresApi(value=23)
public final class MediaDataSourceFetcher
implements Fetcher {
    @NotNull
    private final MediaDataSource data;
    @NotNull
    private final Options options;

    public MediaDataSourceFetcher(@NotNull MediaDataSource data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        ImageSource imageSource = ImageSources.create((BufferedSource)Okio.buffer((Source)new MediaDataSourceOkioSource(this.data)), (Context)this.options.getContext(), (ImageSource.Metadata)new MediaSourceMetadata(this.data));
        return new SourceResult(imageSource, null, DataSource.DISK);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcoil/fetch/MediaDataSourceFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/media/MediaDataSource;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "coil-video_release"})
    public static final class Factory
    implements Fetcher.Factory<MediaDataSource> {
        @NotNull
        public Fetcher create(@NotNull MediaDataSource data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            return new MediaDataSourceFetcher(data, options);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcoil/fetch/MediaDataSourceFetcher$MediaDataSourceOkioSource;", "Lokio/Source;", "mediaDataSource", "Landroid/media/MediaDataSource;", "(Landroid/media/MediaDataSource;)V", "position", "", "size", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "coil-video_release"})
    public static final class MediaDataSourceOkioSource
    implements Source {
        @NotNull
        private final MediaDataSource mediaDataSource;
        private long size;
        private long position;

        public MediaDataSourceOkioSource(@NotNull MediaDataSource mediaDataSource) {
            this.mediaDataSource = mediaDataSource;
            this.size = this.mediaDataSource.getSize();
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            if (this.position >= this.size) {
                return -1L;
            }
            long sizeToRead = Math.min(byteCount, this.size - this.position);
            byte[] byteArray = new byte[(int)sizeToRead];
            int readBytes = this.mediaDataSource.readAt(this.position, byteArray, 0, byteArray.length);
            this.position += (long)readBytes;
            sink.write(byteArray, 0, readBytes);
            return readBytes;
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            this.mediaDataSource.close();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcoil/fetch/MediaDataSourceFetcher$MediaSourceMetadata;", "Lcoil/decode/ImageSource$Metadata;", "mediaDataSource", "Landroid/media/MediaDataSource;", "(Landroid/media/MediaDataSource;)V", "getMediaDataSource", "()Landroid/media/MediaDataSource;", "coil-video_release"})
    @RequiresApi(value=23)
    public static final class MediaSourceMetadata
    extends ImageSource.Metadata {
        @NotNull
        private final MediaDataSource mediaDataSource;

        public MediaSourceMetadata(@NotNull MediaDataSource mediaDataSource) {
            this.mediaDataSource = mediaDataSource;
        }

        @NotNull
        public final MediaDataSource getMediaDataSource() {
            return this.mediaDataSource;
        }
    }
}

