/*
 * Decompiled with CFR 0.152.
 */
package coil.request;

import androidx.annotation.FloatRange;
import coil.request.ImageRequest;
import coil.request.Parameters;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0011\u0010\u0000\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0011\u0010\b\u001a\u0004\u0018\u00010\n*\u00020\u0004\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u000e\u001a\u0011\u0010\f\u001a\u0004\u0018\u00010\u000e*\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"videoFrameMicros", "Lcoil/request/ImageRequest$Builder;", "frameMicros", "", "Lcoil/request/Parameters;", "(Lcoil/request/Parameters;)Ljava/lang/Long;", "videoFrameMillis", "frameMillis", "videoFrameOption", "option", "", "(Lcoil/request/Parameters;)Ljava/lang/Integer;", "videoFramePercent", "framePercent", "", "(Lcoil/request/Parameters;)Ljava/lang/Double;", "coil-video_release"})
@JvmName(name="Videos")
@SourceDebugExtension(value={"SMAP\nVideos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Videos.kt\ncoil/request/Videos\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class Videos {
    @NotNull
    public static final ImageRequest.Builder videoFrameMillis(@NotNull ImageRequest.Builder $this$videoFrameMillis, long frameMillis) {
        return Videos.videoFrameMicros($this$videoFrameMillis, (long)1000 * frameMillis);
    }

    @NotNull
    public static final ImageRequest.Builder videoFrameMicros(@NotNull ImageRequest.Builder $this$videoFrameMicros, long frameMicros) {
        if (!(frameMicros >= 0L)) {
            boolean bl = false;
            String string = "frameMicros must be >= 0.";
            throw new IllegalArgumentException(string.toString());
        }
        return ImageRequest.Builder.setParameter$default((ImageRequest.Builder)$this$videoFrameMicros, (String)"coil#video_frame_micros", (Object)frameMicros, null, (int)4, null);
    }

    @NotNull
    public static final ImageRequest.Builder videoFramePercent(@NotNull ImageRequest.Builder $this$videoFramePercent, @FloatRange(from=0.0, to=1.0) double framePercent) {
        if (!(0.0 <= framePercent ? framePercent <= 1.0 : false)) {
            boolean bl = false;
            String string = "framePercent must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        return ImageRequest.Builder.setParameter$default((ImageRequest.Builder)$this$videoFramePercent, (String)"coil#video_frame_percent", (Object)framePercent, null, (int)4, null);
    }

    @NotNull
    public static final ImageRequest.Builder videoFrameOption(@NotNull ImageRequest.Builder $this$videoFrameOption, int option) {
        if (!(option == 0 || option == 1 || option == 2 || option == 3)) {
            boolean bl = false;
            String string = "Invalid video frame option: " + option + '.';
            throw new IllegalArgumentException(string.toString());
        }
        return ImageRequest.Builder.setParameter$default((ImageRequest.Builder)$this$videoFrameOption, (String)"coil#video_frame_option", (Object)option, null, (int)4, null);
    }

    @Nullable
    public static final Long videoFrameMicros(@NotNull Parameters $this$videoFrameMicros) {
        return (Long)$this$videoFrameMicros.value("coil#video_frame_micros");
    }

    @Nullable
    public static final Double videoFramePercent(@NotNull Parameters $this$videoFramePercent) {
        return (Double)$this$videoFramePercent.value("coil#video_frame_percent");
    }

    @Nullable
    public static final Integer videoFrameOption(@NotNull Parameters $this$videoFrameOption) {
        return (Integer)$this$videoFrameOption.value("coil#video_frame_option");
    }
}

