/*
 * Decompiled with CFR 0.152.
 */
package coil3.request;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import androidx.lifecycle.Lifecycle;
import coil3.BitmapImage;
import coil3.Extras;
import coil3.Image;
import coil3.ImageLoader;
import coil3.memory.MemoryCache;
import coil3.request.BaseRequestDelegate;
import coil3.request.ImageRequest;
import coil3.request.ImageRequests_androidKt;
import coil3.request.LifecycleRequestDelegate;
import coil3.request.Options;
import coil3.request.RequestDelegate;
import coil3.request.RequestService;
import coil3.request.ViewTargetRequestDelegate;
import coil3.size.Precision;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeResolver;
import coil3.size.ViewSizeResolver;
import coil3.size.ViewSizeResolverKt;
import coil3.target.Target;
import coil3.target.ViewTarget;
import coil3.util.BitmapsKt;
import coil3.util.ContextsKt;
import coil3.util.HardwareBitmapService;
import coil3.util.HardwareBitmapsKt;
import coil3.util.Logger;
import coil3.util.SystemCallbacks;
import coil3.util.Utils_androidKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0014*\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u000fH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\u000f2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010$\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcoil3/request/AndroidRequestService;", "Lcoil3/request/RequestService;", "imageLoader", "Lcoil3/ImageLoader;", "systemCallbacks", "Lcoil3/util/SystemCallbacks;", "logger", "Lcoil3/util/Logger;", "<init>", "(Lcoil3/ImageLoader;Lcoil3/util/SystemCallbacks;Lcoil3/util/Logger;)V", "hardwareBitmapService", "Lcoil3/util/HardwareBitmapService;", "requestDelegate", "Lcoil3/request/RequestDelegate;", "request", "Lcoil3/request/ImageRequest;", "job", "Lkotlinx/coroutines/Job;", "findLifecycle", "", "Landroidx/lifecycle/Lifecycle;", "updateRequest", "options", "Lcoil3/request/Options;", "size", "Lcoil3/size/Size;", "resolveSizeResolver", "Lcoil3/size/SizeResolver;", "resolveScale", "Lcoil3/size/Scale;", "resolvePrecision", "Lcoil3/size/Precision;", "sizeResolver", "resolveExtras", "Lcoil3/Extras;", "updateOptions", "isCacheValueValidForHardware", "cacheValue", "Lcoil3/memory/MemoryCache$Value;", "isConfigValidForHardware", "requestedConfig", "Landroid/graphics/Bitmap$Config;", "isBitmapConfigValidMainThread", "isBitmapConfigValidWorkerThread", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nRequestService.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestService.android.kt\ncoil3/request/AndroidRequestService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
public final class AndroidRequestService
implements RequestService {
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final SystemCallbacks systemCallbacks;
    @Nullable
    private final Logger logger;
    @NotNull
    private final HardwareBitmapService hardwareBitmapService;

    public AndroidRequestService(@NotNull ImageLoader imageLoader, @NotNull SystemCallbacks systemCallbacks, @Nullable Logger logger) {
        this.imageLoader = imageLoader;
        this.systemCallbacks = systemCallbacks;
        this.logger = logger;
        this.hardwareBitmapService = HardwareBitmapsKt.HardwareBitmapService(this.logger);
    }

    @Override
    @NotNull
    public RequestDelegate requestDelegate(@NotNull ImageRequest request, @NotNull Job job2, boolean findLifecycle) {
        Lifecycle lifecycle;
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            Lifecycle lifecycle2 = ImageRequests_androidKt.getLifecycle(request);
            if (lifecycle2 == null) {
                lifecycle2 = this.findLifecycle(request);
            }
            Lifecycle lifecycle3 = lifecycle2;
            return new ViewTargetRequestDelegate(this.imageLoader, request, (ViewTarget)target2, lifecycle3, job2);
        }
        Object object = ImageRequests_androidKt.getLifecycle(request);
        if (object == null) {
            object = findLifecycle ? this.findLifecycle(request) : null;
        }
        if ((lifecycle = object) != null) {
            return new LifecycleRequestDelegate(lifecycle, job2);
        }
        return BaseRequestDelegate.box-impl(BaseRequestDelegate.constructor-impl(job2));
    }

    private final Lifecycle findLifecycle(ImageRequest $this$findLifecycle) {
        Target target2 = $this$findLifecycle.getTarget();
        Context context = target2 instanceof ViewTarget ? ((ViewTarget)target2).getView().getContext() : $this$findLifecycle.getContext();
        return ContextsKt.getLifecycle(context);
    }

    @Override
    @NotNull
    public ImageRequest updateRequest(@NotNull ImageRequest request) {
        ImageRequest.Builder builder = ImageRequest.newBuilder$default(request, null, 1, null).defaults(this.imageLoader.getDefaults());
        SizeResolver sizeResolver = request.getDefined().getSizeResolver();
        if (sizeResolver == null) {
            sizeResolver = this.resolveSizeResolver(request);
            builder.size(sizeResolver);
        }
        if (request.getDefined().getScale() == null) {
            builder.scale(this.resolveScale(request));
        }
        if (request.getDefined().getPrecision() == null) {
            builder.precision(this.resolvePrecision(request, sizeResolver));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public Options options(@NotNull ImageRequest request, @NotNull Size size2) {
        return new Options(request.getContext(), size2, request.getScale(), request.getPrecision(), request.getDiskCacheKey(), request.getFileSystem(), request.getMemoryCachePolicy(), request.getDiskCachePolicy(), request.getNetworkCachePolicy(), this.resolveExtras(request, size2));
    }

    private final SizeResolver resolveSizeResolver(ImageRequest $this$resolveSizeResolver) {
        if ($this$resolveSizeResolver.getTarget() instanceof ViewTarget) {
            Object view = ((ViewTarget)$this$resolveSizeResolver.getTarget()).getView();
            if (view instanceof ImageView) {
                ImageView.ScaleType it = ((ImageView)view).getScaleType();
                boolean bl = false;
                boolean bl2 = it == ImageView.ScaleType.CENTER || it == ImageView.ScaleType.MATRIX;
                if (bl2) {
                    return SizeResolver.ORIGINAL;
                }
            }
            return ViewSizeResolverKt.ViewSizeResolver$default(view, false, 2, null);
        }
        return SizeResolver.ORIGINAL;
    }

    private final Scale resolveScale(ImageRequest $this$resolveScale) {
        ImageView imageView;
        Target target2 = $this$resolveScale.getTarget();
        ViewTarget viewTarget = target2 instanceof ViewTarget ? (ViewTarget)target2 : null;
        Object t = viewTarget != null ? viewTarget.getView() : null;
        ImageView imageView2 = imageView = t instanceof ImageView ? (ImageView)t : null;
        if (imageView != null) {
            return Utils_androidKt.getScale(imageView);
        }
        return $this$resolveScale.getScale();
    }

    private final Precision resolvePrecision(ImageRequest $this$resolvePrecision, SizeResolver sizeResolver) {
        if ($this$resolvePrecision.getDefined().getSizeResolver() == null && Intrinsics.areEqual((Object)sizeResolver, (Object)SizeResolver.ORIGINAL)) {
            return Precision.INEXACT;
        }
        if ($this$resolvePrecision.getTarget() instanceof ViewTarget && sizeResolver instanceof ViewSizeResolver && ((ViewTarget)$this$resolvePrecision.getTarget()).getView() instanceof ImageView && ((ViewTarget)$this$resolvePrecision.getTarget()).getView() == ((ViewSizeResolver)sizeResolver).getView()) {
            return Precision.INEXACT;
        }
        return Precision.EXACT;
    }

    private final Extras resolveExtras(ImageRequest $this$resolveExtras, Size size2) {
        Bitmap.Config bitmapConfig = ImageRequests_androidKt.getBitmapConfig($this$resolveExtras);
        boolean allowRgb565 = ImageRequests_androidKt.getAllowRgb565($this$resolveExtras);
        if (!this.isBitmapConfigValidMainThread($this$resolveExtras, size2)) {
            bitmapConfig = Bitmap.Config.ARGB_8888;
        }
        allowRgb565 = allowRgb565 && ImageRequests_androidKt.getTransformations($this$resolveExtras).isEmpty() && bitmapConfig != Bitmap.Config.ALPHA_8;
        Extras.Builder builder = new Extras.Builder(MapsKt.plus($this$resolveExtras.getDefaults().getExtras().asMap(), $this$resolveExtras.getExtras().asMap()));
        if (bitmapConfig != ImageRequests_androidKt.getBitmapConfig($this$resolveExtras)) {
            builder = builder.set(ImageRequests_androidKt.getBitmapConfig(Extras.Key.Companion), bitmapConfig);
        }
        if (allowRgb565 != ImageRequests_androidKt.getAllowRgb565($this$resolveExtras)) {
            builder = builder.set(ImageRequests_androidKt.getAllowRgb565(Extras.Key.Companion), allowRgb565);
        }
        return builder.build();
    }

    @Override
    @NotNull
    public Options updateOptions(@NotNull Options options) {
        Extras extras = options.getExtras();
        boolean changed = false;
        if (!this.isBitmapConfigValidWorkerThread(options)) {
            extras = extras.newBuilder().set(ImageRequests_androidKt.getBitmapConfig(Extras.Key.Companion), Bitmap.Config.ARGB_8888).build();
            changed = true;
        }
        if (changed) {
            return Options.copy$default(options, null, null, null, null, null, null, null, null, null, extras, 511, null);
        }
        return options;
    }

    @Override
    public boolean isCacheValueValidForHardware(@NotNull ImageRequest request, @NotNull MemoryCache.Value cacheValue) {
        Image image = cacheValue.getImage();
        BitmapImage bitmapImage = image instanceof BitmapImage ? (BitmapImage)image : null;
        if (bitmapImage == null) {
            return true;
        }
        BitmapImage image2 = bitmapImage;
        Bitmap.Config requestedConfig = BitmapsKt.getSafeConfig(image2.getBitmap());
        return this.isConfigValidForHardware(request, requestedConfig);
    }

    private final boolean isConfigValidForHardware(ImageRequest request, Bitmap.Config requestedConfig) {
        if (!BitmapsKt.isHardware(requestedConfig)) {
            return true;
        }
        if (!ImageRequests_androidKt.getAllowHardware(request)) {
            return false;
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            Object $this$isConfigValidForHardware_u24lambda_u241 = ((ViewTarget)target2).getView();
            boolean bl = false;
            boolean bl2 = $this$isConfigValidForHardware_u24lambda_u241.isAttachedToWindow() && !$this$isConfigValidForHardware_u24lambda_u241.isHardwareAccelerated();
            if (bl2) {
                return false;
            }
        }
        return true;
    }

    private final boolean isBitmapConfigValidMainThread(ImageRequest request, Size size2) {
        boolean validForTransformations = ImageRequests_androidKt.getTransformations(request).isEmpty() || ArraysKt.contains((Object[])Utils_androidKt.getVALID_TRANSFORMATION_CONFIGS(), (Object)ImageRequests_androidKt.getBitmapConfig(request));
        boolean validForHardware = !BitmapsKt.isHardware(ImageRequests_androidKt.getBitmapConfig(request)) || this.isConfigValidForHardware(request, ImageRequests_androidKt.getBitmapConfig(request)) && this.hardwareBitmapService.allowHardwareMainThread(size2);
        return validForTransformations && validForHardware;
    }

    private final boolean isBitmapConfigValidWorkerThread(Options options) {
        return !BitmapsKt.isHardware(ImageRequests_androidKt.getBitmapConfig(options)) || this.hardwareBitmapService.allowHardwareWorkerThread();
    }
}

