/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil3.decode.DecodeUtils;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.util.BitmapsKt;
import coil3.util.IntPair;
import coil3.util.Utils_androidKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil3/util/DrawableUtils;", "", "<init>", "()V", "DEFAULT_SIZE", "", "convertToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "config", "Landroid/graphics/Bitmap$Config;", "size", "Lcoil3/size/Size;", "scale", "Lcoil3/size/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nDrawableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawableUtils.kt\ncoil3/util/DrawableUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 collections.kt\ncoil3/util/CollectionsKt\n+ 4 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 5 Rect.kt\nandroidx/core/graphics/RectKt\n*L\n1#1,110:1\n1#2:111\n23#3,3:112\n23#3,3:120\n95#4:115\n38#5:116\n49#5:117\n60#5:118\n71#5:119\n*S KotlinDebug\n*F\n+ 1 DrawableUtils.kt\ncoil3/util/DrawableUtils\n*L\n51#1:112,3\n93#1:120,3\n68#1:115\n70#1:116\n70#1:117\n70#1:118\n70#1:119\n*E\n"})
public final class DrawableUtils {
    @NotNull
    public static final DrawableUtils INSTANCE = new DrawableUtils();
    private static final int DEFAULT_SIZE = 512;

    private DrawableUtils() {
    }

    @WorkerThread
    @NotNull
    public final Bitmap convertToBitmap(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Size size2, @NotNull Scale scale, boolean allowInexactSize) {
        Rect rect;
        Drawable drawable2;
        long l;
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable && this.isConfigValid(bitmap = ((BitmapDrawable)drawable).getBitmap(), config) && this.isSizeValid(allowInexactSize, bitmap, size2, scale)) {
            return bitmap;
        }
        Drawable safeDrawable = drawable.mutate();
        int it = Utils_androidKt.getWidth(safeDrawable);
        boolean bl = false;
        int srcWidth = it > 0 ? it : 512;
        int it2 = Utils_androidKt.getHeight(safeDrawable);
        boolean bl2 = false;
        int srcHeight = it2 > 0 ? it2 : 512;
        long $this$component1_u2dwuMLFU8$iv = l = DecodeUtils.computeDstSize-sEdh43o(srcWidth, srcHeight, size2, scale, Size.ORIGINAL);
        boolean bl3 = false;
        int dstWidth = IntPair.getFirst-impl($this$component1_u2dwuMLFU8$iv);
        long $this$component2_u2dwuMLFU8$iv = l;
        boolean bl4 = false;
        int dstHeight = IntPair.getSecond-impl($this$component2_u2dwuMLFU8$iv);
        double multiplier = DecodeUtils.computeSizeMultiplier(srcWidth, srcHeight, dstWidth, dstHeight, scale);
        int bitmapWidth = MathKt.roundToInt((double)(multiplier * (double)srcWidth));
        int bitmapHeight = MathKt.roundToInt((double)(multiplier * (double)srcHeight));
        Bitmap.Config config$iv = BitmapsKt.toSoftware(config);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
        Drawable $this$convertToBitmap_u24lambda_u242 = drawable2 = safeDrawable;
        boolean bl5 = false;
        Rect $this$component1$iv = rect = $this$convertToBitmap_u24lambda_u242.getBounds();
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$convertToBitmap_u24lambda_u242.setBounds(0, 0, bitmapWidth, bitmapHeight);
        $this$convertToBitmap_u24lambda_u242.draw(new Canvas(bitmap2));
        $this$convertToBitmap_u24lambda_u242.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap2;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == BitmapsKt.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Bitmap bitmap, Size size2, Scale scale) {
        long l;
        if (allowInexactSize) {
            return true;
        }
        long $this$component1_u2dwuMLFU8$iv = l = DecodeUtils.computeDstSize-sEdh43o(bitmap.getWidth(), bitmap.getHeight(), size2, scale, Size.ORIGINAL);
        boolean bl = false;
        int dstWidth = IntPair.getFirst-impl($this$component1_u2dwuMLFU8$iv);
        long $this$component2_u2dwuMLFU8$iv = l;
        boolean bl2 = false;
        int dstHeight = IntPair.getSecond-impl($this$component2_u2dwuMLFU8$iv);
        return DecodeUtils.computeSizeMultiplier(bitmap.getWidth(), bitmap.getHeight(), dstWidth, dstHeight, scale) == 1.0;
    }
}

