/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import coil3.BitmapImage;
import coil3.Image;
import coil3.Uri;
import coil3.UriKt;
import coil3.request.ImageRequest;
import coil3.size.Scale;
import coil3.util.ContextsKt;
import coil3.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0003H\u0002\u001a\b\u0010\u001f\u001a\u00020\u0012H\u0000\u001a3\u0010)\u001a\u0004\u0018\u00010\u0013*\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\b2\b\u0010-\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\u0010.\u001a\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0000\u001a\f\u00108\u001a\u00020\u0001*\u000209H\u0000\"\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\b*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\b*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\b*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$\"\u0014\u0010&\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\"\u000e\u0010/\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u00103\u001a\u000204*\u0002058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"println", "", "level", "Lcoil3/util/Logger$Level;", "tag", "", "message", "toInt", "", "NULL_COLOR_SPACE", "Landroid/graphics/ColorSpace;", "getNULL_COLOR_SPACE", "()Landroid/graphics/ColorSpace;", "nightMode", "Landroid/content/res/Configuration;", "getNightMode", "(Landroid/content/res/Configuration;)I", "isVector", "", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)Z", "width", "getWidth", "(Landroid/graphics/drawable/Drawable;)I", "height", "getHeight", "safeCacheDir", "Ljava/io/File;", "Landroid/content/Context;", "getSafeCacheDir", "(Landroid/content/Context;)Ljava/io/File;", "isMainThread", "VALID_TRANSFORMATION_CONFIGS", "", "Landroid/graphics/Bitmap$Config;", "getVALID_TRANSFORMATION_CONFIGS", "()[Landroid/graphics/Bitmap$Config;", "[Landroid/graphics/Bitmap$Config;", "DEFAULT_BITMAP_CONFIG", "getDEFAULT_BITMAP_CONFIG", "()Landroid/graphics/Bitmap$Config;", "getDrawableCompat", "Lcoil3/request/ImageRequest;", "drawable", "resId", "default", "(Lcoil3/request/ImageRequest;Landroid/graphics/drawable/Drawable;Ljava/lang/Integer;Landroid/graphics/drawable/Drawable;)Landroid/graphics/drawable/Drawable;", "ASSET_FILE_PATH_ROOT", "isAssetUri", "uri", "Lcoil3/Uri;", "scale", "Lcoil3/size/Scale;", "Landroid/widget/ImageView;", "getScale", "(Landroid/widget/ImageView;)Lcoil3/size/Scale;", "prepareToDraw", "Lcoil3/Image;", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nutils.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.android.kt\ncoil3/util/Utils_androidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class Utils_androidKt {
    @Nullable
    private static final ColorSpace NULL_COLOR_SPACE;
    @NotNull
    private static final Bitmap.Config[] VALID_TRANSFORMATION_CONFIGS;
    @NotNull
    private static final Bitmap.Config DEFAULT_BITMAP_CONFIG;
    @NotNull
    public static final String ASSET_FILE_PATH_ROOT = "android_asset";

    public static final void println(@NotNull Logger.Level level, @NotNull String tag, @NotNull String message) {
        Log.println((int)Utils_androidKt.toInt(level), (String)tag, (String)message);
    }

    private static final int toInt(Logger.Level $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toInt.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Nullable
    public static final ColorSpace getNULL_COLOR_SPACE() {
        return NULL_COLOR_SPACE;
    }

    public static final int getNightMode(@NotNull Configuration $this$nightMode) {
        return $this$nightMode.uiMode & 0x30;
    }

    public static final boolean isVector(@NotNull Drawable $this$isVector) {
        return $this$isVector instanceof VectorDrawable || $this$isVector instanceof VectorDrawableCompat;
    }

    public static final int getWidth(@NotNull Drawable $this$width) {
        BitmapDrawable bitmapDrawable = $this$width instanceof BitmapDrawable ? (BitmapDrawable)$this$width : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getWidth() : $this$width.getIntrinsicWidth();
    }

    public static final int getHeight(@NotNull Drawable $this$height) {
        BitmapDrawable bitmapDrawable = $this$height instanceof BitmapDrawable ? (BitmapDrawable)$this$height : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getHeight() : $this$height.getIntrinsicHeight();
    }

    @NotNull
    public static final File getSafeCacheDir(@NotNull Context $this$safeCacheDir) {
        File cacheDir;
        File file;
        File file2 = $this$safeCacheDir.getCacheDir();
        if (file2 == null) {
            boolean $i$a$-checkNotNull-Utils_androidKt$safeCacheDir$cacheDir$22 = false;
            String $i$a$-checkNotNull-Utils_androidKt$safeCacheDir$cacheDir$22 = "cacheDir == null";
            throw new IllegalStateException($i$a$-checkNotNull-Utils_androidKt$safeCacheDir$cacheDir$22.toString());
        }
        File $this$_get_safeCacheDir__u24lambda_u241 = file = (cacheDir = file2);
        boolean bl = false;
        $this$_get_safeCacheDir__u24lambda_u241.mkdirs();
        return file;
    }

    public static final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    @NotNull
    public static final Bitmap.Config[] getVALID_TRANSFORMATION_CONFIGS() {
        return VALID_TRANSFORMATION_CONFIGS;
    }

    @NotNull
    public static final Bitmap.Config getDEFAULT_BITMAP_CONFIG() {
        return DEFAULT_BITMAP_CONFIG;
    }

    @Nullable
    public static final Drawable getDrawableCompat(@NotNull ImageRequest $this$getDrawableCompat, @Nullable Drawable drawable, @DrawableRes @Nullable Integer resId, @Nullable Drawable drawable2) {
        Object object = drawable;
        if (object == null) {
            Integer n = resId;
            object = n != null ? (n != 0 ? ContextsKt.getDrawableCompat($this$getDrawableCompat.getContext(), resId) : null) : drawable2;
        }
        return object;
    }

    public static final boolean isAssetUri(@NotNull Uri uri) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") && Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(UriKt.getPathSegments(uri)), (Object)ASSET_FILE_PATH_ROOT);
    }

    @NotNull
    public static final Scale getScale(@NotNull ImageView $this$scale) {
        Scale scale;
        ImageView.ScaleType scaleType = $this$scale.getScaleType();
        switch (scaleType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[scaleType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                scale = Scale.FIT;
                break;
            }
            default: {
                scale = Scale.FILL;
            }
        }
        return scale;
    }

    public static final void prepareToDraw(@NotNull Image $this$prepareToDraw) {
        if ($this$prepareToDraw instanceof BitmapImage) {
            ((BitmapImage)$this$prepareToDraw).getBitmap().prepareToDraw();
        }
    }

    static {
        Bitmap.Config[] configArray;
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap.Config[] configArray2 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, Bitmap.Config.RGBA_F16};
            configArray = configArray2;
        } else {
            Bitmap.Config[] configArray3 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888};
            configArray = configArray3;
        }
        VALID_TRANSFORMATION_CONFIGS = configArray;
        DEFAULT_BITMAP_CONFIG = Build.VERSION.SDK_INT >= 26 ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Logger.Level.values().length];
            try {
                nArray[Logger.Level.Verbose.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Logger.Level.Debug.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Logger.Level.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Logger.Level.Warn.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Logger.Level.Error.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageView.ScaleType.values().length];
            try {
                nArray[ImageView.ScaleType.FIT_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

