/*
 * Decompiled with CFR 0.152.
 */
package coil3;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import coil3.Image;
import coil3.util.BitmapsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcoil3/BitmapImage;", "Lcoil3/Image;", "bitmap", "Landroid/graphics/Bitmap;", "shareable", "", "<init>", "(Landroid/graphics/Bitmap;Z)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getShareable", "()Z", "size", "", "getSize", "()J", "width", "", "getWidth", "()I", "height", "getHeight", "draw", "", "canvas", "Landroid/graphics/Canvas;", "Lcoil3/Canvas;", "coil-core_release"})
public final class BitmapImage
implements Image {
    @NotNull
    private final Bitmap bitmap;
    private final boolean shareable;

    public BitmapImage(@NotNull Bitmap bitmap, boolean shareable) {
        this.bitmap = bitmap;
        this.shareable = shareable;
    }

    @NotNull
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public boolean getShareable() {
        return this.shareable;
    }

    @Override
    public long getSize() {
        return BitmapsKt.getAllocationByteCountCompat(this.bitmap);
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitmapImage)) {
            return false;
        }
        BitmapImage bitmapImage = (BitmapImage)other;
        if (!Intrinsics.areEqual((Object)this.bitmap, (Object)bitmapImage.bitmap)) {
            return false;
        }
        return this.shareable == bitmapImage.shareable;
    }

    public int hashCode() {
        int result2 = this.bitmap.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.shareable);
        return result2;
    }

    @NotNull
    public String toString() {
        return "BitmapImage(bitmap=" + this.bitmap + ", shareable=" + this.shareable + ')';
    }
}

