/*
 * Decompiled with CFR 0.152.
 */
package coil3.disk;

import coil3.disk.DiskLruCache;
import coil3.disk.FaultHidingSink;
import coil3.util.Collections_jvmCommonKt;
import coil3.util.Coroutines_nonJsCommonKt;
import coil3.util.FileSystemsKt;
import coil3.util.UtilsKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015*\u0001&\b\u0000\u0018\u0000 H2\u00060\u0001j\u0002`\u0002:\u0004EFGHB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020)H\u0002J\b\u0010+\u001a\u00020\u001fH\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020)H\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0017\u00100\u001a\b\u0018\u000101R\u00020\u00002\u0006\u00102\u001a\u00020\u0015H\u0086\u0002J\u0014\u00103\u001a\b\u0018\u000104R\u00020\u00002\u0006\u00102\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\nJ\u001c\u00105\u001a\u00020)2\n\u00106\u001a\u000604R\u00020\u00002\u0006\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\u000e\u00109\u001a\u00020!2\u0006\u00102\u001a\u00020\u0015J\u0014\u0010:\u001a\u00020!2\n\u0010;\u001a\u00060\u0016R\u00020\u0000H\u0002J\b\u0010<\u001a\u00020)H\u0002J\b\u0010=\u001a\u00020)H\u0016J\u0006\u0010>\u001a\u00020)J\b\u0010?\u001a\u00020)H\u0002J\b\u0010@\u001a\u00020!H\u0002J\b\u0010A\u001a\u00020)H\u0002J\u0006\u0010B\u001a\u00020)J\b\u0010C\u001a\u00020)H\u0002J\u0010\u0010D\u001a\u00020)2\u0006\u00102\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u0006I"}, d2={"Lcoil3/disk/DiskLruCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "maxSize", "", "appVersion", "", "valueCount", "<init>", "(Lokio/FileSystem;Lokio/Path;Lkotlin/coroutines/CoroutineContext;JII)V", "journalFile", "journalFileTmp", "journalFileBackup", "lruEntries", "", "", "Lcoil3/disk/DiskLruCache$Entry;", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "size", "operationsSinceRewrite", "journalWriter", "Lokio/BufferedSink;", "hasJournalErrors", "", "initialized", "closed", "mostRecentTrimFailed", "mostRecentRebuildFailed", "coil3/disk/DiskLruCache$fileSystem$1", "Lcoil3/disk/DiskLruCache$fileSystem$1;", "initialize", "", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "writeJournal", "get", "Lcoil3/disk/DiskLruCache$Snapshot;", "key", "edit", "Lcoil3/disk/DiskLruCache$Editor;", "completeEdit", "editor", "success", "journalRewriteRequired", "remove", "removeEntry", "entry", "checkNotClosed", "close", "flush", "trimToSize", "removeOldestEntry", "delete", "evictAll", "launchCleanup", "validateKey", "Snapshot", "Editor", "Entry", "Companion", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,869:1\n1#2:870\n66#3:871\n52#3,4:873\n60#3,10:878\n56#3,3:888\n71#3,3:891\n52#3,4:904\n60#3,10:909\n56#3,18:919\n67#4:872\n68#4:877\n78#4:901\n177#4:902\n81#4:903\n82#4:908\n381#5,7:894\n37#6:937\n36#6,3:938\n37#6:941\n36#6,3:942\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache\n*L\n212#1:871\n212#1:873,4\n212#1:878,10\n212#1:888,3\n212#1:891,3\n324#1:904,4\n324#1:909,10\n324#1:919,18\n212#1:872\n212#1:877\n324#1:901\n324#1:902\n324#1:903\n324#1:908\n275#1:894,7\n587#1:937\n587#1:938,3\n641#1:941\n641#1:942,3\n*E\n"})
public final class DiskLruCache
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    @NotNull
    private final Map<String, Entry> lruEntries;
    @NotNull
    private final CoroutineScope cleanupScope;
    @NotNull
    private final Object lock;
    private long size;
    private int operationsSinceRewrite;
    @Nullable
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    @NotNull
    private final fileSystem.1 fileSystem;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION = "1";
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    public DiskLruCache(@NotNull FileSystem fileSystem2, @NotNull Path directory, @NotNull CoroutineContext cleanupCoroutineContext, long maxSize, int appVersion, int valueCount) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            boolean $i$a$-require-DiskLruCache$32 = false;
            String $i$a$-require-DiskLruCache$32 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-DiskLruCache$32.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = Collections_jvmCommonKt.LruMutableMap$default(0, 0.0f, 3, null);
        CoroutineContext coroutineContext = cleanupCoroutineContext.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null));
        CoroutineDispatcher coroutineDispatcher = UtilsKt.getDispatcher(cleanupCoroutineContext);
        if (coroutineDispatcher == null) {
            coroutineDispatcher = Coroutines_nonJsCommonKt.ioCoroutineDispatcher();
        }
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)coroutineDispatcher, (int)1, null, (int)2, null)));
        this.lock = new Object();
        this.fileSystem = new ForwardingFileSystem(fileSystem2){

            public Sink sink(Path file, boolean mustCreate) {
                block0: {
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path p0 = path;
                    boolean bl = false;
                    this.createDirectories(p0);
                }
                return super.sink(file, mustCreate);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Unit unit;
        void this_$iv;
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFile;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        boolean $i$f$use = false;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
            boolean bl2 = false;
            BufferedSource $this$readJournal_u24lambda_u243 = it$iv;
            boolean bl3 = false;
            String magic = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String version = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String appVersionString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String valueCountString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String blank = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            if (!Intrinsics.areEqual((Object)MAGIC, (Object)magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)VERSION, (Object)version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            if (((CharSequence)blank).length() > 0) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u243.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.operationsSinceRewrite = lineCount - this.lruEntries.size();
                if (!$this$readJournal_u24lambda_u243.exhausted()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                unit = Unit.INSTANCE;
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
        }
        catch (Throwable t$iv$iv) {
            try {
                thrown$iv$iv = t$iv$iv;
                unit = null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                block21: {
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv2) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv2;
                            break block21;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                    }
                }
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$4(this, arg_0)));
        return Okio.buffer((Sink)faultHidingSink);
    }

    private final void readJournalLine(String line) {
        Entry entry;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key = string;
            if (firstSpace == 6 && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key = string;
        }
        Map<String, Entry> $this$getOrPut$iv = this.lruEntries;
        boolean $i$f$getOrPut = false;
        Entry value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Entry answer$iv = new Entry(key);
            $this$getOrPut$iv.put(key, answer$iv);
            entry = answer$iv;
        } else {
            entry = value$iv;
        }
        Entry entry2 = entry;
        if (secondSpace != -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = line.substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{' '};
            List parts = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            entry2.setReadable(true);
            entry2.setCurrentEditor(null);
            entry2.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry2.setCurrentEditor(new Editor(entry2));
        } else if (secondSpace != -1 || firstSpace != 4 || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() {
        long size2 = 0L;
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int i;
            int n;
            Entry entry = iterator.next();
            if (entry.getCurrentEditor() == null) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    size2 += entry.getLengths()[i];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                this.fileSystem.delete(entry.getCleanFiles().get(i));
                this.fileSystem.delete(entry.getDirtyFiles().get(i));
            }
            iterator.remove();
        }
        this.size = size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            Throwable thrown$iv$iv;
            block22: {
                void $this$iv;
                boolean bl = false;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                Path file$iv = this.journalFileTmp;
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl3 = false;
                    BufferedSink $this$writeJournal_u24lambda_u247_u24lambda_u246 = it$iv;
                    boolean bl4 = false;
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(MAGIC).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(VERSION).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeDecimalLong((long)this.appVersion).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeDecimalLong((long)this.valueCount).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                    for (Entry entry : this.lruEntries.values()) {
                        BufferedSink bufferedSink2;
                        if (entry.getCurrentEditor() != null) {
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(DIRTY);
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(32);
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(entry.getKey());
                            bufferedSink2 = $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                            continue;
                        }
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(CLEAN);
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(32);
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(entry.getKey());
                        entry.writeLengths($this$writeJournal_u24lambda_u247_u24lambda_u246);
                        bufferedSink2 = $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block23: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block23;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            Unit unit2 = Unit.INSTANCE;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Snapshot get(@NotNull String key) {
        Object object = this.lock;
        synchronized (object) {
            BufferedSink bufferedSink;
            Object object2;
            block5: {
                boolean bl = false;
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                object2 = this.lruEntries.get(key);
                if (object2 != null && (object2 = ((Entry)object2).snapshot()) != null) break block5;
                Snapshot snapshot = null;
                return snapshot;
            }
            Object snapshot = object2;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            BufferedSink $this$get_u24lambda_u249_u24lambda_u248 = bufferedSink = bufferedSink2;
            boolean bl = false;
            $this$get_u24lambda_u249_u24lambda_u248.writeUtf8(READ);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(32);
            $this$get_u24lambda_u249_u24lambda_u248.writeUtf8(key);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(10);
            $this$get_u24lambda_u249_u24lambda_u248.flush();
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Object object3 = snapshot;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Editor edit(@NotNull String key) {
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            block11: {
                BufferedSink bufferedSink;
                block10: {
                    block9: {
                        block8: {
                            boolean bl = false;
                            this.checkNotClosed();
                            this.validateKey(key);
                            this.initialize();
                            Entry entry2 = entry = this.lruEntries.get(key);
                            if ((entry2 != null ? entry2.getCurrentEditor() : null) == null) break block8;
                            Editor editor = null;
                            return editor;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        Editor editor = null;
                        return editor;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    Editor editor = null;
                    return editor;
                }
                BufferedSink bufferedSink2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink2);
                BufferedSink $this$edit_u24lambda_u2411_u24lambda_u2410 = bufferedSink = bufferedSink2;
                boolean bl = false;
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeUtf8(DIRTY);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(32);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeUtf8(key);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(10);
                $this$edit_u24lambda_u2411_u24lambda_u2410.flush();
                if (!this.hasJournalErrors) break block11;
                Editor editor = null;
                return editor;
            }
            if (entry == null) {
                entry = new Entry(key);
                this.lruEntries.put(key, entry);
            }
            Editor editor = new Editor(entry);
            entry.setCurrentEditor(editor);
            Editor editor2 = editor;
            return editor2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long size() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            long l = this.size;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeEdit(Editor editor, boolean success) {
        Object object = this.lock;
        synchronized (object) {
            BufferedSink bufferedSink;
            BufferedSink bufferedSink2;
            int i;
            int n;
            boolean bl = false;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                throw new IllegalStateException("Check failed.");
            }
            if (success && !entry.getZombie()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    if (!editor.getWritten()[i] || this.fileSystem.exists(entry.getDirtyFiles().get(i))) continue;
                    editor.abort();
                    return;
                }
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    long newLength;
                    Path dirty = entry.getDirtyFiles().get(i);
                    Path clean = entry.getCleanFiles().get(i);
                    if (this.fileSystem.exists(dirty)) {
                        this.fileSystem.atomicMove(dirty, clean);
                    } else {
                        FileSystemsKt.createFile$default((FileSystem)this.fileSystem, entry.getCleanFiles().get(i), false, 2, null);
                    }
                    long oldLength = entry.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry.getLengths()[i] = newLength = l != null ? l : 0L;
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    this.fileSystem.delete(entry.getDirtyFiles().get(i));
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                return;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink3 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink3);
            BufferedSink $this$completeEdit_u24lambda_u2414_u24lambda_u2413 = bufferedSink2 = bufferedSink3;
            boolean bl2 = false;
            if (success || entry.getReadable()) {
                entry.setReadable(true);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(CLEAN);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                entry.writeLengths($this$completeEdit_u24lambda_u2414_u24lambda_u2413);
                bufferedSink = $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            } else {
                this.lruEntries.remove(entry.getKey());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(REMOVE);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                bufferedSink = $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2414_u24lambda_u2413.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull String key) {
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            block5: {
                boolean bl = false;
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                if (this.lruEntries.get(key) != null) break block5;
                boolean bl2 = false;
                return bl2;
            }
            Entry entry2 = entry;
            boolean removed = this.removeEntry(entry2);
            if (removed && this.size <= this.maxSize) {
                this.mostRecentTrimFailed = false;
            }
            boolean bl = removed;
            return bl;
        }
    }

    private final boolean removeEntry(Entry entry) {
        if (entry.getLockingSnapshotCount() > 0) {
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink2;
                BufferedSink $this$removeEntry_u24lambda_u2416 = bufferedSink2 = bufferedSink;
                boolean bl = false;
                $this$removeEntry_u24lambda_u2416.writeUtf8(DIRTY);
                $this$removeEntry_u24lambda_u2416.writeByte(32);
                $this$removeEntry_u24lambda_u2416.writeUtf8(entry.getKey());
                $this$removeEntry_u24lambda_u2416.writeByte(10);
                $this$removeEntry_u24lambda_u2416.flush();
            }
        }
        if (entry.getLockingSnapshotCount() > 0 || entry.getCurrentEditor() != null) {
            entry.setZombie(true);
            return true;
        }
        int n = this.valueCount;
        for (int i = 0; i < n; ++i) {
            this.fileSystem.delete(entry.getCleanFiles().get(i));
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
        }
        int n2 = this.operationsSinceRewrite;
        this.operationsSinceRewrite = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            BufferedSink bufferedSink3;
            BufferedSink $this$removeEntry_u24lambda_u2417 = bufferedSink3 = bufferedSink;
            boolean bl = false;
            $this$removeEntry_u24lambda_u2417.writeUtf8(REMOVE);
            $this$removeEntry_u24lambda_u2417.writeByte(32);
            $this$removeEntry_u24lambda_u2417.writeUtf8(entry.getKey());
            $this$removeEntry_u24lambda_u2417.writeByte(10);
            $this$removeEntry_u24lambda_u2417.flush();
        }
        this.lruEntries.remove(entry.getKey());
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized || this.closed) {
                this.closed = true;
                return;
            }
            Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
            boolean $i$f$toTypedArray = false;
            Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
            for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
                Editor editor = entry.getCurrentEditor();
                if (editor == null) continue;
                editor.detach();
            }
            this.trimToSize();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
            this.journalWriter = null;
            this.closed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized) {
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            if (toEvict.getZombie()) continue;
            this.removeEntry(toEvict);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemsKt.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
            boolean $i$f$toTypedArray = false;
            Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
            for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
                this.removeEntry(entry);
            }
            this.mostRecentTrimFailed = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void launchCleanup() {
        BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object2 = DiskLruCache.access$getLock$p(this.this$0);
                        DiskLruCache diskLruCache = this.this$0;
                        Object object3 = object2;
                        synchronized (object3) {
                            boolean bl = false;
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(diskLruCache)) {
                                    DiskLruCache.access$writeJournal(diskLruCache);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            Unit unit = Unit.INSTANCE;
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit newJournalWriter$lambda$4(DiskLruCache this$0, IOException it) {
        this$0.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0014\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0014\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u0014\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil3/disk/DiskLruCache$Companion;", "", "<init>", "()V", "JOURNAL_FILE", "", "getJOURNAL_FILE$coil_core_release$annotations", "JOURNAL_FILE_TMP", "getJOURNAL_FILE_TMP$coil_core_release$annotations", "JOURNAL_FILE_BACKUP", "getJOURNAL_FILE_BACKUP$coil_core_release$annotations", "MAGIC", "getMAGIC$coil_core_release$annotations", "VERSION", "getVERSION$coil_core_release$annotations", "CLEAN", "DIRTY", "REMOVE", "READ", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "coil-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getJOURNAL_FILE$coil_core_release$annotations() {
        }

        public static /* synthetic */ void getJOURNAL_FILE_TMP$coil_core_release$annotations() {
        }

        public static /* synthetic */ void getJOURNAL_FILE_BACKUP$coil_core_release$annotations() {
        }

        public static /* synthetic */ void getMAGIC$coil_core_release$annotations() {
        }

        public static /* synthetic */ void getVERSION$coil_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcoil3/disk/DiskLruCache$Editor;", "", "entry", "Lcoil3/disk/DiskLruCache$Entry;", "Lcoil3/disk/DiskLruCache;", "<init>", "(Lcoil3/disk/DiskLruCache;Lcoil3/disk/DiskLruCache$Entry;)V", "getEntry", "()Lcoil3/disk/DiskLruCache$Entry;", "closed", "", "written", "", "getWritten", "()[Z", "file", "Lokio/Path;", "index", "", "detach", "", "commit", "commitAndGet", "Lcoil3/disk/DiskLruCache$Snapshot;", "abort", "complete", "success", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Editor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,869:1\n1#2:870\n*E\n"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        private boolean closed;
        @NotNull
        private final boolean[] written;

        public Editor(Entry entry) {
            this.entry = entry;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Path file(int index) {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.written[index] = true;
                Path path = this.entry.getDirtyFiles().get(index);
                fileSystem.1 var6_9 = diskLruCache.fileSystem;
                Path p0 = path;
                boolean bl3 = false;
                FileSystemsKt.createFile$default((FileSystem)var6_9, p0, false, 2, null);
                Path path2 = path;
                return path2;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Snapshot commitAndGet() {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.commit();
                Snapshot snapshot = diskLruCache.get(this.entry.getKey());
                return snapshot;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void complete(boolean success) {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache.completeEdit(this, success);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-J\u000e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200J\f\u00101\u001a\b\u0018\u000102R\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R \u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lcoil3/disk/DiskLruCache$Entry;", "", "key", "", "<init>", "(Lcoil3/disk/DiskLruCache;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "dirtyFiles", "getDirtyFiles", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "currentEditor", "Lcoil3/disk/DiskLruCache$Editor;", "Lcoil3/disk/DiskLruCache;", "getCurrentEditor", "()Lcoil3/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcoil3/disk/DiskLruCache$Editor;)V", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "setLengths", "", "strings", "", "writeLengths", "writer", "Lokio/BufferedSink;", "snapshot", "Lcoil3/disk/DiskLruCache$Snapshot;", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Entry\n+ 2 collections.kt\ncoil3/util/CollectionsKt\n*L\n1#1,869:1\n43#2,4:870\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Entry\n*L\n841#1:870,4\n*E\n"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final ArrayList<Path> cleanFiles;
        @NotNull
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                ((Collection)this.cleanFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.append(".tmp");
                ((Collection)this.dirtyFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(@NotNull List<String> strings) {
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = ((Collection)strings).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("unexpected journal line: " + strings);
            }
        }

        public final void writeLengths(@NotNull BufferedSink writer) {
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            List list = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$forEachIndices = false;
            int n = ((Collection)$this$forEachIndices$iv).size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                if (diskLruCache.fileSystem.exists(file)) continue;
                try {
                    diskLruCache.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            int n2 = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n2 + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0005R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil3/disk/DiskLruCache$Snapshot;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "entry", "Lcoil3/disk/DiskLruCache$Entry;", "Lcoil3/disk/DiskLruCache;", "<init>", "(Lcoil3/disk/DiskLruCache;Lcoil3/disk/DiskLruCache$Entry;)V", "getEntry", "()Lcoil3/disk/DiskLruCache$Entry;", "closed", "", "file", "Lokio/Path;", "index", "", "close", "", "closeAndEdit", "Lcoil3/disk/DiskLruCache$Editor;", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,869:1\n1#2:870\n*E\n"})
    public final class Snapshot
    implements AutoCloseable {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            this.entry = entry;
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final Path file(int index) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            return this.entry.getCleanFiles().get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                Object object = DiskLruCache.this.lock;
                DiskLruCache diskLruCache = DiskLruCache.this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    Entry entry = this.entry;
                    int n = entry.getLockingSnapshotCount();
                    entry.setLockingSnapshotCount(n + -1);
                    if (this.entry.getLockingSnapshotCount() == 0 && this.entry.getZombie()) {
                        diskLruCache.removeEntry(this.entry);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Editor closeAndEdit() {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.close();
                Editor editor = diskLruCache.edit(this.entry.getKey());
                return editor;
            }
        }
    }
}

