/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import coil3.ImageLoader;
import coil3.Image_androidKt;
import coil3.decode.BitmapFactoryDecoder;
import coil3.decode.DecodeResult;
import coil3.decode.DecodeUtils;
import coil3.decode.Decoder;
import coil3.decode.ExifData;
import coil3.decode.ExifOrientationStrategy;
import coil3.decode.ExifUtils;
import coil3.decode.ExifUtilsKt;
import coil3.decode.ImageSource;
import coil3.fetch.SourceFetchResult;
import coil3.request.ImageRequestsKt;
import coil3.request.ImageRequests_androidKt;
import coil3.request.Options;
import coil3.size.Precision;
import coil3.util.BitmapsKt;
import coil3.util.IntPair;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\f\u001a\u00020\r*\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil3/decode/BitmapFactoryDecoder;", "Lcoil3/decode/Decoder;", "source", "Lcoil3/decode/ImageSource;", "options", "Lcoil3/request/Options;", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "exifOrientationStrategy", "Lcoil3/decode/ExifOrientationStrategy;", "<init>", "(Lcoil3/decode/ImageSource;Lcoil3/request/Options;Lkotlinx/coroutines/sync/Semaphore;Lcoil3/decode/ExifOrientationStrategy;)V", "decode", "Lcoil3/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroid/graphics/BitmapFactory$Options;", "configureConfig", "", "exifData", "Lcoil3/decode/ExifData;", "configureScale", "Factory", "ExceptionCatchingSource", "Companion", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nBitmapFactoryDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapFactoryDecoder.kt\ncoil3/decode/BitmapFactoryDecoder\n+ 2 Semaphore.kt\nkotlinx/coroutines/sync/SemaphoreKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 bitmaps.kt\ncoil3/util/BitmapsKt\n+ 5 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n+ 6 collections.kt\ncoil3/util/CollectionsKt\n*L\n1#1,211:1\n81#2,6:212\n1#3:218\n51#4:219\n27#5:220\n23#6,3:221\n*S KotlinDebug\n*F\n+ 1 BitmapFactoryDecoder.kt\ncoil3/decode/BitmapFactoryDecoder\n*L\n39#1:212,6\n86#1:219\n86#1:220\n127#1:221,3\n*E\n"})
public final class BitmapFactoryDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    @NotNull
    private final Semaphore parallelismLock;
    @NotNull
    private final ExifOrientationStrategy exifOrientationStrategy;
    public static final int DEFAULT_MAX_PARALLELISM = 4;

    public BitmapFactoryDecoder(@NotNull ImageSource source, @NotNull Options options, @NotNull Semaphore parallelismLock, @NotNull ExifOrientationStrategy exifOrientationStrategy) {
        this.source = source;
        this.options = options;
        this.parallelismLock = parallelismLock;
        this.exifOrientationStrategy = exifOrientationStrategy;
    }

    public /* synthetic */ BitmapFactoryDecoder(ImageSource imageSource, Options options, Semaphore semaphore, ExifOrientationStrategy exifOrientationStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            semaphore = SemaphoreKt.Semaphore$default((int)Integer.MAX_VALUE, (int)0, (int)2, null);
        }
        if ((n & 8) != 0) {
            exifOrientationStrategy = ExifOrientationStrategy.RESPECT_PERFORMANCE;
        }
        this(imageSource, options, semaphore, exifOrientationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        if (!($completion instanceof decode.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BitmapFactoryDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.decode((Continuation<? super DecodeResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.parallelismLock;
                $i$f$withPermit = false;
                $continuation.L$0 = $this$withPermit$iv;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                $i$f$withPermit = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 3 sources

                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $continuation.L$0 = $this$withPermit$iv;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, decode$lambda$1$lambda$0(coil3.decode.BitmapFactoryDecoder ), ()Lcoil3/decode/DecodeResult;)((BitmapFactoryDecoder)this), (Continuation)$continuation, (int)1, null);
                ** if (v1 != var8_4) goto lbl33
lbl32:
                // 1 sources

                return var8_4;
lbl33:
                // 1 sources

                ** GOTO lbl42
            }
            case 2: {
                $i$f$withPermit = false;
                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 2 sources

                    var5_12 = (DecodeResult)v1;
                }
                catch (Throwable var4_11) {
                    throw var4_11;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                return var5_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DecodeResult decode(BitmapFactory.Options $this$decode) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        Object it;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource((Source)this.source.source());
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$decode.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$decode);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception it2 = exception;
            boolean bl = false;
            throw it2;
        }
        $this$decode.inJustDecodeBounds = false;
        ExifData exifData = ExifUtils.INSTANCE.getExifData($this$decode.outMimeType, safeBufferedSource, this.exifOrientationStrategy);
        Exception exception2 = safeSource.getException();
        if (exception2 != null) {
            Exception it3 = exception2;
            boolean bl = false;
            throw it3;
        }
        $this$decode.inMutable = false;
        if (Build.VERSION.SDK_INT >= 26 && ImageRequests_androidKt.getColorSpace(this.options) != null) {
            $this$decode.inPreferredColorSpace = ImageRequests_androidKt.getColorSpace(this.options);
        }
        $this$decode.inPremultiplied = ImageRequests_androidKt.getPremultipliedAlpha(this.options);
        this.configureConfig($this$decode, exifData);
        this.configureScale($this$decode, exifData);
        Object it2 = (Closeable)safeBufferedSource;
        Throwable it3 = null;
        try {
            it = (BufferedSource)it2;
            boolean bl = false;
            it = BitmapFactory.decodeStream((InputStream)it.inputStream(), null, (BitmapFactory.Options)$this$decode);
        }
        catch (Throwable bl) {
            it3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it2, (Throwable)it3);
        }
        BufferedSource outBitmap = it;
        it2 = safeSource.getException();
        if (it2 != null) {
            it = it2;
            boolean bl = false;
            throw it;
        }
        if (outBitmap == null) {
            boolean $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = false;
            String $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = "BitmapFactory returned a null bitmap. Often this means BitmapFactory could not decode the image data read from the image source (e.g. network, disk, or memory) as it's not encoded as a valid image format.";
            throw new IllegalStateException($i$a$-checkNotNull-BitmapFactoryDecoder$decode$72.toString());
        }
        outBitmap.setDensity(this.options.getContext().getResources().getDisplayMetrics().densityDpi);
        Bitmap bitmap = ExifUtils.INSTANCE.reverseTransformations((Bitmap)outBitmap, exifData);
        it3 = bitmap;
        Context context$iv = this.options.getContext();
        boolean $i$f$toDrawable = false;
        void var10_18 = $this$toDrawable$iv;
        Resources resources$iv$iv = context$iv.getResources();
        boolean $i$f$toDrawable2 = false;
        return new DecodeResult(Image_androidKt.asImage((Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv)), $this$decode.inSampleSize > 1 || $this$decode.inScaled);
    }

    private final void configureConfig(BitmapFactory.Options $this$configureConfig, ExifData exifData) {
        Bitmap.Config config = ImageRequests_androidKt.getBitmapConfig(this.options);
        if (exifData.isFlipped() || ExifUtilsKt.isRotated(exifData)) {
            config = BitmapsKt.toSoftware(config);
        }
        if (ImageRequests_androidKt.getAllowRgb565(this.options) && config == Bitmap.Config.ARGB_8888 && Intrinsics.areEqual((Object)$this$configureConfig.outMimeType, (Object)"image/jpeg")) {
            config = Bitmap.Config.RGB_565;
        }
        if (Build.VERSION.SDK_INT >= 26 && $this$configureConfig.outConfig == Bitmap.Config.RGBA_F16 && config != Bitmap.Config.HARDWARE) {
            config = Bitmap.Config.RGBA_F16;
        }
        $this$configureConfig.inPreferredConfig = config;
    }

    private final void configureScale(BitmapFactory.Options $this$configureScale, ExifData exifData) {
        long l;
        if ($this$configureScale.outWidth <= 0 || $this$configureScale.outHeight <= 0) {
            $this$configureScale.inSampleSize = 1;
            $this$configureScale.inScaled = false;
            return;
        }
        int srcWidth = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outHeight : $this$configureScale.outWidth;
        int srcHeight = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outWidth : $this$configureScale.outHeight;
        long $this$component1_u2dwuMLFU8$iv = l = DecodeUtils.computeDstSize-sEdh43o(srcWidth, srcHeight, this.options.getSize(), this.options.getScale(), ImageRequestsKt.getMaxBitmapSize(this.options));
        boolean bl = false;
        int dstWidth = IntPair.getFirst-impl($this$component1_u2dwuMLFU8$iv);
        long $this$component2_u2dwuMLFU8$iv = l;
        boolean bl2 = false;
        int dstHeight = IntPair.getSecond-impl($this$component2_u2dwuMLFU8$iv);
        $this$configureScale.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, dstWidth, dstHeight, this.options.getScale());
        double scale = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$configureScale.inSampleSize, (double)srcHeight / (double)$this$configureScale.inSampleSize, (double)dstWidth, (double)dstHeight, this.options.getScale());
        if (this.options.getPrecision() == Precision.INEXACT) {
            scale = RangesKt.coerceAtMost((double)scale, (double)1.0);
        }
        boolean bl3 = $this$configureScale.inScaled = !(scale == 1.0);
        if ($this$configureScale.inScaled) {
            if (scale > 1.0) {
                $this$configureScale.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale));
                $this$configureScale.inTargetDensity = Integer.MAX_VALUE;
            } else {
                $this$configureScale.inDensity = Integer.MAX_VALUE;
                $this$configureScale.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale));
            }
        }
    }

    private static final DecodeResult decode$lambda$1$lambda$0(BitmapFactoryDecoder this$0) {
        return this$0.decode(new BitmapFactory.Options());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil3/decode/BitmapFactoryDecoder$Companion;", "", "<init>", "()V", "DEFAULT_MAX_PARALLELISM", "", "coil-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016R.\u0010\t\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcoil3/decode/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "value", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "coil-core_release"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        public ExceptionCatchingSource(@NotNull Source delegate) {
            super(delegate);
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcoil3/decode/BitmapFactoryDecoder$Factory;", "Lcoil3/decode/Decoder$Factory;", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "exifOrientationStrategy", "Lcoil3/decode/ExifOrientationStrategy;", "<init>", "(Lkotlinx/coroutines/sync/Semaphore;Lcoil3/decode/ExifOrientationStrategy;)V", "create", "Lcoil3/decode/Decoder;", "result", "Lcoil3/fetch/SourceFetchResult;", "options", "Lcoil3/request/Options;", "imageLoader", "Lcoil3/ImageLoader;", "coil-core_release"})
    public static final class Factory
    implements Decoder.Factory {
        @NotNull
        private final Semaphore parallelismLock;
        @NotNull
        private final ExifOrientationStrategy exifOrientationStrategy;

        public Factory(@NotNull Semaphore parallelismLock, @NotNull ExifOrientationStrategy exifOrientationStrategy) {
            this.parallelismLock = parallelismLock;
            this.exifOrientationStrategy = exifOrientationStrategy;
        }

        public /* synthetic */ Factory(Semaphore semaphore, ExifOrientationStrategy exifOrientationStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                semaphore = SemaphoreKt.Semaphore$default((int)4, (int)0, (int)2, null);
            }
            if ((n & 2) != 0) {
                exifOrientationStrategy = ExifOrientationStrategy.RESPECT_PERFORMANCE;
            }
            this(semaphore, exifOrientationStrategy);
        }

        @Override
        @NotNull
        public Decoder create(@NotNull SourceFetchResult result2, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            return new BitmapFactoryDecoder(result2.getSource(), options, this.parallelismLock, this.exifOrientationStrategy);
        }

        public Factory() {
            this(null, null, 3, null);
        }
    }
}

