/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.exifinterface.media.ExifInterface;
import coil3.decode.ExifData;
import coil3.decode.ExifInterfaceInputStream;
import coil3.decode.ExifOrientationStrategy;
import coil3.decode.ExifUtilsKt;
import coil3.util.BitmapsKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcoil3/decode/ExifUtils;", "", "<init>", "()V", "paint", "Landroid/graphics/Paint;", "getExifData", "Lcoil3/decode/ExifData;", "mimeType", "", "source", "Lokio/BufferedSource;", "strategy", "Lcoil3/decode/ExifOrientationStrategy;", "reverseTransformations", "Landroid/graphics/Bitmap;", "inBitmap", "exifData", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nExifUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExifUtils.kt\ncoil3/decode/ExifUtils\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,114:1\n89#2:115\n89#2:116\n42#2,3:117\n*S KotlinDebug\n*F\n+ 1 ExifUtils.kt\ncoil3/decode/ExifUtils\n*L\n60#1:115\n62#1:116\n65#1:117,3\n*E\n"})
public final class ExifUtils {
    @NotNull
    public static final ExifUtils INSTANCE = new ExifUtils();
    @NotNull
    private static final Paint paint = new Paint(3);

    private ExifUtils() {
    }

    @NotNull
    public final ExifData getExifData(@Nullable String mimeType, @NotNull BufferedSource source, @NotNull ExifOrientationStrategy strategy) {
        if (strategy.supports(mimeType, source)) {
            ExifInterface exifInterface = new ExifInterface((InputStream)new ExifInterfaceInputStream(source.peek().inputStream()));
            return new ExifData(exifInterface.isFlipped(), exifInterface.getRotationDegrees());
        }
        return ExifData.NONE;
    }

    @NotNull
    public final Bitmap reverseTransformations(@NotNull Bitmap inBitmap, @NotNull ExifData exifData) {
        Canvas c$iv;
        Bitmap outBitmap;
        Bitmap bitmap;
        int height$iv;
        int width$iv;
        boolean $i$f$createBitmap;
        Bitmap.Config config$iv;
        if (!exifData.isFlipped() && !ExifUtilsKt.isRotated(exifData)) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (exifData.isFlipped()) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (ExifUtilsKt.isRotated(exifData)) {
            matrix.postRotate((float)exifData.getRotationDegrees(), centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (!(rect.left == 0.0f) || !(rect.top == 0.0f)) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        if (ExifUtilsKt.isSwapped(exifData)) {
            int n = inBitmap.getHeight();
            int n2 = inBitmap.getWidth();
            config$iv = BitmapsKt.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            bitmap = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
        } else {
            width$iv = inBitmap.getWidth();
            height$iv = inBitmap.getHeight();
            config$iv = BitmapsKt.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            bitmap = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
        }
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$reverseTransformations_u24lambda_u240 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$reverseTransformations_u24lambda_u240.drawBitmap(inBitmap, matrix, paint);
        inBitmap.recycle();
        return outBitmap;
    }
}

