/*
 * Decompiled with CFR 0.152.
 */
package coil3.disk;

import coil3.disk.DiskCache;
import coil3.disk.DiskLruCache;
import coil3.util.UtilsKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 $2\u00020\u0001:\u0003\"#$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\f\u0010!\u001a\u00020\u0019*\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r\u00a8\u0006%"}, d2={"Lcoil3/disk/RealDiskCache;", "Lcoil3/disk/DiskCache;", "maxSize", "", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "cleanupCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(JLokio/Path;Lokio/FileSystem;Lkotlin/coroutines/CoroutineContext;)V", "getMaxSize", "()J", "getDirectory", "()Lokio/Path;", "getFileSystem", "()Lokio/FileSystem;", "cache", "Lcoil3/disk/DiskLruCache;", "size", "getSize", "openSnapshot", "Lcoil3/disk/DiskCache$Snapshot;", "key", "", "openEditor", "Lcoil3/disk/DiskCache$Editor;", "remove", "", "clear", "", "shutdown", "hash", "RealSnapshot", "RealEditor", "Companion", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil3/disk/RealDiskCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class RealDiskCache
implements DiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxSize;
    @NotNull
    private final Path directory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final DiskLruCache cache;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_DATA = 1;

    public RealDiskCache(long maxSize, @NotNull Path directory, @NotNull FileSystem fileSystem2, @NotNull CoroutineContext cleanupCoroutineContext) {
        this.maxSize = maxSize;
        this.directory = directory;
        this.fileSystem = fileSystem2;
        this.cache = new DiskLruCache(this.getFileSystem(), this.getDirectory(), cleanupCoroutineContext, this.getMaxSize(), 3, 2);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    @NotNull
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }

    @Override
    @Nullable
    public DiskCache.Snapshot openSnapshot(@NotNull String key) {
        RealSnapshot realSnapshot;
        DiskLruCache.Snapshot snapshot = this.cache.get(this.hash(key));
        if (snapshot != null) {
            DiskLruCache.Snapshot p0 = snapshot;
            boolean bl = false;
            realSnapshot = new RealSnapshot(p0);
        } else {
            realSnapshot = null;
        }
        return realSnapshot;
    }

    @Override
    @Nullable
    public DiskCache.Editor openEditor(@NotNull String key) {
        RealEditor realEditor;
        DiskLruCache.Editor editor = this.cache.edit(this.hash(key));
        if (editor != null) {
            DiskLruCache.Editor p0 = editor;
            boolean bl = false;
            realEditor = new RealEditor(p0);
        } else {
            realEditor = null;
        }
        return realEditor;
    }

    @Override
    public boolean remove(@NotNull String key) {
        return this.cache.remove(this.hash(key));
    }

    @Override
    public void clear() {
        this.cache.evictAll();
    }

    @Override
    public void shutdown() {
        UtilsKt.closeQuietly(this.cache);
    }

    private final String hash(String $this$hash) {
        return ByteString.Companion.encodeUtf8($this$hash).sha256().hex();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcoil3/disk/RealDiskCache$Companion;", "", "<init>", "()V", "ENTRY_METADATA", "", "ENTRY_DATA", "coil-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lcoil3/disk/RealDiskCache$RealEditor;", "Lcoil3/disk/DiskCache$Editor;", "editor", "Lcoil3/disk/DiskLruCache$Editor;", "Lcoil3/disk/DiskLruCache;", "<init>", "(Lcoil3/disk/DiskLruCache$Editor;)V", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "commit", "", "commitAndOpenSnapshot", "Lcoil3/disk/RealDiskCache$RealSnapshot;", "abort", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil3/disk/RealDiskCache$RealEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    private static final class RealEditor
    implements DiskCache.Editor {
        @NotNull
        private final DiskLruCache.Editor editor;

        public RealEditor(@NotNull DiskLruCache.Editor editor) {
            this.editor = editor;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.editor.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.editor.file(1);
        }

        @Override
        public void commit() {
            this.editor.commit();
        }

        @Override
        @Nullable
        public RealSnapshot commitAndOpenSnapshot() {
            RealSnapshot realSnapshot;
            DiskLruCache.Snapshot snapshot = this.editor.commitAndGet();
            if (snapshot != null) {
                DiskLruCache.Snapshot p0 = snapshot;
                boolean bl = false;
                realSnapshot = new RealSnapshot(p0);
            } else {
                realSnapshot = null;
            }
            return realSnapshot;
        }

        @Override
        public void abort() {
            this.editor.abort();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcoil3/disk/RealDiskCache$RealSnapshot;", "Lcoil3/disk/DiskCache$Snapshot;", "snapshot", "Lcoil3/disk/DiskLruCache$Snapshot;", "Lcoil3/disk/DiskLruCache;", "<init>", "(Lcoil3/disk/DiskLruCache$Snapshot;)V", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "close", "", "closeAndOpenEditor", "Lcoil3/disk/RealDiskCache$RealEditor;", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil3/disk/RealDiskCache$RealSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    private static final class RealSnapshot
    implements DiskCache.Snapshot {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;

        public RealSnapshot(@NotNull DiskLruCache.Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.snapshot.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.snapshot.file(1);
        }

        @Override
        public void close() {
            this.snapshot.close();
        }

        @Override
        @Nullable
        public RealEditor closeAndOpenEditor() {
            RealEditor realEditor;
            DiskLruCache.Editor editor = this.snapshot.closeAndEdit();
            if (editor != null) {
                DiskLruCache.Editor p0 = editor;
                boolean bl = false;
                realEditor = new RealEditor(p0);
            } else {
                realEditor = null;
            }
            return realEditor;
        }
    }
}

