/*
 * Decompiled with CFR 0.152.
 */
package coil3.transform;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.Px;
import coil3.decode.DecodeUtils;
import coil3.size.Dimension;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeKt;
import coil3.transform.Transformation;
import coil3.transform.TransformationsKt;
import coil3.util.BitmapsKt;
import coil3.util.IntPair;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0013\b\u0016\u0012\b\b\u0001\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\nJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcoil3/transform/RoundedCornersTransformation;", "Lcoil3/transform/Transformation;", "topLeft", "", "topRight", "bottomLeft", "bottomRight", "<init>", "(FFFF)V", "radius", "(F)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "transform", "Landroid/graphics/Bitmap;", "input", "size", "Lcoil3/size/Size;", "(Landroid/graphics/Bitmap;Lcoil3/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateOutputSize", "Lcoil3/util/IntPair;", "calculateOutputSize-nmZnaPc", "(Landroid/graphics/Bitmap;Lcoil3/size/Size;)J", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nRoundedCornersTransformation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedCornersTransformation.kt\ncoil3/transform/RoundedCornersTransformation\n+ 2 collections.kt\ncoil3/util/CollectionsKt\n+ 3 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Dimension.kt\ncoil3/size/DimensionKt\n*L\n1#1,92:1\n23#2,3:93\n89#3:96\n42#3,2:97\n44#3:100\n1#4:99\n43#5:101\n43#5:102\n*S KotlinDebug\n*F\n+ 1 RoundedCornersTransformation.kt\ncoil3/transform/RoundedCornersTransformation\n*L\n51#1:93,3\n52#1:96\n52#1:97,2\n52#1:100\n83#1:101\n84#1:102\n*E\n"})
public final class RoundedCornersTransformation
extends Transformation {
    private final float topLeft;
    private final float topRight;
    private final float bottomLeft;
    private final float bottomRight;
    @NotNull
    private final String cacheKey;

    public RoundedCornersTransformation(@Px float topLeft, @Px float topRight, @Px float bottomLeft, @Px float bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        if (!(this.topLeft >= 0.0f && this.topRight >= 0.0f && this.bottomLeft >= 0.0f && this.bottomRight >= 0.0f)) {
            boolean bl = false;
            String string = "All radii must be >= 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.cacheKey = Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + '-' + this.topLeft + ',' + this.topRight + ',' + this.bottomLeft + ',' + this.bottomRight;
    }

    public /* synthetic */ RoundedCornersTransformation(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        this(f, f2, f3, f4);
    }

    public RoundedCornersTransformation(@Px float radius) {
        this(radius, radius, radius, radius);
    }

    @Override
    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        void $this$applyCanvas$iv;
        Canvas c$iv;
        long l;
        long $this$component1_u2dwuMLFU8$iv = l = this.calculateOutputSize-nmZnaPc(input, size2);
        boolean bl = false;
        int outputWidth = IntPair.getFirst-impl($this$component1_u2dwuMLFU8$iv);
        long $this$component2_u2dwuMLFU8$iv = l;
        boolean bl2 = false;
        int outputHeight = IntPair.getSecond-impl($this$component2_u2dwuMLFU8$iv);
        Bitmap.Config config$iv = BitmapsKt.getSafeConfig(input);
        boolean $i$f$createBitmap = false;
        config$iv = Bitmap.createBitmap((int)outputWidth, (int)outputHeight, (Bitmap.Config)config$iv);
        boolean $i$f$applyCanvas = false;
        Canvas $this$transform_u24lambda_u242 = c$iv = new Canvas((Bitmap)$this$applyCanvas$iv);
        boolean bl3 = false;
        Paint paint = TransformationsKt.newScaledShaderPaint(input, outputWidth, outputHeight);
        if (this.topLeft == this.topRight && this.topRight == this.bottomLeft && this.bottomLeft == this.bottomRight) {
            $this$transform_u24lambda_u242.drawRoundRect(0.0f, 0.0f, (float)outputWidth, (float)outputHeight, this.topLeft, this.topLeft, paint);
        } else {
            Path path;
            float[] fArray = new float[]{this.topLeft, this.topLeft, this.topRight, this.topRight, this.bottomRight, this.bottomRight, this.bottomLeft, this.bottomLeft};
            float[] radii = fArray;
            RectF rect = new RectF(0.0f, 0.0f, (float)outputWidth, (float)outputHeight);
            Path $this$transform_u24lambda_u242_u24lambda_u241 = path = new Path();
            boolean bl4 = false;
            $this$transform_u24lambda_u242_u24lambda_u241.addRoundRect(rect, radii, Path.Direction.CW);
            Path path2 = path;
            $this$transform_u24lambda_u242.drawPath(path2, paint);
        }
        return $this$applyCanvas$iv;
    }

    private final long calculateOutputSize-nmZnaPc(Bitmap input, Size size2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (SizeKt.isOriginal(size2)) {
            return IntPair.constructor-impl(input.getWidth(), input.getHeight());
        }
        Dimension dstWidth = size2.component1();
        Dimension dstHeight = size2.component2();
        if (dstWidth instanceof Dimension.Pixels && dstHeight instanceof Dimension.Pixels) {
            return IntPair.constructor-impl(((Dimension.Pixels)dstWidth).unbox-impl(), ((Dimension.Pixels)dstHeight).unbox-impl());
        }
        int n6 = input.getWidth();
        int n7 = input.getHeight();
        Dimension $this$pxOrElse$iv = size2.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = Integer.MIN_VALUE;
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size2.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = Integer.MIN_VALUE;
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        double multiplier = DecodeUtils.computeSizeMultiplier(n6, n7, n5, n, Scale.FILL);
        int outputWidth = MathKt.roundToInt((double)(multiplier * (double)input.getWidth()));
        int outputHeight = MathKt.roundToInt((double)(multiplier * (double)input.getHeight()));
        return IntPair.constructor-impl(outputWidth, outputHeight);
    }

    public RoundedCornersTransformation() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

