/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import coil3.util.Collections_jvmCommonKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0017J\b\u0010\"\u001a\u00020\u0005H\u0002J\u001d\u0010#\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcoil3/util/LruCache;", "K", "", "V", "maxSize", "", "<init>", "(J)V", "getMaxSize", "()J", "map", "", "value", "size", "getSize", "keys", "", "getKeys", "()Ljava/util/Set;", "sizeOf", "key", "(Ljava/lang/Object;Ljava/lang/Object;)J", "entryRemoved", "", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "remove", "trimToSize", "clear", "recomputeSize", "safeSizeOf", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\ncoil3/util/LruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public class LruCache<K, V> {
    private final long maxSize;
    @NotNull
    private final Map<K, V> map;
    private long size;

    public LruCache(long maxSize) {
        this.maxSize = maxSize;
        this.map = Collections_jvmCommonKt.LruMutableMap$default(0, 0.0f, 3, null);
        if (!(this.maxSize > 0L)) {
            boolean bl = false;
            String string = "maxSize <= 0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final long getSize() {
        if (this.size == -1L) {
            this.size = this.recomputeSize();
        }
        return this.size;
    }

    @NotNull
    public final Set<K> getKeys() {
        return CollectionsKt.toSet((Iterable)this.map.keySet());
    }

    public long sizeOf(@NotNull K key, @NotNull V value) {
        return 1L;
    }

    public void entryRemoved(@NotNull K key, @NotNull V oldValue, @Nullable V newValue) {
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value) {
        V oldValue = this.map.put(key, value);
        this.size = this.getSize() + this.safeSizeOf(key, value);
        if (oldValue != null) {
            this.size = this.getSize() - this.safeSizeOf(key, oldValue);
            this.entryRemoved(key, oldValue, value);
        }
        this.trimToSize(this.maxSize);
        return oldValue;
    }

    @Nullable
    public final V get(@NotNull K key) {
        return this.map.get(key);
    }

    @Nullable
    public final V remove(@NotNull K key) {
        V oldValue = this.map.remove(key);
        if (oldValue != null) {
            this.size = this.getSize() - this.safeSizeOf(key, oldValue);
            this.entryRemoved(key, oldValue, null);
        }
        return oldValue;
    }

    public final void trimToSize(long size2) {
        while (this.getSize() > size2) {
            if (this.map.isEmpty()) {
                if (this.getSize() == 0L) break;
                throw new IllegalStateException("sizeOf() is returning inconsistent values".toString());
            }
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)this.map.entrySet());
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.map.remove(key);
            this.size = this.getSize() - this.safeSizeOf(key, value);
            this.entryRemoved(key, value, null);
        }
    }

    public final void clear() {
        this.trimToSize(-1L);
    }

    private final long recomputeSize() {
        Iterable iterable = this.map.entrySet();
        long l = 0L;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            long l2 = l;
            boolean bl = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            long l3 = this.safeSizeOf(key, value);
            l = l2 + l3;
        }
        return l;
    }

    private final long safeSizeOf(K key, V value) {
        try {
            long size2 = this.sizeOf(key, value);
            if (!(size2 >= 0L)) {
                boolean bl = false;
                String string = "sizeOf(" + key + ", " + value + ") returned a negative value: " + size2;
                throw new IllegalStateException(string.toString());
            }
            return size2;
        }
        catch (Exception e) {
            this.size = -1L;
            throw e;
        }
    }
}

