/*
 * Decompiled with CFR 0.152.
 */
package coil3;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import coil3.Image;
import coil3.util.Utils_androidKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Lcoil3/DrawableImage;", "Lcoil3/Image;", "drawable", "Landroid/graphics/drawable/Drawable;", "shareable", "", "<init>", "(Landroid/graphics/drawable/Drawable;Z)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "getShareable", "()Z", "size", "", "getSize", "()J", "width", "", "getWidth", "()I", "height", "getHeight", "draw", "", "canvas", "Landroid/graphics/Canvas;", "Lcoil3/Canvas;", "equals", "other", "", "hashCode", "toString", "", "SizeProvider", "coil-core_release"})
public final class DrawableImage
implements Image {
    @NotNull
    private final Drawable drawable;
    private final boolean shareable;

    public DrawableImage(@NotNull Drawable drawable, boolean shareable) {
        this.drawable = drawable;
        this.shareable = shareable;
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    @Override
    public boolean getShareable() {
        return this.shareable;
    }

    @Override
    public long getSize() {
        long size2 = this.drawable instanceof SizeProvider ? ((SizeProvider)this.drawable).getSize() : 4L * (long)Utils_androidKt.getWidth(this.drawable) * (long)Utils_androidKt.getHeight(this.drawable);
        return RangesKt.coerceAtLeast((long)size2, (long)0L);
    }

    @Override
    public int getWidth() {
        return Utils_androidKt.getWidth(this.drawable);
    }

    @Override
    public int getHeight() {
        return Utils_androidKt.getHeight(this.drawable);
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        this.drawable.draw(canvas);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawableImage)) {
            return false;
        }
        DrawableImage drawableImage = (DrawableImage)other;
        if (!Intrinsics.areEqual((Object)this.drawable, (Object)drawableImage.drawable)) {
            return false;
        }
        return this.shareable == drawableImage.shareable;
    }

    public int hashCode() {
        int result2 = this.drawable.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.shareable);
        return result2;
    }

    @NotNull
    public String toString() {
        return "DrawableImage(drawable=" + this.drawable + ", shareable=" + this.shareable + ')';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcoil3/DrawableImage$SizeProvider;", "", "size", "", "getSize", "()J", "coil-core_release"})
    public static interface SizeProvider {
        public long getSize();
    }
}

