/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.ImageDecoder;
import android.os.Build;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import androidx.annotation.RequiresApi;
import coil3.annotation.InternalCoilApi;
import coil3.decode.AssetMetadata;
import coil3.decode.ByteBufferMetadata;
import coil3.decode.ContentMetadata;
import coil3.decode.ImageSource;
import coil3.decode.ResourceMetadata;
import coil3.request.Options;
import java.io.File;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"toImageDecoderSourceOrNull", "Landroid/graphics/ImageDecoder$Source;", "Lcoil3/decode/ImageSource;", "options", "Lcoil3/request/Options;", "animated", "", "coil-core_release"})
public final class StaticImageDecoderKt {
    @InternalCoilApi
    @RequiresApi(value=28)
    @Nullable
    public static final ImageDecoder.Source toImageDecoderSourceOrNull(@NotNull ImageSource $this$toImageDecoderSourceOrNull, @NotNull Options options, boolean animated) {
        Path file;
        if ($this$toImageDecoderSourceOrNull.getFileSystem() == FileSystem.SYSTEM && (file = $this$toImageDecoderSourceOrNull.fileOrNull()) != null) {
            return ImageDecoder.createSource((File)file.toFile());
        }
        ImageSource.Metadata metadata = $this$toImageDecoderSourceOrNull.getMetadata();
        if (metadata instanceof AssetMetadata) {
            return ImageDecoder.createSource((AssetManager)options.getContext().getAssets(), (String)((AssetMetadata)metadata).getFilePath());
        }
        if (metadata instanceof ContentMetadata && Build.VERSION.SDK_INT >= 29) {
            try {
                AssetFileDescriptor asset = ((ContentMetadata)metadata).getAssetFileDescriptor();
                Os.lseek((FileDescriptor)asset.getFileDescriptor(), (long)asset.getStartOffset(), (int)OsConstants.SEEK_SET);
                return ImageDecoder.createSource(() -> StaticImageDecoderKt.toImageDecoderSourceOrNull$lambda$0(asset));
            }
            catch (ErrnoException errnoException) {}
        } else {
            if (metadata instanceof ResourceMetadata && Intrinsics.areEqual((Object)((ResourceMetadata)metadata).getPackageName(), (Object)options.getContext().getPackageName())) {
                return ImageDecoder.createSource((Resources)options.getContext().getResources(), (int)((ResourceMetadata)metadata).getResId());
            }
            if (metadata instanceof ByteBufferMetadata && (Build.VERSION.SDK_INT >= 30 || !animated || ((ByteBufferMetadata)metadata).getByteBuffer().isDirect())) {
                return ImageDecoder.createSource((ByteBuffer)((ByteBufferMetadata)metadata).getByteBuffer());
            }
        }
        return null;
    }

    private static final AssetFileDescriptor toImageDecoderSourceOrNull$lambda$0(AssetFileDescriptor $asset) {
        return $asset;
    }
}

