/*
 * Decompiled with CFR 0.152.
 */
package coil3.fetch;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import coil3.ImageLoader;
import coil3.Image_androidKt;
import coil3.Uri;
import coil3.UriKt;
import coil3.decode.DataSource;
import coil3.decode.ImageSourceKt;
import coil3.decode.ResourceMetadata;
import coil3.fetch.FetchResult;
import coil3.fetch.Fetcher;
import coil3.fetch.ImageFetchResult;
import coil3.fetch.SourceFetchResult;
import coil3.request.ImageRequests_androidKt;
import coil3.request.Options;
import coil3.size.Precision;
import coil3.util.ContextsKt;
import coil3.util.DrawableUtils;
import coil3.util.MimeTypeMap;
import coil3.util.Utils_androidKt;
import java.io.InputStream;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcoil3/fetch/ResourceUriFetcher;", "Lcoil3/fetch/Fetcher;", "data", "Lcoil3/Uri;", "options", "Lcoil3/request/Options;", "<init>", "(Lcoil3/Uri;Lcoil3/request/Options;)V", "fetch", "Lcoil3/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwInvalidUriException", "", "Factory", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nResourceUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUriFetcher.kt\ncoil3/fetch/ResourceUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 bitmaps.kt\ncoil3/util/BitmapsKt\n+ 4 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n*L\n1#1,99:1\n1#2:100\n51#3:101\n27#4:102\n*S KotlinDebug\n*F\n+ 1 ResourceUriFetcher.kt\ncoil3/fetch/ResourceUriFetcher\n*L\n61#1:101\n61#1:102\n*E\n"})
public final class ResourceUriFetcher
implements Fetcher {
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;

    public ResourceUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        TypedValue typedValue2;
        String string;
        block9: {
            block8: {
                String string2;
                string = this.data.getAuthority();
                if (string == null) break block8;
                String it = string2 = string;
                boolean typedValue2 = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block9;
            }
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        String packageName = string;
        Object object = (String)CollectionsKt.lastOrNull(UriKt.getPathSegments(this.data));
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        int resId = (Integer)object;
        Context context = this.options.getContext();
        Resources resources = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? context.getResources() : context.getPackageManager().getResourcesForApplication(packageName);
        TypedValue $this$fetch_u24lambda_u241 = typedValue2 = new TypedValue();
        boolean bl = false;
        resources.getValue(resId, $this$fetch_u24lambda_u241, true);
        CharSequence path = typedValue2.string;
        String mimeType = MimeTypeMap.INSTANCE.getMimeTypeFromUrl(((Object)path).toString());
        if (Intrinsics.areEqual((Object)mimeType, (Object)"text/xml")) {
            Drawable drawable;
            Drawable drawable2 = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? ContextsKt.getDrawableCompat(context, resId) : ContextsKt.getXmlDrawableCompat(context, resources, resId);
            boolean isVector = Utils_androidKt.isVector(drawable2);
            if (isVector) {
                void $this$toDrawable$iv$iv;
                void $this$toDrawable$iv;
                Bitmap bitmap = DrawableUtils.INSTANCE.convertToBitmap(drawable2, ImageRequests_androidKt.getBitmapConfig(this.options), this.options.getSize(), this.options.getScale(), this.options.getPrecision() == Precision.INEXACT);
                Context context$iv = context;
                boolean $i$f$toDrawable = false;
                void var13_15 = $this$toDrawable$iv;
                Resources resources$iv$iv = context$iv.getResources();
                boolean $i$f$toDrawable2 = false;
                drawable = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
            } else {
                drawable = drawable2;
            }
            fetchResult = new ImageFetchResult(Image_androidKt.asImage(drawable), isVector, DataSource.DISK);
        } else {
            TypedValue typedValue3 = new TypedValue();
            InputStream inputStream = resources.openRawResource(resId, typedValue3);
            fetchResult = new SourceFetchResult(ImageSourceKt.ImageSource(Okio.buffer((Source)Okio.source((InputStream)inputStream)), this.options.getFileSystem(), new ResourceMetadata(packageName, resId, typedValue3.density)), mimeType, DataSource.DISK);
        }
        return fetchResult;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw new IllegalStateException("Invalid android.resource URI: " + data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lcoil3/fetch/ResourceUriFetcher$Factory;", "Lcoil3/fetch/Fetcher$Factory;", "Lcoil3/Uri;", "<init>", "()V", "create", "Lcoil3/fetch/Fetcher;", "data", "options", "Lcoil3/request/Options;", "imageLoader", "Lcoil3/ImageLoader;", "isApplicable", "", "coil-core_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ResourceUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
        }
    }
}

