/*
 * Decompiled with CFR 0.152.
 */
package coil3.request;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import coil3.ImageLoader;
import coil3.request.ImageRequest;
import coil3.request.RequestDelegate;
import coil3.request.ViewTargetRequestManagerKt;
import coil3.target.ViewTarget;
import coil3.util.LifecyclesKt;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcoil3/request/ViewTargetRequestDelegate;", "Lcoil3/request/RequestDelegate;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "imageLoader", "Lcoil3/ImageLoader;", "initialRequest", "Lcoil3/request/ImageRequest;", "target", "Lcoil3/target/ViewTarget;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "job", "Lkotlinx/coroutines/Job;", "<init>", "(Lcoil3/ImageLoader;Lcoil3/request/ImageRequest;Lcoil3/target/ViewTarget;Landroidx/lifecycle/Lifecycle;Lkotlinx/coroutines/Job;)V", "restart", "", "assertActive", "start", "awaitStarted", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "coil-core_release"})
public final class ViewTargetRequestDelegate
implements RequestDelegate,
DefaultLifecycleObserver {
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final ImageRequest initialRequest;
    @NotNull
    private final ViewTarget<?> target;
    @Nullable
    private final Lifecycle lifecycle;
    @NotNull
    private final Job job;

    public ViewTargetRequestDelegate(@NotNull ImageLoader imageLoader, @NotNull ImageRequest initialRequest, @NotNull ViewTarget<?> target2, @Nullable Lifecycle lifecycle, @NotNull Job job2) {
        this.imageLoader = imageLoader;
        this.initialRequest = initialRequest;
        this.target = target2;
        this.lifecycle = lifecycle;
        this.job = job2;
    }

    public final void restart() {
        this.imageLoader.enqueue(this.initialRequest);
    }

    @Override
    public void assertActive() {
        if (!this.target.getView().isAttachedToWindow()) {
            ViewTargetRequestManagerKt.getRequestManager(this.target.getView()).setRequest(this);
            throw new CancellationException("'ViewTarget.view' must be attached to a window.");
        }
    }

    @Override
    public void start() {
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle != null) {
            lifecycle.addObserver((LifecycleObserver)this);
        }
        if (this.target instanceof LifecycleObserver) {
            Lifecycle lifecycle2 = this.lifecycle;
            if (lifecycle2 != null) {
                LifecyclesKt.removeAndAddObserver(lifecycle2, (LifecycleObserver)this.target);
            }
        }
        ViewTargetRequestManagerKt.getRequestManager(this.target.getView()).setRequest(this);
    }

    @Override
    @Nullable
    public Object awaitStarted(@NotNull Continuation<? super Unit> $completion) {
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle != null) {
            Object object = LifecyclesKt.awaitStarted(lifecycle, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void dispose() {
        block2: {
            Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
            if (this.target instanceof LifecycleObserver) {
                Lifecycle lifecycle = this.lifecycle;
                if (lifecycle != null) {
                    lifecycle.removeObserver((LifecycleObserver)this.target);
                }
            }
            Lifecycle lifecycle = this.lifecycle;
            if (lifecycle == null) break block2;
            lifecycle.removeObserver((LifecycleObserver)this);
        }
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        ViewTargetRequestManagerKt.getRequestManager(this.target.getView()).dispose();
    }
}

