/*
 * Decompiled with CFR 0.152.
 */
package coil3.transform;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import coil3.decode.DecodeUtils;
import coil3.size.Scale;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"newScaledShaderPaint", "Landroid/graphics/Paint;", "input", "Landroid/graphics/Bitmap;", "outputWidth", "", "outputHeight", "coil-core_release"})
public final class TransformationsKt {
    @NotNull
    public static final Paint newScaledShaderPaint(@NotNull Bitmap input, int outputWidth, int outputHeight) {
        Matrix matrix = new Matrix();
        float multiplier = (float)DecodeUtils.computeSizeMultiplier(input.getWidth(), input.getHeight(), outputWidth, outputHeight, Scale.FILL);
        float dx = ((float)outputWidth - multiplier * (float)input.getWidth()) / (float)2;
        float dy = ((float)outputHeight - multiplier * (float)input.getHeight()) / (float)2;
        matrix.setTranslate(dx, dy);
        matrix.preScale(multiplier, multiplier);
        Paint paint = new Paint(3);
        BitmapShader shader = new BitmapShader(input, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        shader.setLocalMatrix(matrix);
        paint.setShader((Shader)shader);
        return paint;
    }
}

