/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compiler.generator;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSDeclaration;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.compiler.generator.DefinitionWriterFactory;
import org.koin.compiler.generator.TemplatesKt;
import org.koin.compiler.generator.ext.CodeGeneratorExtKt;
import org.koin.compiler.generator.ext.UtilsKt;
import org.koin.compiler.metadata.AnnotationMetadataKt;
import org.koin.compiler.metadata.DefinitionAnnotation;
import org.koin.compiler.metadata.KoinMetaData;
import org.koin.compiler.scanner.ext.KspExtKt;
import org.koin.compiler.type.BlockedTypesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 F2\u00020\u0001:\u0001FB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0004J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0004J\b\u0010!\u001a\u00020\u001eH\u0004J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00152\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0016\u0010+\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\b\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020\u001eH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0015H\u0016J\u001e\u0010/\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u0002010)2\u0006\u0010'\u001a\u00020\u0015H\u0002J\b\u00102\u001a\u00020\u001eH\u0016J\b\u00103\u001a\u00020\u001eH\u0016J\b\u00104\u001a\u00020\u001eH\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u00106\u001a\u00020\u001eH\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u00108\u001a\u00020\u001eH\u0016J\u001e\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002010)H\u0016J\u0015\u0010=\u001a\u00020\u00112\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u00020\u0011H\u0002J\b\u0010@\u001a\u00020\u001eH\u0016J\b\u0010A\u001a\u00020\u0011H\u0002J\b\u0010B\u001a\u00020\u001eH\u0002J\u0012\u0010C\u001a\u00020\u001e2\b\b\u0002\u0010D\u001a\u00020\u0015H\u0016J\b\u0010E\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/koin/compiler/generator/ModuleWriter;", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "module", "Lorg/koin/compiler/metadata/KoinMetaData$Module;", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/Resolver;Lorg/koin/compiler/metadata/KoinMetaData$Module;)V", "getCodeGenerator", "()Lcom/google/devtools/ksp/processing/CodeGenerator;", "getResolver", "()Lcom/google/devtools/ksp/processing/Resolver;", "getModule", "()Lorg/koin/compiler/metadata/KoinMetaData$Module;", "fileName", "", "getFileName", "()Ljava/lang/String;", "hasExternalDefinitions", "", "getHasExternalDefinitions", "()Z", "generateModuleBody", "getGenerateModuleBody", "createFileStream", "Ljava/io/OutputStream;", "fileStream", "write", "", "s", "writeln", "writeEmptyLine", "definitionFactory", "Lorg/koin/compiler/generator/DefinitionWriterFactory;", "modulePath", "generatedField", "writeModule", "isViewModelMPActive", "generateIncludeModules", "", "Lorg/koin/compiler/metadata/KoinMetaData$ModuleInclude;", "writeGeneratedIncludeModule", "writeExternalDefinitionImports", "writeHeader", "writeHeaderImports", "generateImports", "definitions", "Lorg/koin/compiler/metadata/KoinMetaData$Definition;", "writeExternalDefinitions", "writeModuleFunction", "writeModuleInstance", "generateModuleField", "writeModuleIncludes", "generateIncludes", "writeDefinitions", "writeScope", "scope", "Lorg/koin/compiler/metadata/KoinMetaData$Scope;", "scopeDefinitions", "generateScopeHeader", "generateScopeHeader$koin_ksp_compiler", "generateScopeFooter", "writeExternalDefinitionCalls", "generateExternalDefinitionCalls", "writeModuleFooterWarning", "writeModuleFooter", "closeBrackets", "onFinishWriteModule", "Companion", "koin-ksp-compiler"})
@SourceDebugExtension(value={"SMAP\nModuleWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleWriter.kt\norg/koin/compiler/generator/ModuleWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n1863#2,2:251\n1557#2:253\n1628#2,3:254\n1611#2,9:257\n1863#2:266\n1864#2:269\n1620#2:270\n774#2:271\n865#2,2:272\n1863#2,2:274\n1755#2,3:276\n3193#2,10:279\n1863#2,2:289\n1485#2:291\n1510#2,3:292\n1513#2,3:302\n1863#2,2:307\n1#3:267\n1#3:268\n381#4,7:295\n216#5,2:305\n*S KotlinDebug\n*F\n+ 1 ModuleWriter.kt\norg/koin/compiler/generator/ModuleWriter\n*L\n92#1:251,2\n117#1:253\n117#1:254,3\n119#1:257,9\n119#1:266\n119#1:269\n119#1:270\n131#1:271\n131#1:272,2\n132#1:274,2\n145#1:276,3\n177#1:279,10\n179#1:289,2\n182#1:291\n182#1:292,3\n182#1:302,3\n193#1:307,2\n119#1:268\n182#1:295,7\n183#1:305,2\n*E\n"})
public abstract class ModuleWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final KoinMetaData.Module module;
    private final boolean hasExternalDefinitions;
    private final boolean generateModuleBody;
    @Nullable
    private OutputStream fileStream;
    private DefinitionWriterFactory definitionFactory;
    @NotNull
    private final String modulePath;
    @NotNull
    private final String generatedField;
    @NotNull
    private static final String MODULE_INSTANCE = "moduleInstance";

    public ModuleWriter(@NotNull CodeGenerator codeGenerator, @NotNull Resolver resolver, @NotNull KoinMetaData.Module module) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.codeGenerator = codeGenerator;
        this.resolver = resolver;
        this.module = module;
        this.generateModuleBody = true;
        this.modulePath = ((CharSequence)this.module.getPackageName()).length() == 0 ? this.module.getName() : this.module.getPackageName() + '.' + this.module.getName();
        this.generatedField = BlockedTypesKt.clearPackageSymbols(this.module.packageName("_")) + '_' + this.module.getName();
    }

    @NotNull
    public final CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NotNull
    public final Resolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public final KoinMetaData.Module getModule() {
        return this.module;
    }

    @NotNull
    public abstract String getFileName();

    public boolean getHasExternalDefinitions() {
        return this.hasExternalDefinitions;
    }

    public boolean getGenerateModuleBody() {
        return this.generateModuleBody;
    }

    private final OutputStream createFileStream() {
        return CodeGeneratorExtKt.getNewFile$default(this.codeGenerator, null, this.getFileName(), 1, null);
    }

    protected final void write(@NotNull String s) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            OutputStream outputStream = this.fileStream;
            if (outputStream == null) break block0;
            UtilsKt.appendText(outputStream, s);
        }
    }

    protected final void writeln(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.write(s + '\n');
    }

    protected final void writeEmptyLine() {
        this.writeln("");
    }

    public final void writeModule(boolean isViewModelMPActive, @NotNull List<KoinMetaData.ModuleInclude> generateIncludeModules) {
        Intrinsics.checkNotNullParameter(generateIncludeModules, (String)"generateIncludeModules");
        OutputStream outputStream = this.fileStream = this.createFileStream();
        Intrinsics.checkNotNull((Object)outputStream);
        this.definitionFactory = new DefinitionWriterFactory(this.resolver, outputStream);
        this.writeHeader();
        this.writeHeaderImports(isViewModelMPActive);
        if (!((Collection)generateIncludeModules).isEmpty()) {
            this.writeGeneratedIncludeModule(generateIncludeModules);
        }
        if (this.getHasExternalDefinitions()) {
            this.writeExternalDefinitionImports();
            this.writeExternalDefinitions();
        }
        this.writeEmptyLine();
        if (this.module.isExpect()) {
            this.writeModuleFooter(false);
        } else if (this.getGenerateModuleBody()) {
            this.writeModuleFunction();
            this.writeModuleInstance();
            this.writeModuleIncludes();
            if (!this.getHasExternalDefinitions()) {
                this.writeDefinitions();
            }
            this.writeExternalDefinitionCalls();
            ModuleWriter.writeModuleFooter$default(this, false, 1, null);
        } else if (!this.getGenerateModuleBody()) {
            this.writeModuleFooterWarning();
        }
        this.onFinishWriteModule();
    }

    public static /* synthetic */ void writeModule$default(ModuleWriter moduleWriter, boolean bl, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeModule");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        moduleWriter.writeModule(bl, list);
    }

    private final void writeGeneratedIncludeModule(List<KoinMetaData.ModuleInclude> generateIncludeModules) {
        Iterable $this$forEach$iv = generateIncludeModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.ModuleInclude module = (KoinMetaData.ModuleInclude)element$iv;
            boolean bl = false;
            this.writeln("public class " + module.getClassName());
        }
        this.writeEmptyLine();
    }

    private final void writeExternalDefinitionImports() {
        this.writeln("import org.koin.meta.annotations.ExternalDefinition\nimport org.koin.core.definition.KoinDefinition");
    }

    public void writeHeader() {
        this.writeln(TemplatesKt.getMODULE_HEADER());
    }

    public void writeHeaderImports(boolean isViewModelMPActive) {
        this.writeln(this.generateImports(this.module.getDefinitions(), isViewModelMPActive));
    }

    /*
     * WARNING - void declaration
     */
    private final String generateImports(List<? extends KoinMetaData.Definition> definitions, boolean isViewModelMPActive) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void definition;
            object = (KoinMetaData.Definition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(definition.getKeyword());
        }
        Iterable $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            DefinitionAnnotation keyword = (DefinitionAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (isViewModelMPActive && Intrinsics.areEqual((Object)keyword, (Object)AnnotationMetadataKt.getKOIN_VIEWMODEL_ANDROID())) {
                String it = AnnotationMetadataKt.getKOIN_VIEWMODEL_MP().getImport();
                boolean bl3 = false;
                string = "import " + it;
            } else if (keyword.getImport() != null) {
                String it;
                boolean bl4 = false;
                string = "import " + it;
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExternalDefinitions() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.module.getDefinitions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KoinMetaData.Definition it = (KoinMetaData.Definition)element$iv$iv;
            boolean bl = false;
            if (!it.isNotScoped()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List standardDefinitions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = standardDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.Definition it = (KoinMetaData.Definition)element$iv;
            boolean bl = false;
            DefinitionWriterFactory definitionWriterFactory = this.definitionFactory;
            if (definitionWriterFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"definitionFactory");
                definitionWriterFactory = null;
            }
            definitionWriterFactory.writeDefinition(it, this.module, true);
        }
    }

    public void writeModuleFunction() {
        this.writeln(this.generateModuleField(this.module));
    }

    public void writeModuleInstance() {
        boolean needModuleInstance;
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.module.getDefinitions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KoinMetaData.Definition it = (KoinMetaData.Definition)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof KoinMetaData.Definition.FunctionDefinition && ((KoinMetaData.Definition.FunctionDefinition)it).isClassFunction())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl3 = needModuleInstance = bl && !this.module.getType().isObject();
        if (needModuleInstance) {
            this.writeln("\tval " + MODULE_INSTANCE + " = " + this.modulePath + "()");
        }
    }

    private final String generateModuleField(KoinMetaData.Module module) {
        KoinMetaData.Module $this$generateModuleField_u24lambda_u248 = module;
        boolean bl = false;
        String visibilityString = UtilsKt.toSourceString($this$generateModuleField_u24lambda_u248.getVisibility());
        String createdAtStartString = $this$generateModuleField_u24lambda_u248.isCreatedAtStart() != null && $this$generateModuleField_u24lambda_u248.isCreatedAtStart() != false ? "(createdAtStart=true)" : "";
        return visibilityString + "val " + this.generatedField + " : Module get() = module" + createdAtStartString + " {";
    }

    public void writeModuleIncludes() {
        block1: {
            List<KoinMetaData.ModuleInclude> list = this.module.getIncludes();
            boolean bl = list != null ? !((Collection)list).isEmpty() : false;
            if (!bl) break block1;
            String string = this.generateIncludes();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                this.writeln("\tincludes(" + it + ')');
            }
        }
    }

    private final String generateIncludes() {
        List<KoinMetaData.ModuleInclude> list = this.module.getIncludes();
        return list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, ModuleWriter::generateIncludes$lambda$10, (int)30, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    public void writeDefinitions() {
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        KoinMetaData.Definition it;
        Iterable $this$partition$iv = this.module.getDefinitions();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (KoinMetaData.Definition)element$iv;
            boolean bl = false;
            if (it.isNotScoped()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List standardDefinitions = (List)pair.component1();
        List scopeDefinitions = (List)pair.component2();
        Iterable $this$forEach$iv = standardDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KoinMetaData.Definition)element$iv;
            boolean bl = false;
            DefinitionWriterFactory definitionWriterFactory = this.definitionFactory;
            if (definitionWriterFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"definitionFactory");
                definitionWriterFactory = null;
            }
            DefinitionWriterFactory.writeDefinition$default(definitionWriterFactory, it, this.module, null, 4, null);
        }
        $this$forEach$iv = scopeDefinitions;
        boolean $i$f$groupBy = false;
        Iterator<Object> iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KoinMetaData.Definition it2 = (KoinMetaData.Definition)element$iv$iv;
            boolean bl = false;
            KoinMetaData.Scope key$iv$iv = it2.getScope();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            KoinMetaData.Scope scope = (KoinMetaData.Scope)object.getKey();
            List scopeDefinitions2 = (List)object.getValue();
            if (scope == null) continue;
            boolean bl3 = false;
            this.writeScope(scope, scopeDefinitions2);
        }
    }

    public void writeScope(@NotNull KoinMetaData.Scope scope, @NotNull List<? extends KoinMetaData.Definition> scopeDefinitions) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(scopeDefinitions, (String)"scopeDefinitions");
        this.writeln(this.generateScopeHeader$koin_ksp_compiler(scope));
        Iterable $this$forEach$iv = scopeDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.Definition it = (KoinMetaData.Definition)element$iv;
            boolean bl = false;
            DefinitionWriterFactory definitionWriterFactory = this.definitionFactory;
            if (definitionWriterFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"definitionFactory");
                definitionWriterFactory = null;
            }
            DefinitionWriterFactory.writeDefinition$default(definitionWriterFactory, it, this.module, null, 4, null);
        }
        this.writeln(this.generateScopeFooter());
    }

    @NotNull
    public final String generateScopeHeader$koin_ksp_compiler(@NotNull KoinMetaData.Scope scope) {
        String string;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        KoinMetaData.Scope scope2 = scope;
        if (scope2 instanceof KoinMetaData.Scope.ClassScope) {
            KSDeclaration type = ((KoinMetaData.Scope.ClassScope)scope).getType();
            String packageName = KspExtKt.filterForbiddenKeywords(type.getPackageName().asString());
            String className = type.getSimpleName().asString();
            string = "\tscope<" + packageName + '.' + className + "> {";
        } else if (scope2 instanceof KoinMetaData.Scope.StringScope) {
            string = "\tscope(org.koin.core.qualifier.StringQualifier(\"" + ((KoinMetaData.Scope.StringScope)scope).getName() + "\")) {";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String generateScopeFooter() {
        return "\t}";
    }

    public void writeExternalDefinitionCalls() {
        if (!((Collection)this.module.getExternalDefinitions()).isEmpty()) {
            this.writeln('\t' + this.generateExternalDefinitionCalls());
        }
    }

    private final String generateExternalDefinitionCalls() {
        return CollectionsKt.joinToString$default((Iterable)this.module.getExternalDefinitions(), (CharSequence)"\n\t", null, null, (int)0, null, ModuleWriter::generateExternalDefinitionCalls$lambda$17, (int)30, null);
    }

    private final void writeModuleFooterWarning() {
        this.writeln("//DefaultModule generation is disabled. Use arg(\"KOIN_DEFAULT_MODULE\",\"true\") KSP option to activate DefaultModule generation.");
    }

    public void writeModuleFooter(boolean closeBrackets) {
        if (closeBrackets) {
            this.writeln(TemplatesKt.getMODULE_FOOTER());
        }
        String visibilityString = UtilsKt.toSourceString(this.module.getVisibility());
        String actualKeyword = this.module.isActual() ? "actual " : (this.module.isExpect() ? "expect " : "");
        String returnedValue = !this.module.isExpect() ? " get() = " + this.generatedField : "";
        this.writeln(actualKeyword + visibilityString + "val " + this.modulePath + ".module : org.koin.core.module.Module" + returnedValue);
    }

    public static /* synthetic */ void writeModuleFooter$default(ModuleWriter moduleWriter, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeModuleFooter");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        moduleWriter.writeModuleFooter(bl);
    }

    public void onFinishWriteModule() {
        block0: {
            OutputStream outputStream;
            OutputStream outputStream2 = this.fileStream;
            if (outputStream2 == null) break block0;
            OutputStream $this$onFinishWriteModule_u24lambda_u2418 = outputStream = outputStream2;
            boolean bl = false;
            $this$onFinishWriteModule_u24lambda_u2418.flush();
            $this$onFinishWriteModule_u24lambda_u2418.close();
        }
    }

    private static final CharSequence generateIncludes$lambda$10(KoinMetaData.ModuleInclude it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it.getPackageName()).length() == 0 ? (CharSequence)(it.getClassName() + "().module") : (CharSequence)(it.getPackageName() + '.' + it.getClassName() + "().module");
    }

    private static final CharSequence generateExternalDefinitionCalls$lambda$17(KoinMetaData.ExternalDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + "()";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/koin/compiler/generator/ModuleWriter$Companion;", "", "<init>", "()V", "MODULE_INSTANCE", "", "getMODULE_INSTANCE", "()Ljava/lang/String;", "koin-ksp-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMODULE_INSTANCE() {
            return MODULE_INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

