/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compiler.metadata;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.compiler.generator.ext.CodeGeneratorExtKt;
import org.koin.compiler.generator.ext.UtilsKt;
import org.koin.compiler.metadata.KoinMetaData;
import org.koin.compiler.metadata.MetaAnnotationFactory;
import org.koin.compiler.metadata.TagFactory;
import org.koin.compiler.resolver.ResolverExtKt;
import org.koin.compiler.type.TypeWhiteListKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020 J\u001e\u0010\"\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020 H\u0002J\u0016\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0016\u0010%\u001a\u00020\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001fH\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020 H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020'H\u0002J\u0018\u00103\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020'2\u0006\u00104\u001a\u000200H\u0002J\u001a\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u00152\b\b\u0002\u00107\u001a\u00020\tH\u0002J\u0010\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0015H\u0002J\b\u0010:\u001a\u00020\u001dH\u0002J\u0018\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006>"}, d2={"Lorg/koin/compiler/metadata/KoinTagWriter;", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "isConfigCheckActive", "", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;Lcom/google/devtools/ksp/processing/Resolver;Z)V", "getCodeGenerator", "()Lcom/google/devtools/ksp/processing/CodeGenerator;", "getLogger", "()Lcom/google/devtools/ksp/processing/KSPLogger;", "getResolver", "()Lcom/google/devtools/ksp/processing/Resolver;", "()Z", "alreadyDeclaredTags", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "_tagFileStream", "Ljava/io/OutputStream;", "fileStream", "getFileStream", "()Ljava/io/OutputStream;", "writeAllTags", "", "moduleList", "", "Lorg/koin/compiler/metadata/KoinMetaData$Module;", "default", "createTagsForModules", "writeModuleTags", "allModules", "writeDefinitionsTags", "allDefinitions", "Lorg/koin/compiler/metadata/KoinMetaData$Definition;", "writeTagFile", "tagFileName", "writeModuleTag", "module", "writeDefinitionAndBindingsTags", "def", "writeScopeTag", "scope", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "writeDefinitionTag", "definition", "writeBindingTag", "binding", "writeTag", "tag", "asProperty", "writeMeta", "meta", "writeImports", "prepareTagLine", "tagName", "asFunction", "koin-ksp-compiler"})
@SourceDebugExtension(value={"SMAP\nKoinTagWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoinTagWriter.kt\norg/koin/compiler/metadata/KoinTagWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1368#2:199\n1454#2,5:200\n1863#2,2:206\n1863#2,2:208\n1863#2,2:210\n1#3:205\n*S KotlinDebug\n*F\n+ 1 KoinTagWriter.kt\norg/koin/compiler/metadata/KoinTagWriter\n*L\n58#1:199\n58#1:200,5\n77#1:206,2\n83#1:208,2\n115#1:210,2\n*E\n"})
public final class KoinTagWriter {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final Resolver resolver;
    private final boolean isConfigCheckActive;
    @NotNull
    private final ArrayList<String> alreadyDeclaredTags;
    @Nullable
    private OutputStream _tagFileStream;

    public KoinTagWriter(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger, @NotNull Resolver resolver, boolean isConfigCheckActive) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
        this.resolver = resolver;
        this.isConfigCheckActive = isConfigCheckActive;
        this.alreadyDeclaredTags = new ArrayList();
    }

    @NotNull
    public final CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NotNull
    public final KSPLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Resolver getResolver() {
        return this.resolver;
    }

    public final boolean isConfigCheckActive() {
        return this.isConfigCheckActive;
    }

    private final OutputStream getFileStream() {
        OutputStream outputStream = this._tagFileStream;
        if (outputStream == null) {
            throw new IllegalStateException("KoinTagWriter - tagFileStream is null".toString());
        }
        return outputStream;
    }

    public final void writeAllTags(@NotNull List<KoinMetaData.Module> moduleList, @NotNull KoinMetaData.Module module) {
        Intrinsics.checkNotNullParameter(moduleList, (String)"moduleList");
        Intrinsics.checkNotNullParameter((Object)module, (String)"default");
        boolean isAlreadyGenerated = this.codeGenerator.getGeneratedFile().isEmpty();
        if (!isAlreadyGenerated) {
            KSPLogger.logging$default((KSPLogger)this.logger, (String)"Koin Tags Generation ...", null, (int)2, null);
            this.createTagsForModules(moduleList, module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTagsForModules(List<KoinMetaData.Module> moduleList, KoinMetaData.Module module) {
        Closeable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)moduleList, (Object)module);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            KoinMetaData.Module it = (KoinMetaData.Module)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDefinitions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allDefinitions = (List)destination$iv$iv;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile("KoinMeta", ".kt", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path tempFile = path;
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(tempFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        $this$flatMapTo$iv$iv = new DigestOutputStream(outputStream, sha256);
        int n = 8192;
        $this$flatMapTo$iv$iv = $this$flatMapTo$iv$iv instanceof BufferedOutputStream ? (BufferedOutputStream)$this$flatMapTo$iv$iv : new BufferedOutputStream((OutputStream)$this$flatMapTo$iv$iv, n);
        Object object = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)$this$flatMapTo$iv$iv;
            boolean bl = false;
            this._tagFileStream = it;
            if (this.isConfigCheckActive) {
                this.writeImports();
            }
            this.writeModuleTags(moduleList);
            this.writeDefinitionsTags(allDefinitions);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$flatMapTo$iv$iv, (Throwable)object);
        }
        StringBuilder stringBuilder = new StringBuilder().append("KoinMeta-");
        byte[] byArray = sha256.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        String tagFileName = stringBuilder.append(StringsKt.take((String)HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)HexFormat.Companion.getDefault()), (int)8)).toString();
        object = this.writeTagFile(tagFileName);
        int n2 = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n2);
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)object;
            boolean bl = false;
            long l = Files.copy(tempFile, it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void writeModuleTags(List<KoinMetaData.Module> allModules) {
        Iterable $this$forEach$iv = allModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.Module m = (KoinMetaData.Module)element$iv;
            boolean bl = false;
            this.writeModuleTag(m);
        }
    }

    private final void writeDefinitionsTags(List<? extends KoinMetaData.Definition> allDefinitions) {
        Iterable $this$forEach$iv = allDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.Definition def = (KoinMetaData.Definition)element$iv;
            boolean bl = false;
            this.writeDefinitionAndBindingsTags(def);
        }
    }

    private final OutputStream writeTagFile(String tagFileName) {
        OutputStream fileStream = CodeGeneratorExtKt.getNewFile$default(this.codeGenerator, null, tagFileName, 1, null);
        UtilsKt.appendText(fileStream, "package org.koin.ksp.generated\n");
        return fileStream;
    }

    private final void writeModuleTag(KoinMetaData.Module module) {
        String tag;
        if (module.getAlreadyGenerated() == null) {
            module.setAlreadyGenerated(ResolverExtKt.tagAlreadyExists(this.resolver, module));
        }
        if (Intrinsics.areEqual((Object)module.getAlreadyGenerated(), (Object)false) && !this.alreadyDeclaredTags.contains(tag = TagFactory.INSTANCE.getTagClass(module))) {
            if (this.isConfigCheckActive) {
                String metaLine = MetaAnnotationFactory.INSTANCE.generate(module);
                this.writeMeta(metaLine);
            }
            KoinTagWriter.writeTag$default(this, tag, false, 2, null);
        }
    }

    private final void writeDefinitionAndBindingsTags(KoinMetaData.Definition def) {
        this.writeDefinitionTag(def);
        Iterable $this$forEach$iv = def.getBindings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSDeclaration it = (KSDeclaration)element$iv;
            boolean bl = false;
            this.writeBindingTag(def, it);
        }
        if (def.isScoped() && def.getScope() instanceof KoinMetaData.Scope.ClassScope) {
            this.writeScopeTag(((KoinMetaData.Scope.ClassScope)def.getScope()).getType());
        }
    }

    private final void writeScopeTag(KSDeclaration scope) {
        String scopeName;
        KSName kSName = scope.getQualifiedName();
        String string = scopeName = kSName != null ? kSName.asString() : null;
        if (!CollectionsKt.contains((Iterable)TypeWhiteListKt.getFullWhiteList(), (Object)scopeName)) {
            String tag = TagFactory.INSTANCE.getTagClass(scope);
            boolean alreadyGenerated = ResolverExtKt.tagPropAlreadyExists(this.resolver, tag);
            if (!this.alreadyDeclaredTags.contains(tag) && !alreadyGenerated) {
                this.writeTag(tag, true);
            }
        }
    }

    private final void writeDefinitionTag(KoinMetaData.Definition definition) {
        String tag;
        if (definition.getAlreadyGenerated() == null) {
            definition.setAlreadyGenerated(ResolverExtKt.tagAlreadyExists(this.resolver, definition));
        }
        if (Intrinsics.areEqual((Object)definition.getAlreadyGenerated(), (Object)false) && !this.alreadyDeclaredTags.contains(tag = TagFactory.INSTANCE.getTagClass(definition))) {
            if (this.isConfigCheckActive) {
                String metaLine = MetaAnnotationFactory.INSTANCE.generate(definition);
                this.writeMeta(metaLine);
            }
            KoinTagWriter.writeTag$default(this, tag, false, 2, null);
        }
    }

    private final void writeBindingTag(KoinMetaData.Definition def, KSDeclaration binding) {
        String name;
        KSName kSName = binding.getQualifiedName();
        String string = name = kSName != null ? kSName.asString() : null;
        if (!CollectionsKt.contains((Iterable)TypeWhiteListKt.getFullWhiteList(), (Object)name)) {
            String tag = TagFactory.INSTANCE.getTagClass(def, binding);
            boolean alreadyGenerated = ResolverExtKt.tagPropAlreadyExists(this.resolver, tag);
            if (!this.alreadyDeclaredTags.contains(tag) && !alreadyGenerated) {
                this.writeTag(tag, true);
            }
        }
    }

    private final void writeTag(String tag, boolean asProperty) {
        String line = this.prepareTagLine(tag, asProperty);
        UtilsKt.appendText(this.getFileStream(), line);
        this.alreadyDeclaredTags.add(tag);
    }

    static /* synthetic */ void writeTag$default(KoinTagWriter koinTagWriter, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        koinTagWriter.writeTag(string, bl);
    }

    private final void writeMeta(String meta) {
        UtilsKt.appendText(this.getFileStream(), '\n' + meta);
    }

    private final void writeImports() {
        UtilsKt.appendText(this.getFileStream(), "\nimport org.koin.meta.annotations.MetaDefinition\nimport org.koin.meta.annotations.MetaModule");
    }

    private final String prepareTagLine(String tagName, boolean asFunction) {
        return asFunction ? "\npublic fun _KSP_" + tagName + "() : Unit = Unit" : "\npublic class _KSP_" + tagName;
    }
}

