/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.android;

import android.os.AsyncTask;
import android.util.ArraySet;
import io.mockk.proxy.MockKInvocationHandler;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AndroidMockKMap
extends ReferenceQueue<Object>
implements Map<Object, MockKInvocationHandler> {
    private static final int MIN_CLEAN_INTERVAL_MILLIS = 16000;
    private static final int MAX_GET_WITHOUT_CLEAN = 16384;
    private final Object lock = new Object();
    private StrongKey cachedKey;
    private HashMap<WeakKey, MockKInvocationHandler> adapters = new HashMap();
    private long mLastCleanup = 0L;
    private boolean isCleaning = false;
    private int getCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StrongKey createStrongKey(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cachedKey == null) {
                this.cachedKey = new StrongKey();
            }
            this.cachedKey.obj = obj;
            StrongKey newKey = this.cachedKey;
            this.cachedKey = null;
            return newKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleStrongKey(StrongKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.cachedKey = key;
        }
    }

    @Override
    public int size() {
        return this.adapters.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapters.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object mock) {
        Object object = this.lock;
        synchronized (object) {
            StrongKey key = this.createStrongKey(mock);
            boolean containsKey = this.adapters.containsKey(key);
            this.recycleStrongKey(key);
            return containsKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object adapter) {
        Object object = this.lock;
        synchronized (object) {
            return this.adapters.containsValue(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MockKInvocationHandler get(Object mock) {
        Object object = this.lock;
        synchronized (object) {
            if (this.getCount > 16384) {
                this.cleanStaleReferences();
                this.getCount = 0;
            } else {
                ++this.getCount;
            }
            StrongKey key = this.createStrongKey(mock);
            MockKInvocationHandler adapter = this.adapters.get(key);
            this.recycleStrongKey(key);
            return adapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanStaleReferences() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCleaning) {
                return;
            }
            if (System.currentTimeMillis() - 16000L < this.mLastCleanup) {
                return;
            }
            this.isCleaning = true;
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AndroidMockKMap.this.lock;
                    synchronized (object) {
                        Reference ref;
                        while ((ref = AndroidMockKMap.this.poll()) != null) {
                            AndroidMockKMap.this.adapters.remove(ref);
                        }
                        AndroidMockKMap.this.mLastCleanup = System.currentTimeMillis();
                        AndroidMockKMap.this.isCleaning = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MockKInvocationHandler put(Object mock, MockKInvocationHandler adapter) {
        Object object = this.lock;
        synchronized (object) {
            MockKInvocationHandler oldValue = this.remove(mock);
            this.adapters.put(new WeakKey(mock), adapter);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MockKInvocationHandler remove(Object mock) {
        Object object = this.lock;
        synchronized (object) {
            StrongKey key = this.createStrongKey(mock);
            MockKInvocationHandler adapter = this.adapters.remove(key);
            this.recycleStrongKey(key);
            return adapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<?, ? extends MockKInvocationHandler> map) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<?, MockKInvocationHandler> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.adapters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> keySet() {
        Object object = this.lock;
        synchronized (object) {
            ArraySet mocks = new ArraySet(this.adapters.size());
            boolean hasStaleReferences = false;
            for (WeakKey key : this.adapters.keySet()) {
                Object mock = key.get();
                if (mock == null) {
                    hasStaleReferences = true;
                    continue;
                }
                mocks.add(mock);
            }
            if (hasStaleReferences) {
                this.cleanStaleReferences();
            }
            return mocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MockKInvocationHandler> values() {
        Object object = this.lock;
        synchronized (object) {
            return this.adapters.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<Object, MockKInvocationHandler>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            ArraySet entries = new ArraySet(this.adapters.size());
            boolean hasStaleReferences = false;
            for (Map.Entry<WeakKey, MockKInvocationHandler> entry : this.adapters.entrySet()) {
                Object mock = entry.getKey().get();
                if (mock == null) {
                    hasStaleReferences = true;
                    continue;
                }
                entries.add(new AbstractMap.SimpleEntry(mock, entry.getValue()));
            }
            if (hasStaleReferences) {
                this.cleanStaleReferences();
            }
            return entries;
        }
    }

    public boolean isInternalHashMap(@NotNull Object instance) {
        return this.adapters == instance || this == instance;
    }

    private class StrongKey {
        private Object obj;

        private StrongKey() {
        }

        public boolean equals(Object other) {
            if (other instanceof WeakKey) {
                Object otherObj = ((WeakKey)other).get();
                if (otherObj == null) {
                    AndroidMockKMap.this.cleanStaleReferences();
                    return false;
                }
                return this.obj == otherObj;
            }
            if (other instanceof StrongKey) {
                return this.obj == ((StrongKey)other).obj;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }

    private class WeakKey
    extends WeakReference<Object> {
        private final int hashCode;

        private WeakKey(Object obj) {
            super(obj, AndroidMockKMap.this);
            this.hashCode = System.identityHashCode(obj);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.hashCode() != this.hashCode) {
                return false;
            }
            Object obj = this.get();
            if (obj == null) {
                AndroidMockKMap.this.cleanStaleReferences();
                return false;
            }
            if (other instanceof WeakKey) {
                Object otherObj = ((WeakKey)other).get();
                if (otherObj == null) {
                    AndroidMockKMap.this.cleanStaleReferences();
                    return false;
                }
                return obj == otherObj;
            }
            if (other instanceof StrongKey) {
                Object otherObj = ((StrongKey)other).obj;
                return obj == otherObj;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

