/*
 * Decompiled with CFR 0.152.
 */
package io.mockk;

import io.mockk.MockKSettingsKt;
import io.mockk.StackTracesAlignment;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001d"}, d2={"Lio/mockk/MockKSettings;", "", "()V", "properties", "Ljava/util/Properties;", "recordPrivateCalls", "", "getRecordPrivateCalls", "()Z", "relaxUnitFun", "getRelaxUnitFun", "relaxed", "getRelaxed", "stackTracesAlignment", "Lio/mockk/StackTracesAlignment;", "getStackTracesAlignment", "()Lio/mockk/StackTracesAlignment;", "stackTracesOnVerify", "getStackTracesOnVerify", "booleanProperty", "property", "", "defaultValue", "setRecordPrivateCalls", "", "value", "setRelaxUnitFun", "setRelaxed", "setStackTracesAlignment", "mockk-dsl-jvm"})
public final class MockKSettings {
    private static final Properties properties;
    public static final MockKSettings INSTANCE;

    private final boolean booleanProperty(String property, String defaultValue) {
        String string = properties.getProperty(property, defaultValue);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        boolean bl = false;
        return Boolean.parseBoolean(string2);
    }

    public final boolean getRelaxed() {
        return this.booleanProperty("relaxed", "false");
    }

    public final boolean getRelaxUnitFun() {
        return this.booleanProperty("relaxUnitFun", "false");
    }

    public final boolean getRecordPrivateCalls() {
        return this.booleanProperty("recordPrivateCalls", "false");
    }

    public final boolean getStackTracesOnVerify() {
        return this.booleanProperty("stackTracesOnVerify", "true");
    }

    @NotNull
    public final StackTracesAlignment getStackTracesAlignment() {
        String string = properties.getProperty("stackTracesAlignment", "center");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"properties.getProperty(\"\u2026acesAlignment\", \"center\")");
        return MockKSettingsKt.stackTracesAlignmentValueOf(string);
    }

    public final void setRelaxed(boolean value) {
        properties.setProperty("relaxed", String.valueOf(value));
    }

    public final void setRelaxUnitFun(boolean value) {
        properties.setProperty("relaxUnitFun", String.valueOf(value));
    }

    public final void setRecordPrivateCalls(boolean value) {
        properties.setProperty("recordPrivateCalls", String.valueOf(value));
    }

    public final void setStackTracesAlignment(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        properties.setProperty("stackTracesAlignment", value);
    }

    private MockKSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        MockKSettings mockKSettings;
        INSTANCE = mockKSettings = new MockKSettings();
        properties = new Properties();
        InputStream inputStream = MockKSettings.class.getResourceAsStream("settings.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Properties properties = MockKSettings.properties;
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream p1 = (InputStream)closeable;
                boolean bl2 = false;
                properties.load(p1);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

