/*
 * Decompiled with CFR 0.152.
 */
package io.mockk;

import io.mockk.MockKSettingsKt;
import io.mockk.StackTracesAlignment;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006 "}, d2={"Lio/mockk/MockKSettings;", "", "()V", "failOnSetBackingFieldException", "", "getFailOnSetBackingFieldException", "()Z", "properties", "Ljava/util/Properties;", "recordPrivateCalls", "getRecordPrivateCalls", "relaxUnitFun", "getRelaxUnitFun", "relaxed", "getRelaxed", "stackTracesAlignment", "Lio/mockk/StackTracesAlignment;", "getStackTracesAlignment", "()Lio/mockk/StackTracesAlignment;", "stackTracesOnVerify", "getStackTracesOnVerify", "booleanProperty", "property", "", "defaultValue", "setFailOnSetBackingFieldException", "", "value", "setRecordPrivateCalls", "setRelaxUnitFun", "setRelaxed", "setStackTracesAlignment", "mockk-dsl"})
@SourceDebugExtension(value={"SMAP\nMockKSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockKSettings.kt\nio/mockk/MockKSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class MockKSettings {
    @NotNull
    public static final MockKSettings INSTANCE = new MockKSettings();
    @NotNull
    private static final Properties properties = new Properties();

    private MockKSettings() {
    }

    private final boolean booleanProperty(String property, String defaultValue) {
        String string = properties.getProperty(property, defaultValue);
        Intrinsics.checkNotNull((Object)string);
        return Boolean.parseBoolean(string);
    }

    public final boolean getRelaxed() {
        return this.booleanProperty("relaxed", "false");
    }

    public final boolean getRelaxUnitFun() {
        return this.booleanProperty("relaxUnitFun", "false");
    }

    public final boolean getRecordPrivateCalls() {
        return this.booleanProperty("recordPrivateCalls", "false");
    }

    public final boolean getStackTracesOnVerify() {
        return this.booleanProperty("stackTracesOnVerify", "true");
    }

    @NotNull
    public final StackTracesAlignment getStackTracesAlignment() {
        String string = properties.getProperty("stackTracesAlignment", "center");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getProperty(\"\u2026acesAlignment\", \"center\")");
        return MockKSettingsKt.stackTracesAlignmentValueOf(string);
    }

    public final boolean getFailOnSetBackingFieldException() {
        return this.booleanProperty("failOnSetBackingFieldException", "false");
    }

    public final void setRelaxed(boolean value) {
        properties.setProperty("relaxed", String.valueOf(value));
    }

    public final void setRelaxUnitFun(boolean value) {
        properties.setProperty("relaxUnitFun", String.valueOf(value));
    }

    public final void setRecordPrivateCalls(boolean value) {
        properties.setProperty("recordPrivateCalls", String.valueOf(value));
    }

    public final void setStackTracesAlignment(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        properties.setProperty("stackTracesAlignment", value);
    }

    public final void setFailOnSetBackingFieldException(boolean value) {
        properties.setProperty("failOnSetBackingFieldException", String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = MockKSettings.class.getResourceAsStream("settings.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Properties properties = MockKSettings.properties;
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)closeable;
                boolean bl = false;
                properties.load(p0);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

