/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import android.content.Context;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.MarkwonBuilderImpl;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.core.CorePlugin;
import java.util.List;
import org.commonmark.node.Node;

public abstract class Markwon {
    @NonNull
    public static Markwon create(@NonNull Context context) {
        return Markwon.builder(context).usePlugin(CorePlugin.create()).build();
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new MarkwonBuilderImpl(context).usePlugin(CorePlugin.create());
    }

    @NonNull
    public static Builder builderNoCore(@NonNull Context context) {
        return new MarkwonBuilderImpl(context);
    }

    @NonNull
    public abstract Node parse(@NonNull String var1);

    @NonNull
    public abstract Spanned render(@NonNull Node var1);

    @NonNull
    public abstract Spanned toMarkdown(@NonNull String var1);

    public abstract void setMarkdown(@NonNull TextView var1, @NonNull String var2);

    public abstract void setParsedMarkdown(@NonNull TextView var1, @NonNull Spanned var2);

    public abstract boolean hasPlugin(@NonNull Class<? extends MarkwonPlugin> var1);

    @Nullable
    public abstract <P extends MarkwonPlugin> P getPlugin(@NonNull Class<P> var1);

    @NonNull
    public abstract <P extends MarkwonPlugin> P requirePlugin(@NonNull Class<P> var1);

    @NonNull
    public abstract List<? extends MarkwonPlugin> getPlugins();

    @NonNull
    public abstract MarkwonConfiguration configuration();

    public static interface Builder {
        @NonNull
        public Builder bufferType(@NonNull TextView.BufferType var1);

        @NonNull
        public Builder textSetter(@NonNull TextSetter var1);

        @NonNull
        public Builder usePlugin(@NonNull MarkwonPlugin var1);

        @NonNull
        public Builder usePlugins(@NonNull Iterable<? extends MarkwonPlugin> var1);

        @NonNull
        public Builder fallbackToRawInputWhenEmpty(boolean var1);

        @NonNull
        public Markwon build();
    }

    public static interface TextSetter {
        public void setText(@NonNull TextView var1, @NonNull Spanned var2, @NonNull TextView.BufferType var3, @NonNull Runnable var4);
    }
}

