/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import android.content.Context;
import android.widget.TextView;
import androidx.annotation.NonNull;
import io.noties.markwon.Markwon;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonImpl;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.MarkwonSpansFactoryImpl;
import io.noties.markwon.MarkwonVisitorFactory;
import io.noties.markwon.MarkwonVisitorImpl;
import io.noties.markwon.RegistryImpl;
import io.noties.markwon.core.MarkwonTheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.parser.Parser;

class MarkwonBuilderImpl
implements Markwon.Builder {
    private final Context context;
    private final List<MarkwonPlugin> plugins = new ArrayList<MarkwonPlugin>(3);
    private TextView.BufferType bufferType = TextView.BufferType.SPANNABLE;
    private Markwon.TextSetter textSetter;
    private boolean fallbackToRawInputWhenEmpty = true;

    MarkwonBuilderImpl(@NonNull Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    public Markwon.Builder bufferType(@NonNull TextView.BufferType bufferType) {
        this.bufferType = bufferType;
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder textSetter(@NonNull Markwon.TextSetter textSetter) {
        this.textSetter = textSetter;
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder usePlugin(@NonNull MarkwonPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder usePlugins(@NonNull Iterable<? extends MarkwonPlugin> plugins) {
        for (MarkwonPlugin markwonPlugin : plugins) {
            if (markwonPlugin == null) {
                throw new NullPointerException();
            }
            this.plugins.add(markwonPlugin);
        }
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder fallbackToRawInputWhenEmpty(boolean fallbackToRawInputWhenEmpty) {
        this.fallbackToRawInputWhenEmpty = fallbackToRawInputWhenEmpty;
        return this;
    }

    @Override
    @NonNull
    public Markwon build() {
        if (this.plugins.isEmpty()) {
            throw new IllegalStateException("No plugins were added to this builder. Use #usePlugin method to add them");
        }
        List<MarkwonPlugin> plugins = MarkwonBuilderImpl.preparePlugins(this.plugins);
        Parser.Builder parserBuilder = new Parser.Builder();
        MarkwonTheme.Builder themeBuilder = MarkwonTheme.builderWithDefaults(this.context);
        MarkwonConfiguration.Builder configurationBuilder = new MarkwonConfiguration.Builder();
        MarkwonVisitorImpl.BuilderImpl visitorBuilder = new MarkwonVisitorImpl.BuilderImpl();
        MarkwonSpansFactoryImpl.BuilderImpl spanFactoryBuilder = new MarkwonSpansFactoryImpl.BuilderImpl();
        for (MarkwonPlugin plugin : plugins) {
            plugin.configureParser(parserBuilder);
            plugin.configureTheme(themeBuilder);
            plugin.configureConfiguration(configurationBuilder);
            plugin.configureVisitor(visitorBuilder);
            plugin.configureSpansFactory(spanFactoryBuilder);
        }
        MarkwonConfiguration configuration = configurationBuilder.build(themeBuilder.build(), spanFactoryBuilder.build());
        MarkwonVisitorFactory visitorFactory = MarkwonVisitorFactory.create(visitorBuilder, configuration);
        return new MarkwonImpl(this.bufferType, this.textSetter, parserBuilder.build(), visitorFactory, configuration, Collections.unmodifiableList(plugins), this.fallbackToRawInputWhenEmpty);
    }

    @NonNull
    private static List<MarkwonPlugin> preparePlugins(@NonNull List<MarkwonPlugin> plugins) {
        return new RegistryImpl(plugins).process();
    }
}

