/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.Markwon;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.MarkwonVisitorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;

class MarkwonImpl
extends Markwon {
    private final TextView.BufferType bufferType;
    private final Parser parser;
    private final MarkwonVisitorFactory visitorFactory;
    private final MarkwonConfiguration configuration;
    private final List<MarkwonPlugin> plugins;
    @Nullable
    private final Markwon.TextSetter textSetter;
    private final boolean fallbackToRawInputWhenEmpty;

    MarkwonImpl(@NonNull TextView.BufferType bufferType, @Nullable Markwon.TextSetter textSetter, @NonNull Parser parser, @NonNull MarkwonVisitorFactory visitorFactory, @NonNull MarkwonConfiguration configuration, @NonNull List<MarkwonPlugin> plugins, boolean fallbackToRawInputWhenEmpty) {
        this.bufferType = bufferType;
        this.textSetter = textSetter;
        this.parser = parser;
        this.visitorFactory = visitorFactory;
        this.configuration = configuration;
        this.plugins = plugins;
        this.fallbackToRawInputWhenEmpty = fallbackToRawInputWhenEmpty;
    }

    @Override
    @NonNull
    public Node parse(@NonNull String input) {
        for (MarkwonPlugin plugin : this.plugins) {
            input = plugin.processMarkdown(input);
        }
        return this.parser.parse(input);
    }

    @Override
    @NonNull
    public Spanned render(@NonNull Node node) {
        for (MarkwonPlugin markwonPlugin : this.plugins) {
            markwonPlugin.beforeRender(node);
        }
        MarkwonVisitor visitor = this.visitorFactory.create();
        node.accept((Visitor)visitor);
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.afterRender(node, visitor);
        }
        SpannableStringBuilder spannableStringBuilder = visitor.builder().spannableStringBuilder();
        return spannableStringBuilder;
    }

    @Override
    @NonNull
    public Spanned toMarkdown(@NonNull String input) {
        Spanned spanned = this.render(this.parse(input));
        if (TextUtils.isEmpty((CharSequence)spanned) && this.fallbackToRawInputWhenEmpty && !TextUtils.isEmpty((CharSequence)input)) {
            return new SpannableStringBuilder((CharSequence)input);
        }
        return spanned;
    }

    @Override
    public void setMarkdown(@NonNull TextView textView, @NonNull String markdown) {
        this.setParsedMarkdown(textView, this.toMarkdown(markdown));
    }

    @Override
    public void setParsedMarkdown(final @NonNull TextView textView, @NonNull Spanned markdown) {
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.beforeSetText(textView, markdown);
        }
        if (this.textSetter != null) {
            this.textSetter.setText(textView, markdown, this.bufferType, new Runnable(){

                @Override
                public void run() {
                    for (MarkwonPlugin plugin : MarkwonImpl.this.plugins) {
                        plugin.afterSetText(textView);
                    }
                }
            });
        } else {
            textView.setText((CharSequence)markdown, this.bufferType);
            for (MarkwonPlugin plugin : this.plugins) {
                plugin.afterSetText(textView);
            }
        }
    }

    @Override
    public boolean hasPlugin(@NonNull Class<? extends MarkwonPlugin> type) {
        return this.getPlugin(type) != null;
    }

    @Override
    @Nullable
    public <P extends MarkwonPlugin> P getPlugin(@NonNull Class<P> type) {
        MarkwonPlugin out = null;
        for (MarkwonPlugin plugin : this.plugins) {
            if (!type.isAssignableFrom(plugin.getClass())) continue;
            out = plugin;
        }
        return (P)out;
    }

    @Override
    @NonNull
    public <P extends MarkwonPlugin> P requirePlugin(@NonNull Class<P> type) {
        P plugin = this.getPlugin(type);
        if (plugin == null) {
            throw new IllegalStateException(String.format(Locale.US, "Requested plugin `%s` is not registered with this Markwon instance", type.getName()));
        }
        return plugin;
    }

    @Override
    @NonNull
    public List<? extends MarkwonPlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    @NonNull
    public MarkwonConfiguration configuration() {
        return this.configuration;
    }
}

