/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import android.os.Build;
import android.text.Spanned;
import android.util.Log;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.text.PrecomputedTextCompat;
import io.noties.markwon.Markwon;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

public class PrecomputedTextSetterCompat
implements Markwon.TextSetter {
    private final Executor executor;

    @NonNull
    public static PrecomputedTextSetterCompat create(@NonNull Executor executor) {
        return new PrecomputedTextSetterCompat(executor);
    }

    PrecomputedTextSetterCompat(@NonNull Executor executor) {
        this.executor = executor;
    }

    @Override
    public void setText(@NonNull TextView textView, final @NonNull Spanned markdown, final @NonNull TextView.BufferType bufferType, final @NonNull Runnable onComplete) {
        if (Build.VERSION.SDK_INT < 21) {
            PrecomputedTextSetterCompat.applyText(textView, markdown, bufferType, onComplete);
            return;
        }
        final WeakReference<TextView> reference = new WeakReference<TextView>(textView);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PrecomputedTextCompat precomputedTextCompat = PrecomputedTextSetterCompat.precomputedText((TextView)reference.get(), markdown);
                    if (precomputedTextCompat != null) {
                        PrecomputedTextSetterCompat.applyText((TextView)reference.get(), (Spanned)precomputedTextCompat, bufferType, onComplete);
                    }
                }
                catch (Throwable t) {
                    Log.e((String)"PrecomputdTxtSetterCmpt", (String)"Exception during pre-computing text", (Throwable)t);
                    PrecomputedTextSetterCompat.applyText((TextView)reference.get(), markdown, bufferType, onComplete);
                }
            }
        });
    }

    @Nullable
    private static PrecomputedTextCompat precomputedText(@Nullable TextView textView, @NonNull Spanned spanned) {
        PrecomputedTextCompat.Params params;
        if (textView == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            params = new PrecomputedTextCompat.Params(textView.getTextMetricsParams());
        } else {
            PrecomputedTextCompat.Params.Builder builder = new PrecomputedTextCompat.Params.Builder(textView.getPaint());
            if (Build.VERSION.SDK_INT >= 23) {
                builder.setBreakStrategy(textView.getBreakStrategy()).setHyphenationFrequency(textView.getHyphenationFrequency());
            }
            params = builder.build();
        }
        return PrecomputedTextCompat.create((CharSequence)spanned, (PrecomputedTextCompat.Params)params);
    }

    private static void applyText(final @Nullable TextView textView, final @NonNull Spanned text, final @NonNull TextView.BufferType bufferType, final @NonNull Runnable onComplete) {
        if (textView != null) {
            textView.post(new Runnable(){

                @Override
                public void run() {
                    textView.setText((CharSequence)text, bufferType);
                    onComplete.run();
                }
            });
        }
    }
}

