/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.RenderProps;

public class Prop<T> {
    private final String name;

    @NonNull
    public static <T> Prop<T> of(@NonNull Class<T> type, @NonNull String name) {
        return new Prop<T>(name);
    }

    @NonNull
    public static <T> Prop<T> of(@NonNull String name) {
        return new Prop<T>(name);
    }

    Prop(@NonNull String name) {
        this.name = name;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @Nullable
    public T get(@NonNull RenderProps props) {
        return props.get(this);
    }

    @NonNull
    public T get(@NonNull RenderProps props, @NonNull T defValue) {
        return props.get(this, defValue);
    }

    @NonNull
    public T require(@NonNull RenderProps props) {
        T t = this.get(props);
        if (t == null) {
            throw new NullPointerException(this.name);
        }
        return t;
    }

    public void set(@NonNull RenderProps props, @Nullable T value) {
        props.set(this, value);
    }

    public void clear(@NonNull RenderProps props) {
        props.clear(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prop prop = (Prop)o;
        return this.name.equals(prop.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Prop{name='" + this.name + '\'' + '}';
    }
}

