/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.core.CorePlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RegistryImpl
implements MarkwonPlugin.Registry {
    private final List<MarkwonPlugin> origin;
    private final List<MarkwonPlugin> plugins;
    private final Set<MarkwonPlugin> pending;

    RegistryImpl(@NonNull List<MarkwonPlugin> origin) {
        this.origin = origin;
        this.plugins = new ArrayList<MarkwonPlugin>(origin.size());
        this.pending = new HashSet<MarkwonPlugin>(3);
    }

    @Override
    @NonNull
    public <P extends MarkwonPlugin> P require(@NonNull Class<P> plugin) {
        return this.get(plugin);
    }

    @Override
    public <P extends MarkwonPlugin> void require(@NonNull Class<P> plugin, @NonNull MarkwonPlugin.Action<? super P> action) {
        action.apply(this.get(plugin));
    }

    @NonNull
    List<MarkwonPlugin> process() {
        for (MarkwonPlugin plugin : this.origin) {
            this.configure(plugin);
        }
        return this.plugins;
    }

    private void configure(@NonNull MarkwonPlugin plugin) {
        if (!this.plugins.contains(plugin)) {
            if (this.pending.contains(plugin)) {
                throw new IllegalStateException("Cyclic dependency chain found: " + this.pending);
            }
            this.pending.add(plugin);
            plugin.configure(this);
            this.pending.remove(plugin);
            if (!this.plugins.contains(plugin)) {
                if (CorePlugin.class.isAssignableFrom(plugin.getClass())) {
                    this.plugins.add(0, plugin);
                } else {
                    this.plugins.add(plugin);
                }
            }
        }
    }

    @NonNull
    private <P extends MarkwonPlugin> P get(@NonNull Class<P> type) {
        P plugin = RegistryImpl.find(this.plugins, type);
        if (plugin == null) {
            plugin = RegistryImpl.find(this.origin, type);
            if (plugin == null) {
                throw new IllegalStateException("Requested plugin is not added: " + type.getName() + ", plugins: " + this.origin);
            }
            this.configure((MarkwonPlugin)plugin);
        }
        return plugin;
    }

    @Nullable
    private static <P extends MarkwonPlugin> P find(@NonNull List<MarkwonPlugin> plugins, @NonNull Class<P> type) {
        for (MarkwonPlugin plugin : plugins) {
            if (!type.isAssignableFrom(plugin.getClass())) continue;
            return (P)plugin;
        }
        return null;
    }
}

